/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionDefinitionQueryTest {
    protected static final String DMN_ONE_RESOURCE = "org/camunda/bpm/engine/test/repository/one.dmn";
    protected static final String DMN_TWO_RESOURCE = "org/camunda/bpm/engine/test/repository/two.dmn";
    protected static final String DMN_THREE_RESOURCE = "org/camunda/bpm/engine/test/api/repository/three_.dmn";
    protected static final String DRD_SCORE_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected String decisionRequirementsDefinitionId;
    protected String firstDeploymentId;
    protected String secondDeploymentId;
    protected String thirdDeploymentId;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.firstDeploymentId = this.testRule.deploy(DMN_ONE_RESOURCE, DMN_TWO_RESOURCE).getId();
        this.secondDeploymentId = this.testRule.deploy(DMN_ONE_RESOURCE).getId();
        this.thirdDeploymentId = this.testRule.deploy(DMN_THREE_RESOURCE).getId();
    }

    @Test
    public void decisionDefinitionProperties() {
        List decisionDefinitions = ((DecisionDefinitionQuery)((DecisionDefinitionQuery)((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionName().asc()).orderByDecisionDefinitionVersion().asc()).orderByDecisionDefinitionCategory().asc()).list();
        DecisionDefinition decisionDefinition = (DecisionDefinition)decisionDefinitions.get(0);
        Assert.assertEquals((Object)"one", (Object)decisionDefinition.getKey());
        Assert.assertEquals((Object)"One", (Object)decisionDefinition.getName());
        Assert.assertTrue((boolean)decisionDefinition.getId().startsWith("one:1"));
        Assert.assertEquals((Object)"Examples", (Object)decisionDefinition.getCategory());
        Assert.assertEquals((long)1L, (long)decisionDefinition.getVersion());
        Assert.assertEquals((Object)DMN_ONE_RESOURCE, (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)this.firstDeploymentId, (Object)decisionDefinition.getDeploymentId());
        decisionDefinition = (DecisionDefinition)decisionDefinitions.get(1);
        Assert.assertEquals((Object)"one", (Object)decisionDefinition.getKey());
        Assert.assertEquals((Object)"One", (Object)decisionDefinition.getName());
        Assert.assertTrue((boolean)decisionDefinition.getId().startsWith("one:2"));
        Assert.assertEquals((Object)"Examples", (Object)decisionDefinition.getCategory());
        Assert.assertEquals((long)2L, (long)decisionDefinition.getVersion());
        Assert.assertEquals((Object)DMN_ONE_RESOURCE, (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)this.secondDeploymentId, (Object)decisionDefinition.getDeploymentId());
        decisionDefinition = (DecisionDefinition)decisionDefinitions.get(2);
        Assert.assertEquals((Object)"two", (Object)decisionDefinition.getKey());
        Assert.assertEquals((Object)"Two", (Object)decisionDefinition.getName());
        Assert.assertTrue((boolean)decisionDefinition.getId().startsWith("two:1"));
        Assert.assertEquals((Object)"Examples2", (Object)decisionDefinition.getCategory());
        Assert.assertEquals((long)1L, (long)decisionDefinition.getVersion());
        Assert.assertEquals((Object)DMN_TWO_RESOURCE, (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)this.firstDeploymentId, (Object)decisionDefinition.getDeploymentId());
    }

    @Test
    public void queryByDecisionDefinitionIds() {
        Assert.assertTrue((boolean)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionIdIn(new String[]{"a", "b"}).list().isEmpty());
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().list();
        ArrayList<String> ids = new ArrayList<String>();
        for (DecisionDefinition decisionDefinition : decisionDefinitions) {
            ids.add(decisionDefinition.getId());
        }
        decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionIdIn(ids.toArray(new String[ids.size()])).list();
        Assert.assertEquals((long)ids.size(), (long)decisionDefinitions.size());
        for (DecisionDefinition decisionDefinition : decisionDefinitions) {
            if (ids.contains(decisionDefinition.getId())) continue;
            Assert.fail((String)("Expected to find decision definition " + decisionDefinition));
        }
    }

    @Test
    public void queryByDeploymentId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.deploymentId(this.firstDeploymentId);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void queryByInvalidDeploymentId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.deploymentId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByName() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionName("Two");
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionName("One");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void queryByInvalidName() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.decisionDefinitionName(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionNameLike("%w%");
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionNameLike("%z\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            query.decisionDefinitionNameLike(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByResourceNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionResourceNameLike("%ree%");
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionResourceNameLike("%ee\\_%");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidNResourceNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionResourceNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            query.decisionDefinitionNameLike(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKey("one");
        this.verifyQueryResults(query, 2);
        query.decisionDefinitionKey("two");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.decisionDefinitionKey(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByKeyLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKeyLike("%o%");
        this.verifyQueryResults(query, 3);
        query.decisionDefinitionKeyLike("%z\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidKeyLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKeyLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            query.decisionDefinitionKeyLike(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByCategory() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategory("Examples");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void queryByInvalidCategory() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategory("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.decisionDefinitionCategory(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByCategoryLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategoryLike("%Example%");
        this.verifyQueryResults(query, 3);
        query.decisionDefinitionCategoryLike("%amples2");
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionCategoryLike("%z\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidCategoryLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategoryLike("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.decisionDefinitionCategoryLike(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByVersion() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void queryByInvalidVersion() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults(query, 0);
        try {
            query.decisionDefinitionVersion(Integer.valueOf(-1));
            Assert.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.decisionDefinitionVersion(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByLatest() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.latestVersion();
        this.verifyQueryResults(query, 3);
        query.decisionDefinitionKey("one").latestVersion();
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionKey("two").latestVersion();
        this.verifyQueryResults(query, 1);
    }

    public void testInvalidUsageOfLatest() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        try {
            query.decisionDefinitionId("test").latestVersion().list();
            Assert.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.decisionDefinitionName("test").latestVersion().list();
            Assert.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.decisionDefinitionNameLike("test").latestVersion().list();
            Assert.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.decisionDefinitionVersion(Integer.valueOf(1)).latestVersion().list();
            Assert.fail();
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            query.deploymentId("test").latestVersion().list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void queryByDecisionRequirementsDefinitionId() {
        this.testRule.deploy(DRD_DISH_RESOURCE, DRD_SCORE_RESOURCE);
        List drds = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionName().asc()).list();
        String dishDrdId = ((DecisionRequirementsDefinition)drds.get(0)).getId();
        String scoreDrdId = ((DecisionRequirementsDefinition)drds.get(1)).getId();
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults(query.decisionRequirementsDefinitionId("non existing"), 0);
        this.verifyQueryResults(query.decisionRequirementsDefinitionId(dishDrdId), 3);
        this.verifyQueryResults(query.decisionRequirementsDefinitionId(scoreDrdId), 2);
    }

    @Test
    public void queryByDecisionRequirementsDefinitionKey() {
        this.testRule.deploy(DRD_DISH_RESOURCE, DRD_SCORE_RESOURCE);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults(query.decisionRequirementsDefinitionKey("non existing"), 0);
        this.verifyQueryResults(query.decisionRequirementsDefinitionKey("dish"), 3);
        this.verifyQueryResults(query.decisionRequirementsDefinitionKey("score"), 2);
    }

    @Test
    public void queryByWithoutDecisionRequirementsDefinition() {
        this.testRule.deploy(DRD_DISH_RESOURCE, DRD_SCORE_RESOURCE);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults(query, 9);
        this.verifyQueryResults(query.withoutDecisionRequirementsDefinition(), 4);
    }

    @Test
    public void querySorting() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionId().asc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDeploymentId().asc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionKey().asc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionVersion().asc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionId().desc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDeploymentId().desc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionKey().desc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionVersion().desc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        ((DecisionDefinitionQuery)query.orderByDecisionDefinitionKey().asc()).orderByDecisionDefinitionVersion().desc();
        List decisionDefinitions = query.list();
        Assert.assertEquals((long)4L, (long)decisionDefinitions.size());
        Assert.assertEquals((Object)"one", (Object)((DecisionDefinition)decisionDefinitions.get(0)).getKey());
        Assert.assertEquals((long)2L, (long)((DecisionDefinition)decisionDefinitions.get(0)).getVersion());
        Assert.assertEquals((Object)"one", (Object)((DecisionDefinition)decisionDefinitions.get(1)).getKey());
        Assert.assertEquals((long)1L, (long)((DecisionDefinition)decisionDefinitions.get(1)).getVersion());
        Assert.assertEquals((Object)"two", (Object)((DecisionDefinition)decisionDefinitions.get(2)).getKey());
        Assert.assertEquals((long)1L, (long)((DecisionDefinition)decisionDefinitions.get(2)).getVersion());
    }

    protected void verifyQueryResults(DecisionDefinitionQuery query, int expectedCount) {
        Assert.assertEquals((long)expectedCount, (long)query.count());
        Assert.assertEquals((long)expectedCount, (long)query.list().size());
    }
}

