/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;

public class ProcessInstanceModificationEventSubProcessTest
extends PluggableProcessEngineTestCase {
    protected static final String INTERRUPTING_EVENT_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml";
    protected static final String NON_INTERRUPTING_EVENT_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcess.bpmn20.xml";
    protected static final String INTERRUPTING_EVENT_SUBPROCESS_INSIDE_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcessInsideSubProcess.bpmn20.xml";
    protected static final String NON_INTERRUPTING_EVENT_SUBPROCESS_INSIDE_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcessInsideSubProcess.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml"})
    public void testStartBeforeTaskInsideEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcessTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "task2", "eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml"})
    public void testStartBeforeTaskInsideEventSubProcessAndCancelTaskOutsideEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("eventSubProcessTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml"})
    public void testStartBeforeStartEventInsideEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventProcessStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml"})
    public void testStartBeforeEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcess.bpmn20.xml"})
    public void testStartBeforeTaskInsideNonInterruptingEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcessTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "eventSubProcessTask", "task2");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcess.bpmn20.xml"})
    public void testStartBeforeTaskInsideNonInterruptingEventSubProcessAndCancelTaskOutsideEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("eventSubProcessTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcess.bpmn20.xml"})
    public void testStartBeforeStartEventInsideNonInterruptingEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventProcessStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "task2", "eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcess.bpmn20.xml"})
    public void testStartBeforeNonInterruptingEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "eventSubProcessTask", "task2");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeTaskInsideEventSubProcessInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcessTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "eventSubProcessTask", "task2");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeStartEventInsideEventSubProcessInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventProcessStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("eventSubProcessTask", "task1", "task2");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeEventSubProcessInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "eventSubProcessTask", "task2");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeTaskInsideEventSubProcessInsideSubProcessTask2ShouldStay() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcessTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("task2").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task2").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task2", "eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeStartEventInsideEventSubProcessInsideSubProcessTask2ShouldBeCancelled() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventProcessStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeEventSubProcessInsideSubProcessTask2ShouldBeCancelled() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeTaskInsideNonInterruptingEventSubProcessInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcessTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "eventSubProcessTask", "task2");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeStartEventInsideNonInterruptingEventSubProcessInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventProcessStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "task2", "eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeNonInterruptingEventSubProcessInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task1", "task2", "eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeTaskInsideNonInterruptingEventSubProcessInsideSubProcessTask2ShouldStay() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcessTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("task2").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task2").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task2", "eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeStartEventInsideNonInterruptingEventSubProcessInsideSubProcessTask2ShouldStay() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventProcessStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("task2").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task2").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task2", "eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingEventSubProcessInsideSubProcess.bpmn20.xml"})
    public void testStartBeforeNonInterruptingEventSubProcessInsideSubProcessTask2ShouldStay() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("eventSubProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("task2").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task2").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.completeTasksInOrder("task2", "eventSubProcessTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testTimerJobPreservationOnCancellationAndStart() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("timerEventSubProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Job timerJob = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)timerJob);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task")).startBeforeActivity("task")).execute();
        Job remainingTimerJob = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationEventSubProcessTest.assertNotNull((Object)remainingTimerJob);
        ProcessInstanceModificationEventSubProcessTest.assertEquals((String)timerJob.getId(), (String)remainingTimerJob.getId());
        ProcessInstanceModificationEventSubProcessTest.assertEquals((Object)timerJob.getDuedate(), (Object)remainingTimerJob.getDuedate());
    }

    protected String getInstanceIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance instance = this.getChildInstanceForActivity(activityInstance, activityId);
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            if (!childInstance.getActivityId().equals(activityId)) continue;
            return childInstance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            ProcessInstanceModificationEventSubProcessTest.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

