/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.job;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobPriorityProvider;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.Deployment;

public class JobPrioritizationBpmnExpressionValueTest
extends PluggableProcessEngineTestCase {
    protected static final long EXPECTED_DEFAULT_PRIORITY = 123L;
    protected static final long EXPECTED_DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE = 296L;
    protected long originalDefaultPriority;
    protected long originalDefaultPriorityOnFailure;

    protected void setUp() throws Exception {
        this.originalDefaultPriority = DefaultJobPriorityProvider.DEFAULT_PRIORITY;
        this.originalDefaultPriorityOnFailure = DefaultJobPriorityProvider.DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE;
        DefaultJobPriorityProvider.DEFAULT_PRIORITY = 123L;
        DefaultJobPriorityProvider.DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE = 296L;
    }

    protected void tearDown() throws Exception {
        DefaultJobPriorityProvider.DEFAULT_PRIORITY = this.originalDefaultPriority;
        DefaultJobPriorityProvider.DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE = this.originalDefaultPriorityOnFailure;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testConstantValueExpressionPrioritization() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnExpressionValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnExpressionValueTest.assertEquals((long)15L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testConstantValueHashExpressionPrioritization() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task4")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnExpressionValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnExpressionValueTest.assertEquals((long)16L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testVariableValueExpressionPrioritization() {
        ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).setVariable("priority", (Object)22)).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnExpressionValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnExpressionValueTest.assertEquals((long)22L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void FAILING_testVariableValueExpressionPrioritizationFailsWhenVariableMisses() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).execute();
            JobPrioritizationBpmnExpressionValueTest.fail((String)"this should not succeed since the priority variable is not defined");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("Unknown property used in expression: ${priority}. Cause: Cannot resolve identifier 'priority'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testExecutionExpressionPrioritization() {
        ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).setVariable("priority", (Object)25)).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnExpressionValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnExpressionValueTest.assertEquals((long)25L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testExpressionEvaluatesToNull() {
        try {
            ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task3")).setVariable("priority", null)).execute();
            JobPrioritizationBpmnExpressionValueTest.fail((String)"this should not succeed since the priority variable is not defined");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("Priority value is not an Integer", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testExpressionEvaluatesToNonNumericalValue() {
        try {
            ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task3")).setVariable("priority", (Object)"aNonNumericalVariableValue")).execute();
            JobPrioritizationBpmnExpressionValueTest.fail((String)"this should not succeed since the priority must be integer");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("Priority value is not an Integer", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testExpressionEvaluatesToNonIntegerValue() {
        try {
            ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task3")).setVariable("priority", (Object)4.2)).execute();
            JobPrioritizationBpmnExpressionValueTest.fail((String)"this should not succeed since the priority must be integer");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("Priority value must be either Short, Integer, or Long", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testConcurrentLocalVariablesAreAccessible() {
        ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task2")).startBeforeActivity("task1")).setVariableLocal("priority", (Object)14)).execute();
        Job job = (Job)this.managementService.createJobQuery().activityId("task1").singleResult();
        JobPrioritizationBpmnExpressionValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnExpressionValueTest.assertEquals((long)14L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testDefaultPriorityWhenBeanMisses() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnExpressionValueTest.assertEquals((long)296L, (long)job.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    public void testDisableGracefulDegradation() {
        try {
            this.processEngineConfiguration.setEnableGracefulDegradationOnContextSwitchFailure(false);
            try {
                ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).execute();
                JobPrioritizationBpmnExpressionValueTest.fail((String)"should not succeed due to missing variable");
            }
            catch (ProcessEngineException e) {
                this.assertTextPresentIgnoreCase("unknown property used in expression", e.getMessage());
            }
        }
        finally {
            this.processEngineConfiguration.setEnableGracefulDegradationOnContextSwitchFailure(true);
        }
    }

    public void testDefaultEngineConfigurationSetting() {
        StandaloneInMemProcessEngineConfiguration config = new StandaloneInMemProcessEngineConfiguration();
        JobPrioritizationBpmnExpressionValueTest.assertTrue((boolean)config.isEnableGracefulDegradationOnContextSwitchFailure());
    }
}

