/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.mail.EmailTestCase;
import org.subethamail.wiser.WiserMessage;

public class EmailSendTaskTest
extends EmailTestCase {
    @Deployment
    public void testSimpleTextMail() throws Exception {
        this.runtimeService.startProcessInstanceByKey("simpleTextOnly");
        List messages = this.wiser.getMessages();
        EmailSendTaskTest.assertEquals((int)1, (int)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        this.assertEmailSend(message, false, "Hello Kermit!", "This a text only e-mail.", "camunda@localhost", Arrays.asList("kermit@camunda.org"), null);
    }

    @Deployment
    public void testSimpleTextMailMultipleRecipients() {
        this.runtimeService.startProcessInstanceByKey("simpleTextOnlyMultipleRecipients");
        List messages = this.wiser.getMessages();
        EmailSendTaskTest.assertEquals((int)3, (int)messages.size());
        ArrayList<String> recipients = new ArrayList<String>();
        for (WiserMessage message : messages) {
            recipients.add(message.getEnvelopeReceiver());
        }
        Collections.sort(recipients);
        EmailSendTaskTest.assertEquals((String)"fozzie@camunda.org", (String)((String)recipients.get(0)));
        EmailSendTaskTest.assertEquals((String)"kermit@camunda.org", (String)((String)recipients.get(1)));
        EmailSendTaskTest.assertEquals((String)"mispiggy@camunda.org", (String)((String)recipients.get(2)));
    }

    @Deployment
    public void testTextMailExpressions() throws Exception {
        String sender = "mispiggy@activiti.org";
        String recipient = "fozziebear@activiti.org";
        String recipientName = "Mr. Fozzie";
        String subject = "Fozzie, you should see this!";
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("sender", sender);
        vars.put("recipient", recipient);
        vars.put("recipientName", recipientName);
        vars.put("subject", subject);
        this.runtimeService.startProcessInstanceByKey("textMailExpressions", vars);
        List messages = this.wiser.getMessages();
        EmailSendTaskTest.assertEquals((int)1, (int)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        this.assertEmailSend(message, false, subject, "Hello " + recipientName + ", this is an e-mail", sender, Arrays.asList(recipient), null);
    }

    @Deployment
    public void testCcAndBcc() throws Exception {
        this.runtimeService.startProcessInstanceByKey("ccAndBcc");
        List messages = this.wiser.getMessages();
        this.assertEmailSend((WiserMessage)messages.get(0), false, "Hello world", "This is the content", "camunda@localhost", Arrays.asList("kermit@camunda.org"), Arrays.asList("fozzie@camunda.org"));
        EmailSendTaskTest.assertEquals((int)3, (int)messages.size());
    }

    @Deployment
    public void testHtmlMail() throws Exception {
        this.runtimeService.startProcessInstanceByKey("htmlMail", CollectionUtil.singletonMap((String)"gender", (Object)"male"));
        List messages = this.wiser.getMessages();
        EmailSendTaskTest.assertEquals((int)1, (int)messages.size());
        this.assertEmailSend((WiserMessage)messages.get(0), true, "Test", "Mr. <b>Kermit</b>", "camunda@localhost", Arrays.asList("kermit@camunda.org"), null);
    }

    @Deployment
    public void testSendEmail() throws Exception {
        String from = "ordershipping@activiti.org";
        boolean male = true;
        String recipientName = "John Doe";
        String recipient = "johndoe@alfresco.com";
        Date now = new Date();
        String orderId = "123456";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("sender", from);
        vars.put("recipient", recipient);
        vars.put("recipientName", recipientName);
        vars.put("male", male);
        vars.put("now", now);
        vars.put("orderId", orderId);
        this.runtimeService.startProcessInstanceByKey("sendMailExample", vars);
        List messages = this.wiser.getMessages();
        EmailSendTaskTest.assertEquals((int)1, (int)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        MimeMessage mimeMessage = message.getMimeMessage();
        EmailSendTaskTest.assertEquals((String)("Your order " + orderId + " has been shipped"), (String)mimeMessage.getHeader("Subject", null));
        EmailSendTaskTest.assertEquals((String)("\"" + from + "\" <" + from.toString() + ">"), (String)mimeMessage.getHeader("From", null));
        EmailSendTaskTest.assertTrue((boolean)mimeMessage.getHeader("To", null).contains(recipient));
    }

    private void assertEmailSend(WiserMessage emailMessage, boolean htmlMail, String subject, String message, String from, List<String> to, List<String> cc) throws IOException {
        try {
            MimeMessage mimeMessage = emailMessage.getMimeMessage();
            if (htmlMail) {
                EmailSendTaskTest.assertTrue((boolean)mimeMessage.getContentType().contains("multipart/mixed"));
            } else {
                EmailSendTaskTest.assertTrue((boolean)mimeMessage.getContentType().contains("text/plain"));
            }
            EmailSendTaskTest.assertEquals((String)subject, (String)mimeMessage.getHeader("Subject", null));
            EmailSendTaskTest.assertEquals((String)("\"" + from + "\" <" + from.toString() + ">"), (String)mimeMessage.getHeader("From", null));
            EmailSendTaskTest.assertTrue((boolean)this.getMessage(mimeMessage).contains(message));
            for (String t : to) {
                EmailSendTaskTest.assertTrue((boolean)mimeMessage.getHeader("To", null).contains(t));
            }
            if (cc != null) {
                for (String c : cc) {
                    EmailSendTaskTest.assertTrue((boolean)mimeMessage.getHeader("Cc", null).contains(c));
                }
            }
        }
        catch (MessagingException e) {
            EmailSendTaskTest.fail((String)e.getMessage());
        }
    }

    protected String getMessage(MimeMessage mimeMessage) throws MessagingException, IOException {
        DataHandler dataHandler = mimeMessage.getDataHandler();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        dataHandler.writeTo((OutputStream)baos);
        baos.flush();
        return baos.toString();
    }
}

