/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import java.util.Collection;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.bpmn.usertask.ModelExecutionContextTaskListener;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.Task;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class UserTaskBpmnModelExecutionContextTest
extends PluggableProcessEngineTestCase {
    private static final String PROCESS_ID = "process";
    private static final String USER_TASK_ID = "userTask";
    private String deploymentId;

    public void testGetBpmnModelElementInstanceOnCreate() {
        String eventName = "create";
        this.deployProcess(eventName);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertModelInstance();
        this.assertUserTask(eventName);
        String taskId = ((org.camunda.bpm.engine.task.Task)this.taskService.createTaskQuery().active().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    public void testGetBpmnModelElementInstanceOnAssignment() {
        String eventName = "assignment";
        this.deployProcess(eventName);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        UserTaskBpmnModelExecutionContextTest.assertNull((Object)ModelExecutionContextTaskListener.modelInstance);
        UserTaskBpmnModelExecutionContextTest.assertNull((Object)ModelExecutionContextTaskListener.userTask);
        String taskId = ((org.camunda.bpm.engine.task.Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        this.assertModelInstance();
        this.assertUserTask(eventName);
        this.taskService.complete(taskId);
    }

    public void testGetBpmnModelElementInstanceOnComplete() {
        String eventName = "complete";
        this.deployProcess(eventName);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        UserTaskBpmnModelExecutionContextTest.assertNull((Object)ModelExecutionContextTaskListener.modelInstance);
        UserTaskBpmnModelExecutionContextTest.assertNull((Object)ModelExecutionContextTaskListener.userTask);
        String taskId = ((org.camunda.bpm.engine.task.Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        UserTaskBpmnModelExecutionContextTest.assertNull((Object)ModelExecutionContextTaskListener.modelInstance);
        UserTaskBpmnModelExecutionContextTest.assertNull((Object)ModelExecutionContextTaskListener.userTask);
        this.taskService.complete(taskId);
        this.assertModelInstance();
        this.assertUserTask(eventName);
    }

    private void assertModelInstance() {
        BpmnModelInstance modelInstance = ModelExecutionContextTaskListener.modelInstance;
        UserTaskBpmnModelExecutionContextTest.assertNotNull((Object)modelInstance);
        Collection events = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Event.class));
        UserTaskBpmnModelExecutionContextTest.assertEquals((int)2, (int)events.size());
        Collection tasks = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Task.class));
        UserTaskBpmnModelExecutionContextTest.assertEquals((int)1, (int)tasks.size());
        Process process = (Process)modelInstance.getDefinitions().getRootElements().iterator().next();
        UserTaskBpmnModelExecutionContextTest.assertEquals((String)PROCESS_ID, (String)process.getId());
        UserTaskBpmnModelExecutionContextTest.assertTrue((boolean)process.isExecutable());
    }

    private void assertUserTask(String eventName) {
        UserTask userTask = ModelExecutionContextTaskListener.userTask;
        UserTaskBpmnModelExecutionContextTest.assertNotNull((Object)userTask);
        ModelElementInstance taskListener = userTask.getExtensionElements().getUniqueChildElementByNameNs("http://camunda.org/schema/1.0/bpmn", "taskListener");
        UserTaskBpmnModelExecutionContextTest.assertEquals((String)eventName, (String)taskListener.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "event"));
        UserTaskBpmnModelExecutionContextTest.assertEquals((String)ModelExecutionContextTaskListener.class.getName(), (String)taskListener.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class"));
        BpmnModelInstance modelInstance = ModelExecutionContextTaskListener.modelInstance;
        Collection tasks = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Task.class));
        UserTaskBpmnModelExecutionContextTest.assertTrue((boolean)tasks.contains(userTask));
    }

    private void deployProcess(String eventName) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask(USER_TASK_ID).endEvent().done();
        ExtensionElements extensionElements = (ExtensionElements)modelInstance.newInstance(ExtensionElements.class);
        ModelElementInstance taskListener = extensionElements.addExtensionElement("http://camunda.org/schema/1.0/bpmn", "taskListener");
        taskListener.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class", ModelExecutionContextTaskListener.class.getName());
        taskListener.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "event", eventName);
        UserTask userTask = (UserTask)modelInstance.getModelElementById(USER_TASK_ID);
        userTask.setExtensionElements(extensionElements);
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
    }

    public void tearDown() {
        ModelExecutionContextTaskListener.clear();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }
}

