/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.jpa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.EntityManagerSession;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.EntityManagerSessionFactory;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.variables.JavaSerializable;
import org.camunda.bpm.engine.test.standalone.jpa.BigDecimalIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.BigIntegerIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.ByteIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.CharIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.CompoundIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.DateIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.DoubleIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.EmbeddableCompoundId;
import org.camunda.bpm.engine.test.standalone.jpa.FieldAccessJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.FloatIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.IllegalIdClassJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.IntegerIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.LongIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.PropertyAccessJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.SQLDateIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.ShortIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.StringIdJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.SubclassFieldAccessJPAEntity;
import org.camunda.bpm.engine.test.standalone.jpa.SubclassPropertyAccessJPAEntity;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;
import org.junit.Ignore;

public class JPAVariableTest
extends AbstractProcessEngineTestCase {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml";
    protected static ProcessEngine cachedProcessEngine;
    private FieldAccessJPAEntity simpleEntityFieldAccess;
    private PropertyAccessJPAEntity simpleEntityPropertyAccess;
    private SubclassFieldAccessJPAEntity subclassFieldAccess;
    private SubclassPropertyAccessJPAEntity subclassPropertyAccess;
    private ByteIdJPAEntity byteIdJPAEntity;
    private ShortIdJPAEntity shortIdJPAEntity;
    private IntegerIdJPAEntity integerIdJPAEntity;
    private LongIdJPAEntity longIdJPAEntity;
    private FloatIdJPAEntity floatIdJPAEntity;
    private DoubleIdJPAEntity doubleIdJPAEntity;
    private CharIdJPAEntity charIdJPAEntity;
    private StringIdJPAEntity stringIdJPAEntity;
    private DateIdJPAEntity dateIdJPAEntity;
    private SQLDateIdJPAEntity sqlDateIdJPAEntity;
    private BigDecimalIdJPAEntity bigDecimalIdJPAEntity;
    private BigIntegerIdJPAEntity bigIntegerIdJPAEntity;
    private CompoundIdJPAEntity compoundIdJPAEntity;
    private FieldAccessJPAEntity entityToQuery;
    private FieldAccessJPAEntity entityToUpdate;
    private static EntityManagerFactory entityManagerFactory;

    public static Test suite() {
        return new JPAVariableTestSetup();
    }

    protected void initializeProcessEngine() {
        this.processEngine = cachedProcessEngine;
    }

    public void setupJPAEntities() {
        EntityManager manager = entityManagerFactory.createEntityManager();
        manager.getTransaction().begin();
        this.simpleEntityFieldAccess = new FieldAccessJPAEntity();
        this.simpleEntityFieldAccess.setId(1L);
        this.simpleEntityFieldAccess.setValue("value1");
        manager.persist((Object)this.simpleEntityFieldAccess);
        this.simpleEntityPropertyAccess = new PropertyAccessJPAEntity();
        this.simpleEntityPropertyAccess.setId(1L);
        this.simpleEntityPropertyAccess.setValue("value2");
        manager.persist((Object)this.simpleEntityPropertyAccess);
        this.subclassFieldAccess = new SubclassFieldAccessJPAEntity();
        this.subclassFieldAccess.setId(1L);
        this.subclassFieldAccess.setValue("value3");
        manager.persist((Object)this.subclassFieldAccess);
        this.subclassPropertyAccess = new SubclassPropertyAccessJPAEntity();
        this.subclassPropertyAccess.setId(1L);
        this.subclassPropertyAccess.setValue("value4");
        manager.persist((Object)this.subclassPropertyAccess);
        this.byteIdJPAEntity = new ByteIdJPAEntity();
        this.byteIdJPAEntity.setByteId((byte)1);
        manager.persist((Object)this.byteIdJPAEntity);
        this.shortIdJPAEntity = new ShortIdJPAEntity();
        this.shortIdJPAEntity.setShortId((short)123);
        manager.persist((Object)this.shortIdJPAEntity);
        this.integerIdJPAEntity = new IntegerIdJPAEntity();
        this.integerIdJPAEntity.setIntId(123);
        manager.persist((Object)this.integerIdJPAEntity);
        this.longIdJPAEntity = new LongIdJPAEntity();
        this.longIdJPAEntity.setLongId(123456789L);
        manager.persist((Object)this.longIdJPAEntity);
        this.floatIdJPAEntity = new FloatIdJPAEntity();
        this.floatIdJPAEntity.setFloatId(123.45678f);
        manager.persist((Object)this.floatIdJPAEntity);
        this.doubleIdJPAEntity = new DoubleIdJPAEntity();
        this.doubleIdJPAEntity.setDoubleId(1.2345678987654E7);
        manager.persist((Object)this.doubleIdJPAEntity);
        this.charIdJPAEntity = new CharIdJPAEntity();
        this.charIdJPAEntity.setCharId('g');
        manager.persist((Object)this.charIdJPAEntity);
        this.dateIdJPAEntity = new DateIdJPAEntity();
        this.dateIdJPAEntity.setDateId(new java.util.Date());
        manager.persist((Object)this.dateIdJPAEntity);
        this.sqlDateIdJPAEntity = new SQLDateIdJPAEntity();
        this.sqlDateIdJPAEntity.setDateId(new Date(Calendar.getInstance().getTimeInMillis()));
        manager.persist((Object)this.sqlDateIdJPAEntity);
        this.stringIdJPAEntity = new StringIdJPAEntity();
        this.stringIdJPAEntity.setStringId("azertyuiop");
        manager.persist((Object)this.stringIdJPAEntity);
        this.bigDecimalIdJPAEntity = new BigDecimalIdJPAEntity();
        this.bigDecimalIdJPAEntity.setBigDecimalId(new BigDecimal("12345678912345678900000.123456789123456789"));
        manager.persist((Object)this.bigDecimalIdJPAEntity);
        this.bigIntegerIdJPAEntity = new BigIntegerIdJPAEntity();
        this.bigIntegerIdJPAEntity.setBigIntegerId(new BigInteger("12345678912345678912345678900000"));
        manager.persist((Object)this.bigIntegerIdJPAEntity);
        manager.flush();
        manager.getTransaction().commit();
        manager.close();
    }

    public void setupIllegalJPAEntities() {
        EntityManager manager = entityManagerFactory.createEntityManager();
        manager.getTransaction().begin();
        this.compoundIdJPAEntity = new CompoundIdJPAEntity();
        EmbeddableCompoundId id = new EmbeddableCompoundId();
        id.setIdPart1(123L);
        id.setIdPart2("part2");
        this.compoundIdJPAEntity.setId(id);
        manager.persist((Object)this.compoundIdJPAEntity);
        manager.flush();
        manager.getTransaction().commit();
        manager.close();
    }

    public void setupQueryJPAEntity(long id) {
        if (this.entityToQuery == null) {
            EntityManager manager = entityManagerFactory.createEntityManager();
            manager.getTransaction().begin();
            this.entityToQuery = new FieldAccessJPAEntity();
            this.entityToQuery.setId(id);
            manager.persist((Object)this.entityToQuery);
            manager.flush();
            manager.getTransaction().commit();
            manager.close();
        }
    }

    public void setupJPAEntityToUpdate() {
        EntityManager manager = entityManagerFactory.createEntityManager();
        manager.getTransaction().begin();
        this.entityToUpdate = new FieldAccessJPAEntity();
        this.entityToUpdate.setId(3L);
        manager.persist((Object)this.entityToUpdate);
        manager.flush();
        manager.getTransaction().commit();
        manager.close();
    }

    @Deployment
    public void testStoreJPAEntityAsVariable() {
        this.setupJPAEntities();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("simpleEntityFieldAccess", this.simpleEntityFieldAccess);
        variables.put("simpleEntityPropertyAccess", this.simpleEntityPropertyAccess);
        variables.put("subclassFieldAccess", this.subclassFieldAccess);
        variables.put("subclassPropertyAccess", this.subclassPropertyAccess);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("JPAVariableProcess", variables);
        Object fieldAccessResult = this.runtimeService.getVariable(processInstance.getId(), "simpleEntityFieldAccess");
        Assert.assertTrue((boolean)(fieldAccessResult instanceof FieldAccessJPAEntity));
        Assert.assertEquals((long)1L, (long)((FieldAccessJPAEntity)fieldAccessResult).getId());
        Assert.assertEquals((Object)"value1", (Object)((FieldAccessJPAEntity)fieldAccessResult).getValue());
        Object propertyAccessResult = this.runtimeService.getVariable(processInstance.getId(), "simpleEntityPropertyAccess");
        Assert.assertTrue((boolean)(propertyAccessResult instanceof PropertyAccessJPAEntity));
        Assert.assertEquals((long)1L, (long)((PropertyAccessJPAEntity)propertyAccessResult).getId());
        Assert.assertEquals((Object)"value2", (Object)((PropertyAccessJPAEntity)propertyAccessResult).getValue());
        Object subclassFieldResult = this.runtimeService.getVariable(processInstance.getId(), "subclassFieldAccess");
        Assert.assertTrue((boolean)(subclassFieldResult instanceof SubclassFieldAccessJPAEntity));
        Assert.assertEquals((long)1L, (long)((SubclassFieldAccessJPAEntity)subclassFieldResult).getId());
        Assert.assertEquals((Object)"value3", (Object)((SubclassFieldAccessJPAEntity)subclassFieldResult).getValue());
        Object subclassPropertyResult = this.runtimeService.getVariable(processInstance.getId(), "subclassPropertyAccess");
        Assert.assertTrue((boolean)(subclassPropertyResult instanceof SubclassPropertyAccessJPAEntity));
        Assert.assertEquals((long)1L, (long)((SubclassPropertyAccessJPAEntity)subclassPropertyResult).getId());
        Assert.assertEquals((Object)"value4", (Object)((SubclassPropertyAccessJPAEntity)subclassPropertyResult).getValue());
        Object currentValue = this.runtimeService.getVariable(processInstance.getId(), "simpleEntityFieldAccess");
        JPAVariableTest.assertNotNull((Object)currentValue);
        this.runtimeService.setVariable(processInstance.getId(), "simpleEntityFieldAccess", null);
        currentValue = this.runtimeService.getVariable(processInstance.getId(), "simpleEntityFieldAccess");
        JPAVariableTest.assertNull((Object)currentValue);
        this.runtimeService.setVariable(processInstance.getId(), "simpleEntityFieldAccess", (Object)this.simpleEntityFieldAccess);
        currentValue = this.runtimeService.getVariable(processInstance.getId(), "simpleEntityFieldAccess");
        JPAVariableTest.assertNotNull((Object)currentValue);
        Assert.assertTrue((boolean)(currentValue instanceof FieldAccessJPAEntity));
        Assert.assertEquals((long)1L, (long)((FieldAccessJPAEntity)currentValue).getId());
        variables = new HashMap();
        variables.put("byteIdJPAEntity", this.byteIdJPAEntity);
        variables.put("shortIdJPAEntity", this.shortIdJPAEntity);
        variables.put("integerIdJPAEntity", this.integerIdJPAEntity);
        variables.put("longIdJPAEntity", this.longIdJPAEntity);
        variables.put("floatIdJPAEntity", this.floatIdJPAEntity);
        variables.put("doubleIdJPAEntity", this.doubleIdJPAEntity);
        variables.put("charIdJPAEntity", this.charIdJPAEntity);
        variables.put("stringIdJPAEntity", this.stringIdJPAEntity);
        variables.put("dateIdJPAEntity", this.dateIdJPAEntity);
        variables.put("sqlDateIdJPAEntity", this.sqlDateIdJPAEntity);
        variables.put("bigDecimalIdJPAEntity", this.bigDecimalIdJPAEntity);
        variables.put("bigIntegerIdJPAEntity", this.bigIntegerIdJPAEntity);
        ProcessInstance processInstanceAllTypes = this.runtimeService.startProcessInstanceByKey("JPAVariableProcess", variables);
        Object byteIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "byteIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(byteIdResult instanceof ByteIdJPAEntity));
        JPAVariableTest.assertEquals((byte)this.byteIdJPAEntity.getByteId(), (byte)((ByteIdJPAEntity)byteIdResult).getByteId());
        Object shortIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "shortIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(shortIdResult instanceof ShortIdJPAEntity));
        JPAVariableTest.assertEquals((short)this.shortIdJPAEntity.getShortId(), (short)((ShortIdJPAEntity)shortIdResult).getShortId());
        Object integerIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "integerIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(integerIdResult instanceof IntegerIdJPAEntity));
        JPAVariableTest.assertEquals((int)this.integerIdJPAEntity.getIntId(), (int)((IntegerIdJPAEntity)integerIdResult).getIntId());
        Object longIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "longIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(longIdResult instanceof LongIdJPAEntity));
        JPAVariableTest.assertEquals((long)this.longIdJPAEntity.getLongId(), (long)((LongIdJPAEntity)longIdResult).getLongId());
        Object floatIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "floatIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(floatIdResult instanceof FloatIdJPAEntity));
        JPAVariableTest.assertEquals((Object)Float.valueOf(this.floatIdJPAEntity.getFloatId()), (Object)Float.valueOf(((FloatIdJPAEntity)floatIdResult).getFloatId()));
        Object doubleIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "doubleIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(doubleIdResult instanceof DoubleIdJPAEntity));
        JPAVariableTest.assertEquals((Object)this.doubleIdJPAEntity.getDoubleId(), (Object)((DoubleIdJPAEntity)doubleIdResult).getDoubleId());
        Object charIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "charIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(charIdResult instanceof CharIdJPAEntity));
        JPAVariableTest.assertEquals((char)this.charIdJPAEntity.getCharId(), (char)((CharIdJPAEntity)charIdResult).getCharId());
        Object stringIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "stringIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(stringIdResult instanceof StringIdJPAEntity));
        JPAVariableTest.assertEquals((String)this.stringIdJPAEntity.getStringId(), (String)((StringIdJPAEntity)stringIdResult).getStringId());
        Object dateIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "dateIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(dateIdResult instanceof DateIdJPAEntity));
        JPAVariableTest.assertEquals((Object)this.dateIdJPAEntity.getDateId(), (Object)((DateIdJPAEntity)dateIdResult).getDateId());
        Object sqlDateIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "sqlDateIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(sqlDateIdResult instanceof SQLDateIdJPAEntity));
        JPAVariableTest.assertEquals((Object)this.sqlDateIdJPAEntity.getDateId(), (Object)((SQLDateIdJPAEntity)sqlDateIdResult).getDateId());
        Object bigDecimalIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "bigDecimalIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(bigDecimalIdResult instanceof BigDecimalIdJPAEntity));
        JPAVariableTest.assertEquals((Object)this.bigDecimalIdJPAEntity.getBigDecimalId(), (Object)((BigDecimalIdJPAEntity)bigDecimalIdResult).getBigDecimalId());
        Object bigIntegerIdResult = this.runtimeService.getVariable(processInstanceAllTypes.getId(), "bigIntegerIdJPAEntity");
        JPAVariableTest.assertTrue((boolean)(bigIntegerIdResult instanceof BigIntegerIdJPAEntity));
        JPAVariableTest.assertEquals((Object)this.bigIntegerIdJPAEntity.getBigIntegerId(), (Object)((BigIntegerIdJPAEntity)bigIntegerIdResult).getBigIntegerId());
    }

    @Deployment
    public void testIllegalEntities() {
        this.setupIllegalJPAEntities();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("compoundIdJPAEntity", this.compoundIdJPAEntity);
        try {
            this.runtimeService.startProcessInstanceByKey("JPAVariableProcessExceptions", variables);
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find field or method with annotation @Id on class", ae.getMessage());
            this.assertTextPresent("only single-valued primary keys are supported on JPA-enities", ae.getMessage());
        }
        variables = new HashMap();
        variables.put("nullValueEntity", new FieldAccessJPAEntity());
        try {
            this.runtimeService.startProcessInstanceByKey("JPAVariableProcessExceptions", variables);
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Value of primary key for JPA-Entity is null", ae.getMessage());
        }
        variables = new HashMap();
        IllegalIdClassJPAEntity illegalIdTypeEntity = new IllegalIdClassJPAEntity();
        illegalIdTypeEntity.setId(Calendar.getInstance());
        variables.put("illegalTypeId", illegalIdTypeEntity);
        try {
            this.runtimeService.startProcessInstanceByKey("JPAVariableProcessExceptions", variables);
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Unsupported Primary key type for JPA-Entity", ae.getMessage());
        }
        variables = new HashMap();
        FieldAccessJPAEntity nonPersistentEntity = new FieldAccessJPAEntity();
        nonPersistentEntity.setId(9999L);
        variables.put("nonPersistentEntity", nonPersistentEntity);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("JPAVariableProcessExceptions", variables);
        try {
            this.runtimeService.getVariable(processInstance.getId(), "nonPersistentEntity");
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Entity does not exist: " + FieldAccessJPAEntity.class.getName() + " - 9999", ae.getMessage());
        }
    }

    @Deployment
    public void testQueryJPAVariable() {
        this.setupQueryJPAEntity(2L);
        HashMap<String, FieldAccessJPAEntity> variables = new HashMap<String, FieldAccessJPAEntity>();
        variables.put("entityToQuery", this.entityToQuery);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("JPAVariableProcess", variables);
        ProcessInstance result = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("entityToQuery", (Object)this.entityToQuery).singleResult();
        JPAVariableTest.assertNotNull((Object)result);
        JPAVariableTest.assertEquals((String)result.getId(), (String)processInstance.getId());
        FieldAccessJPAEntity unexistingEntity = new FieldAccessJPAEntity();
        unexistingEntity.setId(8888L);
        result = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("entityToQuery", (Object)unexistingEntity).singleResult();
        JPAVariableTest.assertNull((Object)result);
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("entityToQuery", (Object)this.entityToQuery).singleResult();
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("JPA entity variables can only be used in 'variableValueEquals'", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("entityToQuery", (Object)this.entityToQuery).singleResult();
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("JPA entity variables can only be used in 'variableValueEquals'", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("entityToQuery", (Object)this.entityToQuery).singleResult();
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("JPA entity variables can only be used in 'variableValueEquals'", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThan("entityToQuery", (Object)this.entityToQuery).singleResult();
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("JPA entity variables can only be used in 'variableValueEquals'", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("entityToQuery", (Object)this.entityToQuery).singleResult();
            JPAVariableTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("JPA entity variables can only be used in 'variableValueEquals'", ae.getMessage());
        }
    }

    @Deployment
    public void FAILING_testUpdateJPAEntityValues() {
        this.setupJPAEntityToUpdate();
        HashMap<String, FieldAccessJPAEntity> variables = new HashMap<String, FieldAccessJPAEntity>();
        variables.put("entityToUpdate", this.entityToUpdate);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("UpdateJPAValuesProcess", variables);
        Object updatedEntity = this.runtimeService.getVariable(processInstance.getId(), "entityToUpdate");
        JPAVariableTest.assertTrue((boolean)(updatedEntity instanceof FieldAccessJPAEntity));
        JPAVariableTest.assertEquals((String)"updatedValue", (String)((FieldAccessJPAEntity)updatedEntity).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testFailSerializationForUnknownSerializedValueType() throws IOException {
        JavaSerializable pojo = new JavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(pojo);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.processEngine);
        ObjectValue serializedObjectValue = (ObjectValue)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName(pojo.getClass().getName()).create();
        VariableMap variables = Variables.createVariables().putValueTyped("var", (TypedValue)serializedObjectValue);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)variables);
        JavaSerializable returnedPojo = (JavaSerializable)this.runtimeService.getVariable(processInstance.getId(), "var");
        JPAVariableTest.assertEquals((Object)pojo, (Object)returnedPojo);
    }

    @Ignore
    public static class JPAVariableTestSetup
    extends TestSetup {
        public JPAVariableTestSetup() {
            super((Test)new TestSuite(JPAVariableTest.class));
        }

        protected void setUp() throws Exception {
            ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/standalone/jpa/camunda.cfg.xml");
            cachedProcessEngine = processEngineConfiguration.buildProcessEngine();
            EntityManagerSessionFactory entityManagerSessionFactory = (EntityManagerSessionFactory)processEngineConfiguration.getSessionFactories().get(EntityManagerSession.class);
            entityManagerFactory = entityManagerSessionFactory.getEntityManagerFactory();
        }

        protected void tearDown() throws Exception {
            cachedProcessEngine.close();
            cachedProcessEngine = null;
            entityManagerFactory.close();
            entityManagerFactory = null;
        }
    }
}

