/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.scripting;

import java.util.concurrent.Callable;
import javax.script.ScriptEngine;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;

public class ScriptEngineCachingTest
extends PluggableProcessEngineTestCase {
    protected static final String PROCESS_PATH = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String SCRIPT_LANGUAGE = "groovy";

    public void testGlobalCachingOfScriptEngine() {
        ScriptEngine engine = this.getScriptEngine(SCRIPT_LANGUAGE);
        ScriptEngineCachingTest.assertNotNull((Object)engine);
        ScriptEngineCachingTest.assertEquals((Object)engine, (Object)this.getScriptEngine(SCRIPT_LANGUAGE));
    }

    public void testGlobalDisableCachingOfScriptEngine() {
        this.processEngineConfiguration.setEnableScriptEngineCaching(false);
        this.getScriptingEngines().setEnableScriptEngineCaching(false);
        ScriptEngine engine = this.getScriptEngine(SCRIPT_LANGUAGE);
        ScriptEngineCachingTest.assertNotNull((Object)engine);
        ScriptEngineCachingTest.assertFalse((boolean)engine.equals(this.getScriptEngine(SCRIPT_LANGUAGE)));
        this.processEngineConfiguration.setEnableScriptEngineCaching(true);
        this.getScriptingEngines().setEnableScriptEngineCaching(true);
    }

    public void testCachingOfScriptEngineInProcessApplication() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ScriptEngine engine = processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, true);
        ScriptEngineCachingTest.assertNotNull((Object)engine);
        ScriptEngineCachingTest.assertEquals((Object)engine, (Object)processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, true));
    }

    public void testDisableCachingOfScriptEngineInProcessApplication() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ScriptEngine engine = processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, false);
        ScriptEngineCachingTest.assertNotNull((Object)engine);
        ScriptEngineCachingTest.assertFalse((boolean)engine.equals(processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, false)));
    }

    public void testFetchScriptEngineFromPaEnableCaching() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(processApplication.getReference()).addClasspathResource(PROCESS_PATH).deploy();
        ScriptEngine engine = this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication);
        ScriptEngineCachingTest.assertNotNull((Object)engine);
        ScriptEngineCachingTest.assertEquals((Object)engine, (Object)this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication));
        ScriptEngineCachingTest.assertEquals((Object)engine, (Object)processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, true));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testFetchScriptEngineFromPaDisableCaching() {
        this.processEngineConfiguration.setEnableScriptEngineCaching(false);
        this.getScriptingEngines().setEnableScriptEngineCaching(false);
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(processApplication.getReference()).addClasspathResource(PROCESS_PATH).deploy();
        ScriptEngine engine = this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication);
        ScriptEngineCachingTest.assertNotNull((Object)engine);
        ScriptEngineCachingTest.assertFalse((boolean)engine.equals(this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication)));
        ScriptEngineCachingTest.assertFalse((boolean)engine.equals(processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, false)));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.processEngineConfiguration.setEnableScriptEngineCaching(true);
        this.getScriptingEngines().setEnableScriptEngineCaching(true);
    }

    public void testDisableFetchScriptEngineFromProcessApplication() {
        this.processEngineConfiguration.setEnableFetchScriptEngineFromProcessApplication(false);
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(processApplication.getReference()).addClasspathResource(PROCESS_PATH).deploy();
        ScriptEngine engine = this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication);
        ScriptEngineCachingTest.assertNotNull((Object)engine);
        ScriptEngineCachingTest.assertEquals((Object)engine, (Object)this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication));
        ScriptEngineCachingTest.assertFalse((boolean)engine.equals(processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, true)));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.processEngineConfiguration.setEnableFetchScriptEngineFromProcessApplication(true);
    }

    protected ScriptingEngines getScriptingEngines() {
        return this.processEngineConfiguration.getScriptingEngines();
    }

    protected ScriptEngine getScriptEngine(final String name) {
        final ScriptingEngines scriptingEngines = this.getScriptingEngines();
        return (ScriptEngine)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<ScriptEngine>(){

            public ScriptEngine execute(CommandContext commandContext) {
                return scriptingEngines.getScriptEngineForLanguage(name);
            }
        });
    }

    protected ScriptEngine getScriptEngineFromPa(final String name, final ProcessApplicationInterface processApplication) {
        return (ScriptEngine)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<ScriptEngine>(){

            public ScriptEngine execute(CommandContext commandContext) {
                return (ScriptEngine)Context.executeWithinProcessApplication((Callable)new Callable<ScriptEngine>(){

                    @Override
                    public ScriptEngine call() throws Exception {
                        return ScriptEngineCachingTest.this.getScriptEngine(name);
                    }
                }, (ProcessApplicationReference)processApplication.getReference());
            }
        });
    }
}

