/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.testing;

import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineTestCase;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProcessEngineTestCaseTest
extends ProcessEngineTestCase {
    @Deployment
    public void testSimpleProcess() {
        this.runtimeService.startProcessInstanceByKey("simpleProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessEngineTestCaseTest.assertEquals((String)"My Task", (String)task.getName());
        this.taskService.complete(task.getId());
        ProcessEngineTestCaseTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @RequiredHistoryLevel(value="audit")
    public void testRequiredHistoryLevelAudit() {
        Assert.assertThat((Object)this.currentHistoryLevel(), (Matcher)CoreMatchers.either((Matcher)CoreMatchers.is((Object)"audit")).or(CoreMatchers.is((Object)"full")));
    }

    @RequiredHistoryLevel(value="activity")
    public void testRequiredHistoryLevelActivity() {
        Assert.assertThat((Object)this.currentHistoryLevel(), (Matcher)CoreMatchers.either((Matcher)CoreMatchers.is((Object)"activity")).or(CoreMatchers.is((Object)"audit")).or(CoreMatchers.is((Object)"full")));
    }

    @RequiredHistoryLevel(value="full")
    public void testRequiredHistoryLevelFull() {
        Assert.assertThat((Object)this.currentHistoryLevel(), (Matcher)CoreMatchers.is((Object)"full"));
    }

    protected String currentHistoryLevel() {
        return this.processEngine.getProcessEngineConfiguration().getHistory();
    }
}

