/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractSetExternalTaskRetriesCmd<T>
implements Command<T> {
    protected List<String> externalTaskIds;
    protected ExternalTaskQuery externalTaskQuery;
    protected int retries;

    public AbstractSetExternalTaskRetriesCmd(List<String> externalTaskIds, ExternalTaskQuery externalTaskQuery, int retries) {
        this.externalTaskIds = externalTaskIds;
        this.externalTaskQuery = externalTaskQuery;
        this.retries = retries;
    }

    protected List<String> collectExternalTaskIds() {
        HashSet<String> collectedIds = new HashSet<String>();
        if (this.externalTaskIds != null) {
            EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "External task id cannot be null", "externalTaskIds", this.externalTaskIds);
            collectedIds.addAll(this.externalTaskIds);
        }
        if (this.externalTaskQuery != null) {
            List<String> ids = Context.getCommandContext().runWithoutAuthorization(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ((ExternalTaskQueryImpl)AbstractSetExternalTaskRetriesCmd.this.externalTaskQuery).listIds();
                }
            });
            collectedIds.addAll(ids);
        }
        return new ArrayList<String>(collectedIds);
    }

    protected void writeUserOperationLog(CommandContext commandContext, int retries, int numInstances, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        propertyChanges.add(new PropertyChange("retries", null, retries));
        commandContext.getOperationLogManager().logProcessInstanceOperation("SetExternalTaskRetries", null, null, null, propertyChanges);
    }
}

