/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteProcessDefinitionCmd
implements Command<Void>,
Serializable {
    private final String processDefinitionId;
    private final Boolean cascade;
    private final Boolean skipCustomListeners;

    public DeleteProcessDefinitionCmd(String processDefinitionId, Boolean cascade, Boolean skipCustomListeners) {
        this.processDefinitionId = processDefinitionId;
        this.cascade = cascade;
        this.skipCustomListeners = skipCustomListeners;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)this.processDefinitionId);
        ProcessDefinitionEntity processDefinition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionById(this.processDefinitionId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No process definition found with id '" + this.processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteProcessDefinitionById(this.processDefinitionId);
        }
        UserOperationLogManager logManager = commandContext.getOperationLogManager();
        logManager.logProcessDefinitionOperation("Delete", this.processDefinitionId, processDefinition.getKey(), new PropertyChange("cascade", null, this.cascade));
        commandContext.getProcessDefinitionManager().deleteProcessDefinition(processDefinition, this.processDefinitionId, this.cascade, this.cascade, this.skipCustomListeners);
        return null;
    }
}

