/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.TaskQueryVariableValue;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;

public class HistoricTaskInstanceQueryImpl
extends AbstractQuery<HistoricTaskInstanceQuery, HistoricTaskInstance>
implements HistoricTaskInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionName;
    protected String processInstanceId;
    protected String executionId;
    protected String[] activityInstanceIds;
    protected String taskId;
    protected String taskName;
    protected String taskNameLike;
    protected String taskParentTaskId;
    protected String taskDescription;
    protected String taskDescriptionLike;
    protected String taskDeleteReason;
    protected String taskDeleteReasonLike;
    protected String taskOwner;
    protected String taskOwnerLike;
    protected Boolean assigned;
    protected Boolean unassigned;
    protected String taskAssignee;
    protected String taskAssigneeLike;
    protected String[] taskDefinitionKeys;
    protected String taskInvolvedUser;
    protected String taskInvolvedGroup;
    protected String taskHadCandidateUser;
    protected String taskHadCandidateGroup;
    protected Boolean withCandidateGroups;
    protected Boolean withoutCandidateGroups;
    protected Integer taskPriority;
    protected boolean finished;
    protected boolean unfinished;
    protected boolean processFinished;
    protected boolean processUnfinished;
    protected List<TaskQueryVariableValue> variables = new ArrayList<TaskQueryVariableValue>();
    protected Date dueDate;
    protected Date dueAfter;
    protected Date dueBefore;
    protected Date followUpDate;
    protected Date followUpBefore;
    protected Date followUpAfter;
    protected String[] tenantIds;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected String caseDefinitionName;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected Date finishedAfter;
    protected Date finishedBefore;
    protected Date startedAfter;
    protected Date startedBefore;

    public HistoricTaskInstanceQueryImpl() {
    }

    public HistoricTaskInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getHistoricTaskInstanceManager().findHistoricTaskInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricTaskInstance> executeList(CommandContext commandContext, Page page) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getHistoricTaskInstanceManager().findHistoricTaskInstancesByQueryCriteria(this, page);
    }

    @Override
    public HistoricTaskInstanceQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery activityInstanceIdIn(String ... activityInstanceIds) {
        EnsureUtil.ensureNotNull("activityInstanceIds", activityInstanceIds);
        this.activityInstanceIds = activityInstanceIds;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskNameLike(String taskNameLike) {
        this.taskNameLike = taskNameLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskParentTaskId(String parentTaskId) {
        this.taskParentTaskId = parentTaskId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskDescriptionLike(String taskDescriptionLike) {
        this.taskDescriptionLike = taskDescriptionLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskDeleteReason(String taskDeleteReason) {
        this.taskDeleteReason = taskDeleteReason;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskDeleteReasonLike(String taskDeleteReasonLike) {
        this.taskDeleteReasonLike = taskDeleteReasonLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskAssigned() {
        this.assigned = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskUnassigned() {
        this.unassigned = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskAssignee(String taskAssignee) {
        this.taskAssignee = taskAssignee;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskAssigneeLike(String taskAssigneeLike) {
        this.taskAssigneeLike = taskAssigneeLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskOwner(String taskOwner) {
        this.taskOwner = taskOwner;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskOwnerLike(String taskOwnerLike) {
        this.taskOwnerLike = taskOwnerLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery caseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl finished() {
        this.finished = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl unfinished() {
        this.unfinished = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl taskVariableValueEquals(String variableName, Object variableValue) {
        this.variables.add(new TaskQueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, true, false));
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueEquals(String variableName, Object variableValue) {
        this.variables.add(new TaskQueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, false, true));
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDefinitionKey(String taskDefinitionKey) {
        return this.taskDefinitionKeyIn(taskDefinitionKey);
    }

    @Override
    public HistoricTaskInstanceQuery taskDefinitionKeyIn(String ... taskDefinitionKeys) {
        EnsureUtil.ensureNotNull(NotValidException.class, "taskDefinitionKeys", (Object[])taskDefinitionKeys);
        this.taskDefinitionKeys = taskDefinitionKeys;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskPriority(Integer taskPriority) {
        this.taskPriority = taskPriority;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processFinished() {
        this.processFinished = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskInvolvedUser(String userId) {
        this.taskInvolvedUser = userId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskInvolvedGroup(String groupId) {
        this.taskInvolvedGroup = groupId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskHadCandidateUser(String userId) {
        this.taskHadCandidateUser = userId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskHadCandidateGroup(String groupId) {
        this.taskHadCandidateGroup = groupId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery withCandidateGroups() {
        this.withCandidateGroups = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery withoutCandidateGroups() {
        this.withoutCandidateGroups = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processUnfinished() {
        this.processUnfinished = true;
        return this;
    }

    protected void ensureVariablesInitialized() {
        VariableSerializers types = Context.getProcessEngineConfiguration().getVariableSerializers();
        for (TaskQueryVariableValue var : this.variables) {
            var.initialize(types);
        }
    }

    @Override
    public HistoricTaskInstanceQuery taskDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskFollowUpDate(Date followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskFollowUpBefore(Date followUpBefore) {
        this.followUpBefore = followUpBefore;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskFollowUpAfter(Date followUpAfter) {
        this.followUpAfter = followUpAfter;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery finishedAfter(Date date) {
        this.finished = true;
        this.finishedAfter = date;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery finishedBefore(Date date) {
        this.finished = true;
        this.finishedBefore = date;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery startedAfter(Date date) {
        this.startedAfter = date;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery startedBefore(Date date) {
        this.startedBefore = date;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || this.finished && this.unfinished || this.processFinished && this.processUnfinished || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.startedAfter, this.startedBefore}) || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.finishedAfter, this.finishedBefore}) || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.dueAfter, this.dueDate, this.dueBefore}) || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.followUpAfter, this.followUpDate, this.followUpBefore});
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.HISTORIC_TASK_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricActivityInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByProcessDefinitionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByProcessInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByExecutionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricTaskInstanceDuration() {
        this.orderBy(HistoricTaskInstanceQueryProperty.DURATION);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricTaskInstanceEndTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.END);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricActivityInstanceStartTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.START);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskName() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_NAME);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskDescription() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DESCRIPTION);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskAssignee() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_ASSIGNEE);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskOwner() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_OWNER);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskDueDate() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DUE_DATE);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskFollowUpDate() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_FOLLOW_UP_DATE);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByDeleteReason() {
        this.orderBy(HistoricTaskInstanceQueryProperty.DELETE_REASON);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskDefinitionKey() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DEFINITION_KEY);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskPriority() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_PRIORITY);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByCaseDefinitionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.CASE_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByCaseInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.CASE_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByCaseExecutionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.CASE_EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTenantId() {
        return (HistoricTaskInstanceQuery)this.orderBy(HistoricTaskInstanceQueryProperty.TENANT_ID);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String[] getActivityInstanceIds() {
        return this.activityInstanceIds;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public Boolean isAssigned() {
        return this.assigned;
    }

    public Boolean isUnassigned() {
        return this.unassigned;
    }

    public Boolean isWithCandidateGroups() {
        return this.withCandidateGroups;
    }

    public Boolean isWithoutCandidateGroups() {
        return this.withoutCandidateGroups;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskNameLike() {
        return this.taskNameLike;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public String getTaskDescriptionLike() {
        return this.taskDescriptionLike;
    }

    public String getTaskDeleteReason() {
        return this.taskDeleteReason;
    }

    public String getTaskDeleteReasonLike() {
        return this.taskDeleteReasonLike;
    }

    public String getTaskAssignee() {
        return this.taskAssignee;
    }

    public String getTaskAssigneeLike() {
        return this.taskAssigneeLike;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String[] getTaskDefinitionKeys() {
        return this.taskDefinitionKeys;
    }

    public List<TaskQueryVariableValue> getVariables() {
        return this.variables;
    }

    public String getTaskOwnerLike() {
        return this.taskOwnerLike;
    }

    public String getTaskOwner() {
        return this.taskOwner;
    }

    public String getTaskParentTaskId() {
        return this.taskParentTaskId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }
}

