/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractDeleteProcessInstanceCmd {
    protected boolean externallyTerminated;
    protected String deleteReason;
    protected boolean skipCustomListeners;

    protected void checkDeleteProcessInstance(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteProcessInstance(execution);
        }
    }

    protected void deleteProcessInstance(final CommandContext commandContext, String processInstanceId, String deleteReason, final boolean skipCustomListeners, boolean externallyTerminated, final boolean skipIoMappings) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "processInstanceId is null", "processInstanceId", (Object)processInstanceId);
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity execution = executionManager.findExecutionById(processInstanceId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "No process instance found for id '" + processInstanceId + "'", "processInstance", (Object)execution);
        this.checkDeleteProcessInstance(execution, commandContext);
        commandContext.getExecutionManager().deleteProcessInstance(processInstanceId, deleteReason, false, skipCustomListeners, externallyTerminated, skipIoMappings);
        final ExecutionEntity superExecution = execution.getSuperExecution();
        if (superExecution != null) {
            commandContext.runWithoutAuthorization(new Callable<Void>(){

                @Override
                public Void call() {
                    ProcessInstanceModificationBuilderImpl builder = (ProcessInstanceModificationBuilderImpl)new ProcessInstanceModificationBuilderImpl(commandContext, superExecution.getProcessInstanceId()).cancelActivityInstance(superExecution.getActivityInstanceId());
                    builder.execute(false, skipCustomListeners, skipIoMappings);
                    return null;
                }
            });
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", processInstanceId, null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE));
    }
}

