/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.IncidentQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Incident;

public class ResolveIncidentCmd
implements Command<Void> {
    protected String incidentId;

    public ResolveIncidentCmd(String incidentId) {
        this.incidentId = incidentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        Incident incident = (Incident)new IncidentQueryImpl().incidentId(this.incidentId).singleResult();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Cannot find an incident with id '" + this.incidentId + "'", "incident", (Object)incident);
        ExecutionEntity execution = (ExecutionEntity)new ExecutionQueryImpl().executionId(incident.getExecutionId()).singleResult();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Cannot find an execution for an incident with id '" + this.incidentId + "'", "execution", (Object)execution);
        execution.resolveIncident(this.incidentId);
        return null;
    }
}

