/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricFinishedProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class HistoricProcessInstanceManager
extends AbstractHistoricManager {
    public HistoricProcessInstanceEntity findHistoricProcessInstance(String processInstanceId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricProcessInstanceEntity.class, processInstanceId);
        }
        return null;
    }

    public HistoricProcessInstanceEventEntity findHistoricProcessInstanceEvent(String eventId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, eventId);
        }
        return null;
    }

    public void deleteHistoricProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryEnabled()) {
            List historicProcessInstanceIds = this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
            for (String historicProcessInstanceId : historicProcessInstanceIds) {
                this.deleteHistoricProcessInstanceByIds(Arrays.asList(historicProcessInstanceId));
            }
        }
    }

    public void deleteHistoricProcessInstanceByIds(List<String> processInstanceIds) {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByProcessInstanceIds(processInstanceIds);
        commandContext.getCommentManager().deleteCommentsByProcessInstanceIds(processInstanceIds);
        commandContext.getAttachmentManager().deleteAttachmentsByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByProcessInstanceIds(processInstanceIds, false);
        commandContext.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricIncidentManager().deleteHistoricIncidentsByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricExternalTaskLogManager().deleteHistoricExternalTaskLogsByProcessInstanceIds(processInstanceIds);
        commandContext.getDbEntityManager().deletePreserveOrder(HistoricProcessInstanceEntity.class, "deleteHistoricProcessInstances", processInstanceIds);
    }

    public long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(historicProcessInstanceQuery);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceCountByQueryCriteria", historicProcessInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery, Page page) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(historicProcessInstanceQuery);
            return this.getDbEntityManager().selectList("selectHistoricProcessInstancesByQueryCriteria", historicProcessInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricProcessInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricProcessInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceCountByNativeQuery", parameterMap);
    }

    protected void configureQuery(HistoricProcessInstanceQueryImpl query) {
        this.getAuthorizationManager().configureHistoricProcessInstanceQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    public List<String> findHistoricProcessInstanceIdsForCleanup(Integer batchSize) {
        ListQueryParameterObject parameterObject = new ListQueryParameterObject();
        parameterObject.setParameter(ClockUtil.getCurrentTime());
        parameterObject.setFirstResult(0);
        parameterObject.setMaxResults(batchSize);
        return this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsForCleanup", parameterObject);
    }

    public Long findHistoricProcessInstanceIdsForCleanupCount() {
        ListQueryParameterObject parameterObject = new ListQueryParameterObject();
        parameterObject.setParameter(ClockUtil.getCurrentTime());
        return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceIdsForCleanupCount", parameterObject);
    }

    public List<HistoricFinishedProcessInstanceReportResult> findFinishedProcessInstancesReportResults() {
        ListQueryParameterObject parameterObject = new ListQueryParameterObject();
        parameterObject.setParameter(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(parameterObject, Resources.PROCESS_DEFINITION);
        this.getTenantManager().configureQuery(parameterObject);
        return this.getDbEntityManager().selectList("selectFinishedProcessInstancesReportEntities", parameterObject);
    }

    public List<String> findHistoricProcessInstanceIds(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        this.configureQuery(historicProcessInstanceQuery);
        return this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsByQueryCriteria", historicProcessInstanceQuery);
    }
}

