/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyCleanableHistoricProcessInstanceReportCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected static final BpmnModelInstance BPMN_PROCESS = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void testReportNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 10, null);
        this.identityService.setAuthentication("user", null, null);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testReportWithAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 10, null);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
    }

    @Test
    public void testReportDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 10, null);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
    }

    protected void prepareProcessInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount, String tenantId) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < instanceCount; ++i) {
            String processInstanceId = null;
            processInstanceId = tenantId == null ? this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId() : this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(tenantId).execute().getId();
            processInstanceIds.add(processInstanceId);
        }
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }
}

