/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.runtime.CaseInstanceBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricDataCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "failingProcess";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected CaseService caseService;
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected static final BpmnModelInstance BPMN_PROCESS = Bpmn.createExecutableProcess((String)"failingProcess").startEvent().endEvent().done();
    protected static final BpmnModelInstance FAILING_BPMN_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().serviceTask().camundaExpression("${failing}")).camundaAsyncBefore()).endEvent().done();
    protected static final String CMMN_PROCESS_WITH_MANUAL_ACTIVATION = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn";
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.caseService = this.engineRule.getCaseService();
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void failToDeleteHistoricProcessInstanceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("No historic process instance found");
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
    }

    @Test
    public void deleteHistoricProcessInstanceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.identityService.clearAuthentication();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteHistoricProcessInstanceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_PROCESS);
        String processInstanceIdOne = this.startProcessInstance(TENANT_ONE);
        String processInstanceIdTwo = this.startProcessInstance(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricProcessInstance(processInstanceIdOne);
        this.historyService.deleteHistoricProcessInstance(processInstanceIdTwo);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failToDeleteHistoricTaskInstanceNoAuthenticatedTenants() {
        String taskId = this.createTaskForTenant(TENANT_ONE);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot delete the historic task instance");
        this.historyService.deleteHistoricTaskInstance(taskId);
    }

    @Test
    public void deleteHistoricTaskInstanceWithAuthenticatedTenant() {
        String taskId = this.createTaskForTenant(TENANT_ONE);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.identityService.clearAuthentication();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteHistoricTaskInstanceWithDisabledTenantCheck() {
        String taskIdOne = this.createTaskForTenant(TENANT_ONE);
        String taskIdTwo = this.createTaskForTenant(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricTaskInstance(taskIdOne);
        this.historyService.deleteHistoricTaskInstance(taskIdTwo);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failToDeleteHistoricCaseInstanceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_PROCESS_WITH_MANUAL_ACTIVATION);
        String caseInstanceId = this.createAndCloseCaseInstance(null);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot delete the historic case instance");
        this.historyService.deleteHistoricCaseInstance(caseInstanceId);
    }

    @Test
    public void deleteHistoricCaseInstanceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_PROCESS_WITH_MANUAL_ACTIVATION);
        String caseInstanceId = this.createAndCloseCaseInstance(null);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricCaseInstance(caseInstanceId);
        this.identityService.clearAuthentication();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteHistoricCaseInstanceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_PROCESS_WITH_MANUAL_ACTIVATION);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_PROCESS_WITH_MANUAL_ACTIVATION);
        String caseInstanceIdOne = this.createAndCloseCaseInstance(TENANT_ONE);
        String caseInstanceIdTwo = this.createAndCloseCaseInstance(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricCaseInstance(caseInstanceIdOne);
        this.historyService.deleteHistoricCaseInstance(caseInstanceIdTwo);
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteHistoricDecisionInstanceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        String decisionDefinitionId = this.evaluateDecisionTable(null);
        this.identityService.setAuthentication("user", null, null);
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        this.identityService.clearAuthentication();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void deleteHistoricDecisionInstanceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        String decisionDefinitionId = this.evaluateDecisionTable(null);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        this.identityService.clearAuthentication();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteHistoricDecisionInstanceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        String decisionDefinitionIdOne = this.evaluateDecisionTable(TENANT_ONE);
        String decisionDefinitionIdTwo = this.evaluateDecisionTable(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionIdOne);
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionIdTwo);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failToDeleteHistoricDecisionInstanceByInstanceIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.evaluateDecisionTable(null);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot delete the historic decision instance");
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
    }

    @Test
    public void deleteHistoricDecisionInstanceByInstanceIdWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.evaluateDecisionTable(null);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteHistoricDecisionInstanceByInstanceIdWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        this.evaluateDecisionTable(TENANT_ONE);
        this.evaluateDecisionTable(TENANT_TWO);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        List historicDecisionInstances = query.includeInputs().includeOutputs().list();
        Assert.assertThat((Object)historicDecisionInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        for (HistoricDecisionInstance in : historicDecisionInstances) {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(in.getId());
        }
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failToGetHistoricJobLogExceptionStacktraceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, FAILING_BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        String historicJobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the historic job log");
        this.historyService.getHistoricJobLogExceptionStacktrace(historicJobLogId);
    }

    @Test
    public void getHistoricJobLogExceptionStacktraceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, FAILING_BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.testRule.executeAvailableJobs();
        HistoricJobLog log = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).failureLog().listPage(0, 1).get(0);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        String historicJobLogExceptionStacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(log.getId());
        Assert.assertThat((Object)historicJobLogExceptionStacktrace, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getHistoricJobLogExceptionStacktraceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, FAILING_BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(TENANT_ONE);
        this.testRule.executeAvailableJobs();
        HistoricJobLog log = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).failureLog().listPage(0, 1).get(0);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        String historicJobLogExceptionStacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(log.getId());
        Assert.assertThat((Object)historicJobLogExceptionStacktrace, (Matcher)CoreMatchers.notNullValue());
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        for (HistoricTaskInstance instance : this.historyService.createHistoricTaskInstanceQuery().list()) {
            this.historyService.deleteHistoricTaskInstance(instance.getId());
        }
    }

    protected String startProcessInstance(String tenantId) {
        if (tenantId == null) {
            return this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
        }
        return this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(tenantId).execute().getId();
    }

    protected String createAndCloseCaseInstance(String tenantId) {
        CaseInstanceBuilder builder = this.caseService.withCaseDefinitionByKey("oneTaskCase");
        String caseInstanceId = tenantId == null ? builder.create().getId() : builder.caseDefinitionTenantId(tenantId).create().getId();
        this.caseService.completeCaseExecution(caseInstanceId);
        this.caseService.closeCaseInstance(caseInstanceId);
        return caseInstanceId;
    }

    protected String evaluateDecisionTable(String tenantId) {
        String decisionDefinitionId = tenantId == null ? ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult()).getId() : ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{tenantId}).singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"bronze");
        this.decisionService.evaluateDecisionTableById(decisionDefinitionId, (Map)variables);
        return decisionDefinitionId;
    }

    protected String createTaskForTenant(String tenantId) {
        Task task = this.taskService.newTask();
        task.setTenantId(TENANT_ONE);
        this.taskService.saveTask(task);
        this.taskService.complete(task.getId());
        return task.getId();
    }
}

