/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CreateAndResolveIncidentTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Test
    public void createIncident() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "aa", "bar");
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().executionId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)incident2.getId(), (Object)incident.getId());
        Assert.assertEquals((Object)"foo", (Object)incident2.getIncidentType());
        Assert.assertEquals((Object)"aa", (Object)incident2.getConfiguration());
        Assert.assertEquals((Object)"bar", (Object)incident2.getIncidentMessage());
        Assert.assertEquals((Object)processInstance.getId(), (Object)incident2.getExecutionId());
    }

    @Test
    public void createIncidentWithNullExecution() {
        try {
            this.runtimeService.createIncident("foo", null, "userTask1", "bar");
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Execution id cannot be null"));
        }
    }

    @Test
    public void createIncidentWithNullIncidentType() {
        try {
            this.runtimeService.createIncident(null, "processInstanceId", "foo", "bar");
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"incidentType is null"));
        }
    }

    @Test
    public void createIncidentWithNonExistingExecution() {
        try {
            this.runtimeService.createIncident("foo", "aaa", "bbb", "bar");
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot find an execution with executionId 'aaa'"));
        }
    }

    @Test
    public void resolveIncident() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "userTask1", "bar");
        this.runtimeService.resolveIncident(incident.getId());
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().executionId(processInstance.getId()).singleResult();
        Assert.assertNull((Object)incident2);
    }

    @Test
    public void resolveUnexistingIncident() {
        try {
            this.runtimeService.resolveIncident("foo");
            Assert.fail((String)"Exception expected");
        }
        catch (NotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot find an incident with id 'foo'"));
        }
    }

    @Test
    public void resolveNullIncident() {
        try {
            this.runtimeService.resolveIncident(null);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"incidentId is null"));
        }
    }

    @Test
    public void resolveIncidentOfTypeFailedJob() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        List jobs = this.engineRule.getManagementService().createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            this.engineRule.getManagementService().setJobRetries(job.getId(), 1);
            try {
                this.engineRule.getManagementService().executeJob(job.getId());
            }
            catch (Exception e) {}
        }
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        try {
            this.runtimeService.resolveIncident(incident.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot resolve an incident of type failedJob"));
        }
    }
}

