/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.TransitionInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.DummySerializable;
import org.camunda.bpm.engine.test.api.runtime.util.SimpleSerializableBean;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.engine.test.history.SerializableVariable;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.TestExecutionListener;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;

public class RuntimeServiceTest
extends PluggableProcessEngineTestCase {
    public static final String TESTING_INSTANCE_DELETION = "testing instance deletion";
    public static final String A_STREAM = "aStream";

    public void testStartProcessInstanceByKeyNullKey() {
        try {
            this.runtimeService.startProcessInstanceByKey(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testStartProcessInstanceByKeyUnexistingKey() {
        try {
            this.runtimeService.startProcessInstanceByKey("unexistingkey");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no processes deployed with key", ae.getMessage());
        }
    }

    public void testStartProcessInstanceByIdNullId() {
        try {
            this.runtimeService.startProcessInstanceById(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testStartProcessInstanceByIdUnexistingId() {
        try {
            this.runtimeService.startProcessInstanceById("unexistingId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no deployed process definition found with id", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartProcessInstanceByIdNullVariables() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)null);
        RuntimeServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void startProcessInstanceWithBusinessKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "123");
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        RuntimeServiceTest.assertEquals((String)"123", (String)processInstance.getBusinessKey());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "456", CollectionUtil.singletonMap((String)"var", (Object)"value"));
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        RuntimeServiceTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        RuntimeServiceTest.assertEquals((Object)"var", (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
        processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId(), "789");
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        RuntimeServiceTest.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId(), "101123", CollectionUtil.singletonMap((String)"var", (Object)"value2"));
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        RuntimeServiceTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        RuntimeServiceTest.assertEquals((Object)"var", (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RuntimeServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), TESTING_INSTANCE_DELETION);
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        if (!"none".equals(this.processEngineConfiguration.getHistory())) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            RuntimeServiceTest.assertEquals((String)TESTING_INSTANCE_DELETION, (String)historicTaskInstance.getDeleteReason());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstances() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstances(Arrays.asList(processInstance.getId(), processInstance2.getId()), null, false, false);
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment
    public void testDeleteProcessInstanceWithListeners() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "");
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        RuntimeServiceTest.assertEquals((int)10, (int)recordedEvents.size());
        HashSet<RecorderExecutionListener.RecordedEvent> startEvents = new HashSet<RecorderExecutionListener.RecordedEvent>();
        HashSet<RecorderExecutionListener.RecordedEvent> endEvents = new HashSet<RecorderExecutionListener.RecordedEvent>();
        for (RecorderExecutionListener.RecordedEvent event : recordedEvents) {
            if (event.getEventName().equals("start")) {
                startEvents.add(event);
                continue;
            }
            if (!event.getEventName().equals("end")) continue;
            endEvents.add(event);
        }
        Assert.assertThat(startEvents, (Matcher)IsCollectionWithSize.hasSize((int)5));
        Assert.assertThat(endEvents, (Matcher)IsCollectionWithSize.hasSize((int)5));
        for (RecorderExecutionListener.RecordedEvent startEvent : startEvents) {
            Assert.assertThat((Object)startEvent.getActivityId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"innerTask1"), (Matcher)CoreMatchers.equalTo((Object)"innerTask2"), (Matcher)CoreMatchers.equalTo((Object)"outerTask"), (Matcher)CoreMatchers.equalTo((Object)"subProcess"), (Matcher)CoreMatchers.equalTo((Object)"theStart"))));
            for (RecorderExecutionListener.RecordedEvent endEvent : endEvents) {
                if (!startEvent.getActivityId().equals(endEvent.getActivityId())) continue;
                Assert.assertThat((Object)startEvent.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)endEvent.getActivityInstanceId()));
                Assert.assertThat((Object)startEvent.getExecutionId(), (Matcher)CoreMatchers.is((Object)endEvent.getExecutionId()));
            }
        }
        for (RecorderExecutionListener.RecordedEvent recordedEvent : endEvents) {
            Assert.assertThat((Object)recordedEvent.getActivityId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"innerTask1"), (Matcher)CoreMatchers.equalTo((Object)"innerTask2"), (Matcher)CoreMatchers.equalTo((Object)"outerTask"), (Matcher)CoreMatchers.equalTo((Object)"subProcess"), (Matcher)CoreMatchers.nullValue())));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceSkipCustomListenersEnsureHistoryWritten() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, true);
        if (!"none".equals(this.processEngineConfiguration.getHistory())) {
            List hais = this.historyService.createHistoricActivityInstanceQuery().list();
            for (HistoricActivityInstance hai : hais) {
                RuntimeServiceTest.assertNotNull((Object)hai.getEndTime());
            }
        }
    }

    @Deployment
    public void testDeleteProcessInstanceSkipCustomListeners() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, false);
        RuntimeServiceTest.assertTrue((TestExecutionListener.collectedEvents.size() == 1 ? 1 : 0) != 0);
        TestExecutionListener.reset();
        processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, true);
        RuntimeServiceTest.assertTrue((TestExecutionListener.collectedEvents.size() == 0 ? 1 : 0) != 0);
        TestExecutionListener.reset();
    }

    @Deployment
    public void testDeleteProcessInstanceSkipCustomListenersScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, false);
        RuntimeServiceTest.assertTrue((TestExecutionListener.collectedEvents.size() == 1 ? 1 : 0) != 0);
        TestExecutionListener.reset();
        processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, true);
        RuntimeServiceTest.assertTrue((TestExecutionListener.collectedEvents.size() == 0 ? 1 : 0) != 0);
        TestExecutionListener.reset();
    }

    @Deployment
    public void testDeleteProcessInstanceSkipCustomTaskListeners() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RecorderTaskListener.clear();
        this.runtimeService.deleteProcessInstance(instance.getId(), null, false);
        RuntimeServiceTest.assertEquals((int)1, (int)RecorderTaskListener.getRecordedEvents().size());
        RuntimeServiceTest.assertEquals((String)"delete", (String)RecorderTaskListener.getRecordedEvents().get(0).getEvent());
        instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RecorderTaskListener.clear();
        this.runtimeService.deleteProcessInstance(instance.getId(), null, true);
        RuntimeServiceTest.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcessWithIoMappings.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    public void testDeleteProcessInstanceSkipIoMappings() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        this.runtimeService.deleteProcessInstance(instance.getId(), null, false, true, true);
        this.assertProcessEnded(instance.getId());
        RuntimeServiceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance.getId()).list().size());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("inputMappingExecuted").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcessWithIoMappings.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    public void testDeleteProcessInstanceWithoutSkipIoMappings() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        this.runtimeService.deleteProcessInstance(instance.getId(), null, false, true, false);
        this.assertProcessEnded(instance.getId());
        RuntimeServiceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance.getId()).list().size());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("inputMappingExecuted").count());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("outputMappingExecuted").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testCascadingDeleteSubprocessInstanceSkipIoMappings.Calling.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testCascadingDeleteSubprocessInstanceSkipIoMappings.Called.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    public void testCascadingDeleteSubprocessInstanceSkipIoMappings() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstance instance2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(instance.getId()).singleResult();
        this.runtimeService.deleteProcessInstance(instance.getId(), "test_purposes", false, true, true);
        this.assertProcessEnded(instance.getId());
        RuntimeServiceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance2.getId()).list().size());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("inputMappingExecuted").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testCascadingDeleteSubprocessInstanceSkipIoMappings.Calling.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testCascadingDeleteSubprocessInstanceSkipIoMappings.Called.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    public void testCascadingDeleteSubprocessInstanceWithoutSkipIoMappings() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstance instance2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(instance.getId()).singleResult();
        this.runtimeService.deleteProcessInstance(instance.getId(), "test_purposes", false, true, false);
        this.assertProcessEnded(instance.getId());
        RuntimeServiceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance2.getId()).list().size());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("inputMappingExecuted").count());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("outputMappingExecuted").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceNullReason() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RuntimeServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
    }

    public void testDeleteProcessInstancesManyParallelSubprocesses() {
        BpmnModelInstance multiInstanceWithSubprocess = ((MultiInstanceLoopCharacteristicsBuilder)Bpmn.createExecutableProcess((String)"multiInstanceWithSubprocess").startEvent().subProcess().embeddedSubProcess().startEvent().userTask("userTask").endEvent().subProcessDone().multiInstance().cardinality("300")).multiInstanceDone().endEvent().done();
        this.deployment(new BpmnModelInstance[]{multiInstanceWithSubprocess});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("multiInstanceWithSubprocess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "some reason");
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
    }

    public void testDeleteProcessInstanceUnexistingId() {
        try {
            this.runtimeService.deleteProcessInstance("enexistingInstanceId", null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("No process instance found for id", ae.getMessage());
            RuntimeServiceTest.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    public void testDeleteProcessInstanceNullId() {
        try {
            this.runtimeService.deleteProcessInstance(null, "test null id delete");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("processInstanceId is null", ae.getMessage());
            RuntimeServiceTest.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    @Deployment
    public void testDeleteProcessInstanceWithActiveCompensation() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("compensationProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        Task afterSubProcessTask = (Task)this.taskService.createTaskQuery().singleResult();
        RuntimeServiceTest.assertEquals((String)"taskAfterSubprocess", (String)afterSubProcessTask.getTaskDefinitionKey());
        this.taskService.complete(afterSubProcessTask.getId());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("outerAfterBoundaryTask").count());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("innerAfterBoundaryTask").count());
        this.runtimeService.deleteProcessInstance(instance.getId(), "");
        this.assertProcessEnded(instance.getId());
    }

    @Deployment
    public void testDeleteProcessInstanceWithVariableOnScopeAndConcurrentExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task")).execute();
        List executions = this.runtimeService.createExecutionQuery().list();
        for (Execution execution : executions) {
            this.runtimeService.setVariableLocal(execution.getId(), "foo", (Object)"bar");
        }
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testFindActiveActivityIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List activities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertNotNull((Object)activities);
        RuntimeServiceTest.assertEquals((int)1, (int)activities.size());
    }

    public void testFindActiveActivityIdsUnexistingExecututionId() {
        try {
            this.runtimeService.getActiveActivityIds("unexistingExecutionId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    public void testFindActiveActivityIdsNullExecututionId() {
        try {
            this.runtimeService.getActiveActivityIds(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment
    public void testFindActiveActivityIdProcessWithErrorEventAndSubProcess() {
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceByKey("errorEventSubprocess");
        List activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertEquals((int)3, (int)activeActivities.size());
        List tasks = this.taskService.createTaskQuery().list();
        RuntimeServiceTest.assertEquals((int)2, (int)tasks.size());
        Task parallelUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("ParallelUserTask") && !task.getName().equals("MainUserTask")) {
                RuntimeServiceTest.fail((String)("Expected: <ParallelUserTask> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("ParallelUserTask")) continue;
            parallelUserTask = task;
        }
        RuntimeServiceTest.assertNotNull(parallelUserTask);
        this.taskService.complete(parallelUserTask.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("subprocess1WaitBeforeError").singleResult();
        this.runtimeService.signal(execution.getId());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertEquals((int)2, (int)activeActivities.size());
        tasks = this.taskService.createTaskQuery().list();
        RuntimeServiceTest.assertEquals((int)2, (int)tasks.size());
        Task beforeErrorUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("BeforeError") && !task.getName().equals("MainUserTask")) {
                RuntimeServiceTest.fail((String)("Expected: <BeforeError> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("BeforeError")) continue;
            beforeErrorUserTask = task;
        }
        RuntimeServiceTest.assertNotNull(beforeErrorUserTask);
        this.taskService.complete(beforeErrorUserTask.getId());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertEquals((int)2, (int)activeActivities.size());
        tasks = this.taskService.createTaskQuery().list();
        RuntimeServiceTest.assertEquals((int)2, (int)tasks.size());
        Task afterErrorUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("AfterError") && !task.getName().equals("MainUserTask")) {
                RuntimeServiceTest.fail((String)("Expected: <AfterError> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("AfterError")) continue;
            afterErrorUserTask = task;
        }
        RuntimeServiceTest.assertNotNull(afterErrorUserTask);
        this.taskService.complete(afterErrorUserTask.getId());
        tasks = this.taskService.createTaskQuery().list();
        RuntimeServiceTest.assertEquals((int)1, (int)tasks.size());
        RuntimeServiceTest.assertEquals((String)"MainUserTask", (String)((Task)tasks.get(0)).getName());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertEquals((int)1, (int)activeActivities.size());
        RuntimeServiceTest.assertEquals((String)"MainUserTask", (String)((String)activeActivities.get(0)));
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.assertProcessEnded(processInstance.getId());
    }

    public void testSignalUnexistingExecututionId() {
        try {
            this.runtimeService.signal("unexistingExecutionId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
            RuntimeServiceTest.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    public void testSignalNullExecutionId() {
        try {
            this.runtimeService.signal(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
            RuntimeServiceTest.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    @Deployment
    public void testSignalWithProcessVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals((Object)variables, processVariables);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testSignalWithProcessVariables.bpmn20.xml"})
    public void testSignalWithSignalNameAndData() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), "dummySignalName", (Object)new String("SignalData"), processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals((Object)variables, processVariables);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testSignalWithProcessVariables.bpmn20.xml"})
    public void testSignalWithoutSignalNameAndData() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), null, null, processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals(processVariables, (Object)variables);
    }

    @Deployment
    public void testSignalInactiveExecution() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("testSignalInactiveExecution");
        try {
            this.runtimeService.signal(instance.getId());
            RuntimeServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("cannot signal execution " + instance.getId() + ": it has no current activity", e.getMessage());
        }
        catch (Exception e) {
            RuntimeServiceTest.fail((String)"Signalling an inactive execution that has no activity should result in a ProcessEngineException");
        }
    }

    public void testGetVariablesUnexistingExecutionId() {
        try {
            this.runtimeService.getVariables("unexistingExecutionId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    public void testGetVariablesNullExecutionId() {
        try {
            this.runtimeService.getVariables(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    public void testGetVariableUnexistingExecutionId() {
        try {
            this.runtimeService.getVariables("unexistingExecutionId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    public void testGetVariableNullExecutionId() {
        try {
            this.runtimeService.getVariables(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariableUnexistingVariableName() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Object variableValue = this.runtimeService.getVariable(processInstance.getId(), "unexistingVariable");
        RuntimeServiceTest.assertNull((Object)variableValue);
    }

    public void testSetVariableUnexistingExecutionId() {
        try {
            this.runtimeService.setVariable("unexistingExecutionId", "variableName", (Object)"value");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    public void testSetVariableNullExecutionId() {
        try {
            this.runtimeService.setVariable(null, "variableName", (Object)"variableValue");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetVariableNullVariableName() {
        try {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            this.runtimeService.setVariable(processInstance.getId(), null, (Object)"variableValue");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("variableName is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(processInstance.getId(), vars);
        RuntimeServiceTest.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesTyped() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        VariableMap variablesTyped = this.runtimeService.getVariablesTyped(processInstance.getId());
        RuntimeServiceTest.assertEquals(vars, (Object)variablesTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesTypedDeserialize() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("broken", (Object)Variables.serializedObjectValue((String)"broken").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("unexisting").create()));
        VariableMap variablesTyped = this.runtimeService.getVariablesTyped(processInstance.getId(), false);
        RuntimeServiceTest.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        variablesTyped = this.runtimeService.getVariablesTyped(processInstance.getId(), Arrays.asList("broken"), false);
        RuntimeServiceTest.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        try {
            this.runtimeService.getVariablesTyped(processInstance.getId());
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
        try {
            this.runtimeService.getVariablesTyped(processInstance.getId(), Arrays.asList("broken"), true);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesLocalTyped() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        VariableMap variablesTyped = this.runtimeService.getVariablesLocalTyped(processInstance.getId());
        RuntimeServiceTest.assertEquals(vars, (Object)variablesTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesLocalTypedDeserialize() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("broken", (Object)Variables.serializedObjectValue((String)"broken").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("unexisting").create()));
        VariableMap variablesTyped = this.runtimeService.getVariablesLocalTyped(processInstance.getId(), false);
        RuntimeServiceTest.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        variablesTyped = this.runtimeService.getVariablesLocalTyped(processInstance.getId(), Arrays.asList("broken"), false);
        RuntimeServiceTest.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        try {
            this.runtimeService.getVariablesLocalTyped(processInstance.getId());
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
        try {
            this.runtimeService.getVariablesLocalTyped(processInstance.getId(), Arrays.asList("broken"), true);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
    }

    public void testSetVariablesUnexistingExecutionId() {
        try {
            this.runtimeService.setVariables("unexistingexecution", Collections.EMPTY_MAP);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingexecution doesn't exist", ae.getMessage());
        }
    }

    public void testSetVariablesNullExecutionId() {
        try {
            this.runtimeService.setVariables(null, Collections.EMPTY_MAP);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    private void checkHistoricVariableUpdateEntity(String variableName, String processInstanceId) {
        if (this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            boolean deletedVariableUpdateFound = false;
            List resultSet = this.historyService.createHistoricDetailQuery().processInstanceId(processInstanceId).list();
            for (HistoricDetail currentHistoricDetail : resultSet) {
                RuntimeServiceTest.assertTrue((boolean)(currentHistoricDetail instanceof HistoricDetailVariableInstanceUpdateEntity));
                HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = (HistoricDetailVariableInstanceUpdateEntity)currentHistoricDetail;
                if (!historicVariableUpdate.getName().equals(variableName) || historicVariableUpdate.getValue() != null) continue;
                if (deletedVariableUpdateFound) {
                    RuntimeServiceTest.fail((String)"Mismatch: A HistoricVariableUpdateEntity with a null value already found");
                    continue;
                }
                deletedVariableUpdateFound = true;
            }
            RuntimeServiceTest.assertTrue((boolean)deletedVariableUpdateFound);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(processInstance.getId(), vars);
        this.runtimeService.removeVariable(processInstance.getId(), "variable1");
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testRemoveVariableInParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.removeVariable(currentTask.getExecutionId(), "variable1");
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    public void testRemoveVariableNullExecutionId() {
        try {
            this.runtimeService.removeVariable(null, "variable");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariableLocal() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.removeVariableLocal(processInstance.getId(), "variable1");
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testRemoveVariableLocalWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariableLocal(currentTask.getExecutionId(), "localVariable", (Object)"local value");
        RuntimeServiceTest.assertEquals((Object)"local value", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "localVariable"));
        this.runtimeService.removeVariableLocal(currentTask.getExecutionId(), "localVariable");
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "localVariable"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "localVariable"));
        RuntimeServiceTest.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("localVariable", processInstance.getId());
    }

    public void testRemoveLocalVariableNullExecutionId() {
        try {
            this.runtimeService.removeVariableLocal(null, "variable");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance.getId(), "variable3", (Object)"value3");
        this.runtimeService.removeVariables(processInstance.getId(), vars.keySet());
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testRemoveVariablesWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        this.runtimeService.setVariable(processInstance.getId(), "variable3", (Object)"value3");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.removeVariables(currentTask.getExecutionId(), vars.keySet());
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable3"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    public void testRemoveVariablesNullExecutionId() {
        try {
            this.runtimeService.removeVariables(null, (Collection)Collections.EMPTY_LIST);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testRemoveVariablesLocalWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> varsToDelete = new HashMap<String, String>();
        varsToDelete.put("variable3", "value3");
        varsToDelete.put("variable4", "value4");
        varsToDelete.put("variable5", "value5");
        this.runtimeService.setVariablesLocal(currentTask.getExecutionId(), varsToDelete);
        this.runtimeService.setVariableLocal(currentTask.getExecutionId(), "variable6", (Object)"value6");
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value4", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable4"));
        RuntimeServiceTest.assertEquals((Object)"value4", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable4"));
        RuntimeServiceTest.assertEquals((Object)"value5", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable5"));
        RuntimeServiceTest.assertEquals((Object)"value5", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable5"));
        RuntimeServiceTest.assertEquals((Object)"value6", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable6"));
        RuntimeServiceTest.assertEquals((Object)"value6", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable6"));
        this.runtimeService.removeVariablesLocal(currentTask.getExecutionId(), varsToDelete.keySet());
        RuntimeServiceTest.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable4"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable4"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable5"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable5"));
        RuntimeServiceTest.assertEquals((Object)"value6", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable6"));
        RuntimeServiceTest.assertEquals((Object)"value6", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable6"));
        this.checkHistoricVariableUpdateEntity("variable3", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable4", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable5", processInstance.getId());
    }

    public void testRemoveVariablesLocalNullExecutionId() {
        try {
            this.runtimeService.removeVariablesLocal(null, (Collection)Collections.EMPTY_LIST);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testUpdateVariables() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "value1");
        modifications.put("variable2", "value2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable1");
        HashMap<String, String> initialVariables = new HashMap<String, String>();
        initialVariables.put("variable1", "initialValue");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", initialVariables);
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstance.getId(), modifications, deletions);
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testUpdateVariablesLocal() {
        HashMap<String, String> globalVars = new HashMap<String, String>();
        globalVars.put("variable4", "value4");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", globalVars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> localVars = new HashMap<String, String>();
        localVars.put("variable1", "value1");
        localVars.put("variable2", "value2");
        localVars.put("variable3", "value3");
        this.runtimeService.setVariablesLocal(currentTask.getExecutionId(), localVars);
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(currentTask.getExecutionId(), modifications, deletions);
        RuntimeServiceTest.assertEquals((Object)"anotherValue1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value4", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable4"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchPanicSignal.bpmn20.xml"})
    public void testSignalEventReceived() {
        List page;
        int executions;
        this.startSignalCatchProcesses();
        RuntimeServiceTest.assertEquals((long)12L, (long)this.runtimeService.createExecutionQuery().count());
        this.runtimeService.signalEventReceived("alert");
        RuntimeServiceTest.assertEquals((long)6L, (long)this.runtimeService.createExecutionQuery().count());
        this.runtimeService.signalEventReceived("panic");
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        this.startSignalCatchProcesses();
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").listPage(0, 1);
            this.runtimeService.signalEventReceived("alert", ((Execution)page.get(0)).getId());
            RuntimeServiceTest.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").count());
        }
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().signalEventSubscriptionName("panic").listPage(0, 1);
            this.runtimeService.signalEventReceived("panic", ((Execution)page.get(0)).getId());
            RuntimeServiceTest.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("panic").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertMessage.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchPanicMessage.bpmn20.xml"})
    public void testMessageEventReceived() {
        List page;
        int executions;
        this.startMessageCatchProcesses();
        RuntimeServiceTest.assertEquals((long)12L, (long)this.runtimeService.createExecutionQuery().count());
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("alert").listPage(0, 1);
            this.runtimeService.messageEventReceived("alert", ((Execution)page.get(0)).getId());
            RuntimeServiceTest.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("alert").count());
        }
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("panic").listPage(0, 1);
            this.runtimeService.messageEventReceived("panic", ((Execution)page.get(0)).getId());
            RuntimeServiceTest.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("panic").count());
        }
    }

    public void testSignalEventReceivedNonExistingExecution() {
        try {
            this.runtimeService.signalEventReceived("alert", "nonexistingExecution");
            RuntimeServiceTest.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            RuntimeServiceTest.assertTrue((boolean)e.getMessage().contains("Cannot find execution with id 'nonexistingExecution'"));
        }
    }

    public void testMessageEventReceivedNonExistingExecution() {
        try {
            this.runtimeService.messageEventReceived("alert", "nonexistingExecution");
            RuntimeServiceTest.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            RuntimeServiceTest.assertTrue((boolean)e.getMessage().contains("Execution with id 'nonexistingExecution' does not have a subscription to a message event with name 'alert'"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertSignal.bpmn20.xml"})
    public void testExecutionWaitingForDifferentSignal() {
        this.runtimeService.startProcessInstanceByKey("catchAlertSignal");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").singleResult();
        try {
            this.runtimeService.signalEventReceived("bogusSignal", execution.getId());
            RuntimeServiceTest.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            RuntimeServiceTest.assertTrue((boolean)e.getMessage().contains("has not subscribed to a signal event with name 'bogusSignal'"));
        }
    }

    private void startSignalCatchProcesses() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("catchAlertSignal");
            this.runtimeService.startProcessInstanceByKey("catchPanicSignal");
        }
    }

    private void startMessageCatchProcesses() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("catchAlertMessage");
            this.runtimeService.startProcessInstanceByKey("catchPanicMessage");
        }
    }

    public void testActivityInstanceForNonExistingProcessInstanceId() {
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getActivityInstance("some-nonexisting-id"));
    }

    public void testActivityInstanceForNullProcessInstanceId() {
        try {
            this.runtimeService.getActivityInstance(null);
            RuntimeServiceTest.fail((String)"PEE expected!");
        }
        catch (ProcessEngineException engineException) {
            RuntimeServiceTest.assertTrue((boolean)engineException.getMessage().contains("processInstanceId is null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivityInstancePopulated() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "business-key");
        ActivityInstance rootActInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)rootActInstance.getProcessInstanceId());
        RuntimeServiceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)rootActInstance.getProcessDefinitionId());
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)rootActInstance.getProcessInstanceId());
        RuntimeServiceTest.assertTrue((boolean)rootActInstance.getExecutionIds()[0].equals(processInstance.getId()));
        RuntimeServiceTest.assertEquals((String)rootActInstance.getProcessDefinitionId(), (String)rootActInstance.getActivityId());
        RuntimeServiceTest.assertNull((Object)rootActInstance.getParentActivityInstanceId());
        RuntimeServiceTest.assertEquals((String)"processDefinition", (String)rootActInstance.getActivityType());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ActivityInstance childActivityInstance = rootActInstance.getChildActivityInstances()[0];
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)childActivityInstance.getProcessInstanceId());
        RuntimeServiceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)childActivityInstance.getProcessDefinitionId());
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)childActivityInstance.getProcessInstanceId());
        RuntimeServiceTest.assertTrue((boolean)childActivityInstance.getExecutionIds()[0].equals(task.getExecutionId()));
        RuntimeServiceTest.assertEquals((String)"theTask", (String)childActivityInstance.getActivityId());
        RuntimeServiceTest.assertEquals((String)rootActInstance.getId(), (String)childActivityInstance.getParentActivityInstanceId());
        RuntimeServiceTest.assertEquals((String)"userTask", (String)childActivityInstance.getActivityType());
        RuntimeServiceTest.assertNotNull((Object)childActivityInstance.getChildActivityInstances());
        RuntimeServiceTest.assertNotNull((Object)childActivityInstance.getChildTransitionInstances());
        RuntimeServiceTest.assertEquals((int)0, (int)childActivityInstance.getChildActivityInstances().length);
        RuntimeServiceTest.assertEquals((int)0, (int)childActivityInstance.getChildTransitionInstances().length);
    }

    @Deployment
    public void testActivityInstanceTreeForAsyncBeforeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theTask").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildTransitionInstances()[0];
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceTreeForConcurrentAsyncBeforeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentTasksProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").transition("asyncTask").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        RuntimeServiceTest.assertEquals((String)asyncExecutionId, (String)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceTreeForAsyncBeforeStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theStart").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildTransitionInstances()[0];
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceTreeForAsyncAfterTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theTask").done());
        TransitionInstance asyncAfterTransitionInstance = tree.getChildTransitionInstances()[0];
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)asyncAfterTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceTreeForConcurrentAsyncAfterTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentTasksProcess");
        Task asyncTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("asyncTask").singleResult();
        RuntimeServiceTest.assertNotNull((Object)asyncTask);
        this.taskService.complete(asyncTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").transition("asyncTask").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        RuntimeServiceTest.assertEquals((String)asyncExecutionId, (String)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceTreeForAsyncAfterEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncEndEventProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theEnd").done());
        TransitionInstance asyncAfterTransitionInstance = tree.getChildTransitionInstances()[0];
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)asyncAfterTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceTreeForNestedAsyncBeforeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").transition("theTask").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildActivityInstances()[0].getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        RuntimeServiceTest.assertEquals((String)asyncExecutionId, (String)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceTreeForNestedAsyncBeforeStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").transition("theSubProcessStart").done());
    }

    @Deployment
    public void testActivityInstanceTreeForNestedAsyncAfterTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").transition("theTask").done());
        TransitionInstance asyncAfterTransitionInstance = tree.getChildActivityInstances()[0].getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        RuntimeServiceTest.assertEquals((String)asyncExecutionId, (String)asyncAfterTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceTreeForNestedAsyncAfterEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncEndEventProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").transition("theSubProcessEnd").done());
        TransitionInstance asyncAfterTransitionInstance = tree.getChildActivityInstances()[0].getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        RuntimeServiceTest.assertEquals((String)asyncExecutionId, (String)asyncAfterTransitionInstance.getExecutionId());
    }

    @Deployment
    public void testActivityInstanceForConcurrentSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentSubProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        RuntimeServiceTest.assertNotNull((Object)tree);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
    }

    @Deployment
    public void testGetActivityInstancesForActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstance[] processActivityInstances = tree.getActivityInstances(definition.getId());
        RuntimeServiceTest.assertEquals((int)1, (int)processActivityInstances.length);
        RuntimeServiceTest.assertEquals((String)tree.getId(), (String)processActivityInstances[0].getId());
        RuntimeServiceTest.assertEquals((String)definition.getId(), (String)processActivityInstances[0].getActivityId());
        this.assertActivityInstances(tree.getActivityInstances("subProcess#multiInstanceBody"), 1, "subProcess#multiInstanceBody");
        this.assertActivityInstances(tree.getActivityInstances("subProcess"), 3, "subProcess");
        this.assertActivityInstances(tree.getActivityInstances("innerTask"), 3, "innerTask");
        ActivityInstance subProcessInstance = tree.getChildActivityInstances()[0].getChildActivityInstances()[0];
        this.assertActivityInstances(subProcessInstance.getActivityInstances("subProcess"), 1, "subProcess");
        ActivityInstance[] childInstances = subProcessInstance.getActivityInstances("innerTask");
        RuntimeServiceTest.assertEquals((int)1, (int)childInstances.length);
        RuntimeServiceTest.assertEquals((String)subProcessInstance.getChildActivityInstances()[0].getId(), (String)childInstances[0].getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetActivityInstancesForActivity.bpmn20.xml"})
    public void testGetInvalidActivityInstancesForActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        try {
            tree.getActivityInstances(null);
            RuntimeServiceTest.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetActivityInstancesForActivity.bpmn20.xml"})
    public void testGetActivityInstancesForNonExistingActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstance[] instances = tree.getActivityInstances("aNonExistingActivityId");
        RuntimeServiceTest.assertNotNull((Object)instances);
        RuntimeServiceTest.assertEquals((int)0, (int)instances.length);
    }

    @Deployment
    public void testGetTransitionInstancesForActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        Job job = (Job)this.managementService.createJobQuery().listPage(0, 1).get(0);
        this.managementService.executeJob(job.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        RuntimeServiceTest.assertEquals((int)0, (int)tree.getTransitionInstances("subProcess").length);
        TransitionInstance[] asyncBeforeInstances = tree.getTransitionInstances("innerTask");
        RuntimeServiceTest.assertEquals((int)2, (int)asyncBeforeInstances.length);
        RuntimeServiceTest.assertEquals((String)"innerTask", (String)asyncBeforeInstances[0].getActivityId());
        RuntimeServiceTest.assertEquals((String)"innerTask", (String)asyncBeforeInstances[1].getActivityId());
        RuntimeServiceTest.assertFalse((boolean)asyncBeforeInstances[0].getId().equals(asyncBeforeInstances[1].getId()));
        TransitionInstance[] asyncEndEventInstances = tree.getTransitionInstances("theSubProcessEnd");
        RuntimeServiceTest.assertEquals((int)1, (int)asyncEndEventInstances.length);
        RuntimeServiceTest.assertEquals((String)"theSubProcessEnd", (String)asyncEndEventInstances[0].getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetTransitionInstancesForActivity.bpmn20.xml"})
    public void testGetInvalidTransitionInstancesForActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        try {
            tree.getTransitionInstances(null);
            RuntimeServiceTest.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetTransitionInstancesForActivity.bpmn20.xml"})
    public void testGetTransitionInstancesForNonExistingActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance[] instances = tree.getTransitionInstances("aNonExistingActivityId");
        RuntimeServiceTest.assertNotNull((Object)instances);
        RuntimeServiceTest.assertEquals((int)0, (int)instances.length);
    }

    protected void assertActivityInstances(ActivityInstance[] instances, int expectedAmount, String expectedActivityId) {
        RuntimeServiceTest.assertEquals((int)expectedAmount, (int)instances.length);
        HashSet<String> instanceIds = new HashSet<String>();
        for (ActivityInstance instance : instances) {
            RuntimeServiceTest.assertEquals((String)expectedActivityId, (String)instance.getActivityId());
            instanceIds.add(instance.getId());
        }
        RuntimeServiceTest.assertEquals((int)expectedAmount, (int)instanceIds.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testChangeVariableType() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        DummySerializable dummy = new DummySerializable();
        this.runtimeService.setVariable(instance.getId(), "dummy", (Object)dummy);
        this.runtimeService.setVariable(instance.getId(), "dummy", (Object)47);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        RuntimeServiceTest.assertEquals((Object)47, (Object)variableInstance.getValue());
        RuntimeServiceTest.assertEquals((String)ValueType.INTEGER.getName(), (String)variableInstance.getTypeName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartByKeyWithCaseInstanceId() {
        String caseInstanceId = "aCaseInstanceId";
        ProcessInstance firstInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId);
        RuntimeServiceTest.assertEquals((String)caseInstanceId, (String)firstInstance.getCaseInstanceId());
        firstInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(firstInstance.getId()).singleResult();
        RuntimeServiceTest.assertNotNull((Object)firstInstance);
        RuntimeServiceTest.assertEquals((String)caseInstanceId, (String)firstInstance.getCaseInstanceId());
        ProcessInstance secondInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId, null);
        RuntimeServiceTest.assertEquals((String)caseInstanceId, (String)secondInstance.getCaseInstanceId());
        secondInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(secondInstance.getId()).singleResult();
        RuntimeServiceTest.assertNotNull((Object)secondInstance);
        RuntimeServiceTest.assertEquals((String)caseInstanceId, (String)secondInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartByIdWithCaseInstanceId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId();
        String caseInstanceId = "aCaseInstanceId";
        ProcessInstance firstInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId);
        RuntimeServiceTest.assertEquals((String)caseInstanceId, (String)firstInstance.getCaseInstanceId());
        firstInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(firstInstance.getId()).singleResult();
        RuntimeServiceTest.assertNotNull((Object)firstInstance);
        RuntimeServiceTest.assertEquals((String)caseInstanceId, (String)firstInstance.getCaseInstanceId());
        ProcessInstance secondInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId, null);
        RuntimeServiceTest.assertEquals((String)caseInstanceId, (String)secondInstance.getCaseInstanceId());
        secondInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(secondInstance.getId()).singleResult();
        RuntimeServiceTest.assertNotNull((Object)secondInstance);
        RuntimeServiceTest.assertEquals((String)caseInstanceId, (String)secondInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetAbstractNumberValueFails() {
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("var", (TypedValue)Variables.numberValue((Number)42)));
            RuntimeServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("cannot serialize value of abstract type number", e.getMessage());
        }
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        try {
            this.runtimeService.setVariable(processInstance.getId(), "var", (Object)Variables.numberValue((Number)42));
            RuntimeServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("cannot serialize value of abstract type number", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/messageStartEvent.bpmn20.xml"})
    public void testStartProcessInstanceByMessageWithEarlierVersionOfProcessDefinition() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/messageStartEvent_version2.bpmn20.xml").deploy().getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startMessage", processDefinition.getId());
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/messageStartEvent.bpmn20.xml"})
    public void testStartProcessInstanceByMessageWithLastVersionOfProcessDefinition() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/messageStartEvent_version2.bpmn20.xml").deploy().getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().latestVersion().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("newStartMessage", processDefinition.getId());
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/messageStartEvent.bpmn20.xml"})
    public void testStartProcessInstanceByMessageWithNonExistingMessageStartEvent() {
        String deploymentId = null;
        try {
            deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/messageStartEvent_version2.bpmn20.xml").deploy().getId();
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).singleResult();
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("newStartMessage", processDefinition.getId());
            RuntimeServiceTest.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot correlate message 'newStartMessage'"));
        }
        finally {
            if (deploymentId != null) {
                this.repositoryService.deleteDeployment(deploymentId, true);
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivityInstanceActivityNameProperty() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance[] activityInstances = tree.getActivityInstances("theTask");
        RuntimeServiceTest.assertEquals((int)1, (int)activityInstances.length);
        ActivityInstance task = activityInstances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityName());
        RuntimeServiceTest.assertEquals((String)"my task", (String)task.getActivityName());
    }

    @Deployment
    public void testTransitionInstanceActivityNamePropertyBeforeTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("firstServiceTask");
        TransitionInstance task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityName());
        RuntimeServiceTest.assertEquals((String)"First Service Task", (String)task.getActivityName());
        instances = tree.getTransitionInstances("secondServiceTask");
        task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityName());
        RuntimeServiceTest.assertEquals((String)"Second Service Task", (String)task.getActivityName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testTransitionInstanceActivityNamePropertyBeforeTask.bpmn20.xml"})
    public void testTransitionInstanceActivityTypePropertyBeforeTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("firstServiceTask");
        TransitionInstance task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityType());
        RuntimeServiceTest.assertEquals((String)"serviceTask", (String)task.getActivityType());
        instances = tree.getTransitionInstances("secondServiceTask");
        task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityType());
        RuntimeServiceTest.assertEquals((String)"serviceTask", (String)task.getActivityType());
    }

    @Deployment
    public void testTransitionInstanceActivityNamePropertyAfterTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("firstServiceTask");
        TransitionInstance task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityName());
        RuntimeServiceTest.assertEquals((String)"First Service Task", (String)task.getActivityName());
        instances = tree.getTransitionInstances("secondServiceTask");
        task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityName());
        RuntimeServiceTest.assertEquals((String)"Second Service Task", (String)task.getActivityName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testTransitionInstanceActivityNamePropertyAfterTask.bpmn20.xml"})
    public void testTransitionInstanceActivityTypePropertyAfterTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("firstServiceTask");
        TransitionInstance task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityType());
        RuntimeServiceTest.assertEquals((String)"serviceTask", (String)task.getActivityType());
        instances = tree.getTransitionInstances("secondServiceTask");
        task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityType());
        RuntimeServiceTest.assertEquals((String)"serviceTask", (String)task.getActivityType());
    }

    @Deployment
    public void testTransitionInstanceActivityNamePropertyBeforeStartEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("start");
        TransitionInstance task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityName());
        RuntimeServiceTest.assertEquals((String)"The Start Event", (String)task.getActivityName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testTransitionInstanceActivityNamePropertyBeforeStartEvent.bpmn20.xml"})
    public void testTransitionInstanceActivityTypePropertyBeforeStartEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("start");
        TransitionInstance task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityType());
        RuntimeServiceTest.assertEquals((String)"startEvent", (String)task.getActivityType());
    }

    @Deployment
    public void testTransitionInstanceActivityNamePropertyAfterStartEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("start");
        TransitionInstance task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityName());
        RuntimeServiceTest.assertEquals((String)"The Start Event", (String)task.getActivityName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testTransitionInstanceActivityNamePropertyAfterStartEvent.bpmn20.xml"})
    public void testTransitionInstanceActivityTypePropertyAfterStartEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("start");
        TransitionInstance task = instances[0];
        RuntimeServiceTest.assertNotNull((Object)task);
        RuntimeServiceTest.assertNotNull((Object)task.getActivityType());
        RuntimeServiceTest.assertEquals((String)"startEvent", (String)task.getActivityType());
    }

    public void testStartProcessInstanceByIdAfterReboot() {
        ProcessEngines.destroy();
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setProcessEngineName("reboot-test-schema");
        processEngineConfiguration.setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000");
        ProcessEngine schemaProcessEngine = processEngineConfiguration.buildProcessEngine();
        ProcessEngine processEngine = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        processEngine.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        List processDefinitions = processEngine.getRepositoryService().createProcessDefinitionQuery().list();
        RuntimeServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessInstance processInstance = processEngine.getRuntimeService().startProcessInstanceById(((ProcessDefinition)processDefinitions.get(0)).getId());
        String processInstanceId = processInstance.getId();
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        processEngine.close();
        RuntimeServiceTest.assertNotNull((Object)processEngine.getRuntimeService());
        processEngine = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        processInstance = (ProcessInstance)processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        TaskService taskService = processEngine.getTaskService();
        Task task = (Task)taskService.createTaskQuery().list().get(0);
        taskService.complete(task.getId());
        processInstance = (ProcessInstance)processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        RuntimeServiceTest.assertNull((Object)processInstance);
        processInstance = processEngine.getRuntimeService().startProcessInstanceById(((ProcessDefinition)processDefinitions.get(0)).getId());
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        processEngine.close();
        schemaProcessEngine.close();
    }

    @Deployment
    public void testVariableScope() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("test", "test");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess", varMap);
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        RuntimeServiceTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        RuntimeServiceTest.assertEquals((Object)"test2", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        RuntimeServiceTest.assertEquals((Object)"test2", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        RuntimeServiceTest.assertEquals((Object)"test", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        RuntimeServiceTest.assertEquals((Object)"test", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.runtimeService.setVariableLocal(subProcessTask.getExecutionId(), "test", (Object)"test3");
        RuntimeServiceTest.assertEquals((Object)"test3", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        RuntimeServiceTest.assertEquals((Object)"test3", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        RuntimeServiceTest.assertEquals((Object)"test", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        RuntimeServiceTest.assertEquals((Object)"test", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.runtimeService.setVariable(pi.getId(), "test", (Object)"test4");
        RuntimeServiceTest.assertEquals((Object)"test3", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        RuntimeServiceTest.assertEquals((Object)"test3", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        RuntimeServiceTest.assertEquals((Object)"test4", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        RuntimeServiceTest.assertEquals((Object)"test4", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.taskService.complete(subProcessTask.getId());
    }

    @Deployment
    public void testBasicVariableOperations() {
        Date now = new Date();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        byte[] bytes = "somebytes".getBytes();
        byte[] streamBytes = "morebytes".getBytes();
        Map variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "coca-cola");
        variables.put("dateVar", now);
        variables.put("nullVar", null);
        variables.put("serializableVar", serializable);
        variables.put("bytesVar", bytes);
        variables.put("byteStreamVar", new ByteArrayInputStream(streamBytes));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals((Object)"coca-cola", variables.get("stringVar"));
        RuntimeServiceTest.assertEquals((Object)928374L, variables.get("longVar"));
        RuntimeServiceTest.assertEquals((Object)123, variables.get("shortVar"));
        RuntimeServiceTest.assertEquals((Object)1234, variables.get("integerVar"));
        RuntimeServiceTest.assertEquals((Object)now, variables.get("dateVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("nullVar"));
        RuntimeServiceTest.assertEquals(serializable, variables.get("serializableVar"));
        RuntimeServiceTest.assertTrue((boolean)Arrays.equals(bytes, (byte[])variables.get("bytesVar")));
        RuntimeServiceTest.assertTrue((boolean)Arrays.equals(streamBytes, (byte[])variables.get("byteStreamVar")));
        RuntimeServiceTest.assertEquals((int)9, (int)variables.size());
        this.runtimeService.setVariable(processInstance.getId(), "longVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "bytesVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "byteStreamVar", null);
        variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals(null, variables.get("longVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("shortVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("integerVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("stringVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("dateVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("nullVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("serializableVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("bytesVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("byteStreamVar"));
        RuntimeServiceTest.assertEquals((int)9, (int)variables.size());
        this.runtimeService.setVariable(processInstance.getId(), "new var", (Object)"hi");
        this.runtimeService.setVariable(processInstance.getId(), "longVar", (Object)9987L);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", (Object)456);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", (Object)4567);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", (Object)"colgate");
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", (Object)now);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", serializable);
        this.runtimeService.setVariable(processInstance.getId(), "bytesVar", (Object)bytes);
        this.runtimeService.setVariable(processInstance.getId(), "byteStreamVar", (Object)new ByteArrayInputStream(streamBytes));
        variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals((Object)"hi", variables.get("new var"));
        RuntimeServiceTest.assertEquals((Object)9987L, variables.get("longVar"));
        RuntimeServiceTest.assertEquals((Object)456, variables.get("shortVar"));
        RuntimeServiceTest.assertEquals((Object)4567, variables.get("integerVar"));
        RuntimeServiceTest.assertEquals((Object)"colgate", variables.get("stringVar"));
        RuntimeServiceTest.assertEquals((Object)now, variables.get("dateVar"));
        RuntimeServiceTest.assertEquals(null, variables.get("nullVar"));
        RuntimeServiceTest.assertEquals(serializable, variables.get("serializableVar"));
        RuntimeServiceTest.assertTrue((boolean)Arrays.equals(bytes, (byte[])variables.get("bytesVar")));
        RuntimeServiceTest.assertTrue((boolean)Arrays.equals(streamBytes, (byte[])variables.get("byteStreamVar")));
        RuntimeServiceTest.assertEquals((int)10, (int)variables.size());
        ArrayList<String> varFilter = new ArrayList<String>(2);
        varFilter.add("stringVar");
        varFilter.add("integerVar");
        Map filteredVariables = this.runtimeService.getVariables(processInstance.getId(), varFilter);
        RuntimeServiceTest.assertEquals((int)2, (int)filteredVariables.size());
        RuntimeServiceTest.assertTrue((boolean)filteredVariables.containsKey("stringVar"));
        RuntimeServiceTest.assertTrue((boolean)filteredVariables.containsKey("integerVar"));
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", (Object)"a value");
        Object newValue = this.runtimeService.getVariable(processInstance.getId(), "nullVar");
        RuntimeServiceTest.assertNotNull((Object)newValue);
        RuntimeServiceTest.assertEquals((Object)"a value", (Object)newValue);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", (Object)100);
        variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals((Object)100, variables.get("serializableVar"));
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", serializable);
        variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals(serializable, variables.get("serializableVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testBasicVariableOperations.bpmn20.xml"})
    public void testOnlyChangeType() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("aVariable", 1234);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        RuntimeServiceTest.assertEquals((String)ValueType.INTEGER.getName(), (String)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", (Object)1234L);
        variable = (VariableInstance)query.singleResult();
        RuntimeServiceTest.assertEquals((String)ValueType.LONG.getName(), (String)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", (Object)1234);
        variable = (VariableInstance)query.singleResult();
        RuntimeServiceTest.assertEquals((String)ValueType.SHORT.getName(), (String)variable.getTypeName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testBasicVariableOperations.bpmn20.xml"})
    public void testChangeTypeFromSerializableUsingApi() {
        HashMap<String, SerializableVariable> variables = new HashMap<String, SerializableVariable>();
        variables.put("aVariable", new SerializableVariable("foo"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        RuntimeServiceTest.assertEquals((String)ValueType.OBJECT.getName(), (String)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", null);
        variable = (VariableInstance)query.singleResult();
        RuntimeServiceTest.assertEquals((String)ValueType.NULL.getName(), (String)variable.getTypeName());
    }

    @Deployment
    public void testChangeSerializableInsideEngine() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        SerializableVariable var = (SerializableVariable)this.taskService.getVariable(task.getId(), "variableName");
        RuntimeServiceTest.assertNotNull((Object)var);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testBasicVariableOperations.bpmn20.xml"})
    public void testChangeToSerializableUsingApi() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        RuntimeServiceTest.assertEquals((String)ValueType.STRING.getName(), (String)variable.getTypeName());
        this.runtimeService.setVariable(processInstance.getId(), "aVariable", (Object)new SerializableVariable("foo"));
        variable = (VariableInstance)query.singleResult();
        RuntimeServiceTest.assertEquals((String)ValueType.OBJECT.getName(), (String)variable.getTypeName());
    }

    @Deployment
    public void testGetVariableInstancesFromVariableScope() {
        VariableMap variables = Variables.createVariables().putValue("anIntegerVariable", (Object)1234).putValue("anObjectValue", (Object)Variables.objectValue((Object)new SimpleSerializableBean(10)).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA)).putValue("anUntypedObjectValue", (Object)new SimpleSerializableBean(30));
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testSetVariableInScope.bpmn20.xml"})
    public void testSetVariableInScopeExplicitUpdate() {
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("shouldExplicitlyUpdateVariable", true));
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        RuntimeServiceTest.assertNotNull((Object)variableInstance);
        RuntimeServiceTest.assertEquals((String)"shouldExplicitlyUpdateVariable", (String)variableInstance.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testSetVariableInScope.bpmn20.xml"})
    public void testSetVariableInScopeImplicitUpdate() {
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("shouldExplicitlyUpdateVariable", true));
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        RuntimeServiceTest.assertNotNull((Object)variableInstance);
        RuntimeServiceTest.assertEquals((String)"shouldExplicitlyUpdateVariable", (String)variableInstance.getName());
    }

    @Deployment
    public void testUpdateVariableInProcessWithoutWaitstate() {
        this.runtimeService.startProcessInstanceByKey("oneScriptTaskProcess", Collections.singletonMap("var", new SimpleSerializableBean(10)));
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        RuntimeServiceTest.assertNull((Object)processInstance);
    }

    @Deployment
    public void testSetUpdateAndDeleteComplexVariable() {
        this.runtimeService.startProcessInstanceByKey("oneUserTaskProcess", Collections.singletonMap("var", new SimpleSerializableBean(10)));
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        RuntimeServiceTest.assertNotNull((Object)processInstance);
    }

    @Deployment
    public void testRollback() {
        try {
            this.runtimeService.startProcessInstanceByKey("RollbackProcess");
            RuntimeServiceTest.fail((String)"Starting the process instance should throw an exception");
        }
        catch (Exception e) {
            RuntimeServiceTest.assertEquals((String)"Buzzz", (String)e.getMessage());
        }
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/trivial.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/rollbackAfterSubProcess.bpmn20.xml"})
    public void testRollbackAfterSubProcess() {
        try {
            this.runtimeService.startProcessInstanceByKey("RollbackAfterSubProcess");
            RuntimeServiceTest.fail((String)"Starting the process instance should throw an exception");
        }
        catch (Exception e) {
            RuntimeServiceTest.assertEquals((String)"Buzzz", (String)e.getMessage());
        }
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    public void testGetActivityInstanceForCompletedInstanceInDelegate() {
        BpmnModelInstance deletingProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().userTask().serviceTask().camundaClass(DeleteInstanceDelegate.class.getName())).userTask().endEvent().done();
        BpmnModelInstance processToDelete = Bpmn.createExecutableProcess((String)"process2").startEvent().userTask().endEvent().done();
        this.deployment(new BpmnModelInstance[]{deletingProcess, processToDelete});
        ProcessInstance instanceToDelete = this.runtimeService.startProcessInstanceByKey("process2");
        ProcessInstance deletingInstance = this.runtimeService.startProcessInstanceByKey("process1", (Map)Variables.createVariables().putValue("instanceToComplete", (Object)instanceToDelete.getId()));
        Task deleteTrigger = (Task)this.taskService.createTaskQuery().processInstanceId(deletingInstance.getId()).singleResult();
        this.taskService.complete(deleteTrigger.getId());
        boolean activityInstanceNull = (Boolean)this.runtimeService.getVariable(deletingInstance.getId(), "activityInstanceNull");
        RuntimeServiceTest.assertTrue((boolean)activityInstanceNull);
    }

    public static class DeleteInstanceDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = execution.getProcessEngineServices().getRuntimeService();
            TaskService taskService = execution.getProcessEngineServices().getTaskService();
            String instanceToDelete = (String)execution.getVariable("instanceToComplete");
            Task taskToTrigger = (Task)taskService.createTaskQuery().processInstanceId(instanceToDelete).singleResult();
            taskService.complete(taskToTrigger.getId());
            ActivityInstance activityInstance = runtimeService.getActivityInstance(instanceToDelete);
            execution.setVariable("activityInstanceNull", (Object)(activityInstance == null ? 1 : 0));
        }
    }
}

