/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.junit.Assert;

public class AsyncStartEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testAsyncStartEvent() {
        this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((String)"The user task should not have been reached yet", (Object)task);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        this.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        Assert.assertNotNull((String)"The user task should have been reached", (Object)task);
    }

    @Deployment
    public void testAsyncStartEventListeners() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Assert.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
        this.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("startEvent").done());
    }

    @Deployment
    public void testMultipleAsyncStartEvents() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        AsyncStartEventTest.assertEquals((String)"taskAfterMessageStartEvent", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testCallActivity-super.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testCallActivity-sub.bpmn20.xml"})
    public void testCallActivity() {
        this.runtimeService.startProcessInstanceByKey("super");
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        AsyncStartEventTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        AsyncStartEventTest.assertEquals((String)"theSubStart", (String)((ExecutionEntity)pi).getActivityId());
    }

    @Deployment
    public void testAsyncSubProcessStartEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNull((String)"The subprocess user task should not have been reached yet", (Object)task);
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("StartEvent_2").count());
        this.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("StartEvent_2").count());
        AsyncStartEventTest.assertNotNull((String)"The subprocess user task should have been reached", (Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncSubProcessStartEvent.bpmn"})
    public void testAsyncSubProcessStartEventActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("SubProcess_1").transition("StartEvent_2").done());
    }
}

