/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.escalation;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class EscalationEventSubprocessTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCatchEscalationEventInsideSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testCatchEscalationEventFromEmbeddedSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testCatchEscalationEventFromCallActivity.bpmn20.xml"})
    public void testCatchEscalationEventFromCallActivity() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after thrown escalation").count());
    }

    @Deployment
    public void testCatchEscalationEventFromTopLevelProcess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after thrown escalation").count());
    }

    @Deployment
    public void testCatchEscalationEventFromMultiInstanceSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)10L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventSubprocessTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testPreferEscalationEventSubprocessToBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testEscalationEventSubprocessWithEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation 1").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testEscalationEventSubprocessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testInterruptionEscalationEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testInterruptingEscalationEventSubprocessWithCallActivity.bpmn20.xml"})
    public void testInterruptingEscalationEventSubprocessWithCallActivity() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment
    public void testInterruptionEscalationEventSubprocessWithMultiInstanceSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment
    public void testReThrowEscalationEventToBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation on boundary event").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testReThrowEscalationEventToBoundaryEventWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation on boundary event").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testReThrowEscalationEventToEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation on process level").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testReThrowEscalationEventIsNotCatched() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testThrowEscalationEventToEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess1").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
        String taskId = ((Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess1").singleResult()).getId();
        this.taskService.complete(taskId);
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess2").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testPropagateOutputVariablesWhileCatchEscalationOnCallActivity.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileCatchEscalationOnCallActivity() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventSubprocessTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testPropagateOutputVariablesWhileCatchEscalationOnCallActivity.bpmn20.xml"})
    public void testPropagateOutputVariablesTwoTimes() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Task taskInSuperProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)taskInSuperProcess);
        EscalationEventSubprocessTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
        Task taskInSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "input", (Object)999);
        this.taskService.complete(taskInSubProcess.getId());
        EscalationEventSubprocessTest.assertEquals((Object)999, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testPropagateOutputVariablesWhileCatchInterruptingEscalationOnCallActivity.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileCatchInterruptingEscalationOnCallActivity() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventSubprocessTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment
    public void testRetrieveEscalationCodeVariableOnEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        EscalationEventSubprocessTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment
    public void testRetrieveEscalationCodeVariableOnEventSubprocessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        EscalationEventSubprocessTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testInterruptingRetrieveEscalationCodeInSuperProcess.bpmn20.xml"})
    public void testInterruptingRetrieveEscalationCodeInSuperProcess() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        EscalationEventSubprocessTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode.bpmn20.xml"})
    public void testInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        EscalationEventSubprocessTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingRetrieveEscalationCodeInSuperProcess.bpmn20.xml"})
    public void testNonInterruptingRetrieveEscalationCodeInSuperProcess() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        EscalationEventSubprocessTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode.bpmn20.xml"})
    public void testNonInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventSubprocessTest.assertNotNull((Object)task);
        EscalationEventSubprocessTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingEscalationTriggeredTwice.bpmn20.xml"})
    public void testNonInterruptingEscalationTriggeredTwiceWithMainTaskCompletedFirst() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task taskInMainprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("TaskInMainprocess").singleResult();
        this.taskService.complete(taskInMainprocess.getId());
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingEscalationTriggeredTwice.bpmn20.xml"})
    public void testNonInterruptingEscalationTriggeredTwiceWithSubprocessTaskCompletedFirst() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task taskInMainprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("TaskInMainprocess").singleResult();
        Task taskInSubprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").singleResult();
        this.taskService.complete(taskInSubprocess.getId());
        this.taskService.complete(taskInMainprocess.getId());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingEscalationTriggeredTwiceByIntermediateEvent.bpmn20.xml"})
    public void testNonInterruptingEscalationTriggeredTwiceByIntermediateEventWithMainTaskCompletedFirst() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task taskInMainprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("FirstTaskInMainprocess").singleResult();
        this.taskService.complete(taskInMainprocess.getId());
        EscalationEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("SecondTaskInMainprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingEscalationTriggeredTwiceByIntermediateEvent.bpmn20.xml"})
    public void testNonInterruptingEscalationTriggeredTwiceByIntermediateEventWithSubprocessTaskCompletedFirst() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task taskInMainprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("FirstTaskInMainprocess").singleResult();
        Task taskInSubprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").singleResult();
        this.taskService.complete(taskInSubprocess.getId());
        this.taskService.complete(taskInMainprocess.getId());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").count());
        EscalationEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("SecondTaskInMainprocess").count());
    }
}

