/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.sentry;

import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;

public class SentryVariableOnPartEntryCriteriaTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testSimpleVariableOnPart.cmmn"})
    public void testVariableCreate() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"aVariable");
        firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testSimpleVariableOnPart.cmmn"})
    public void testUnknownVariableCreate() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        this.caseService.setVariable(caseInstanceId, "unknown", (Object)"aVariable");
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testVariableUpdate.cmmn"})
    public void testVariableUpdate() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"aVariable");
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"bVariable");
        firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testVariableDelete.cmmn"})
    public void testVariableDelete() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        this.caseService.removeVariable(caseInstanceId, "variable_1");
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"aVariable");
        firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask.isEnabled());
        this.caseService.removeVariable(caseInstanceId, "variable_1");
        firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testDifferentVariableName.cmmn"})
    public void testDifferentVariableName() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        CaseExecution firstHumanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        CaseExecution firstHumanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask1.isEnabled());
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask2.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"aVariable");
        firstHumanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)firstHumanTask1.isEnabled());
        firstHumanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask2.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_2", (Object)"aVariable");
        firstHumanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)firstHumanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testDifferentVariableEvents.cmmn"})
    public void testDifferentVariableEventsButSameName() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        CaseExecution firstHumanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        CaseExecution firstHumanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask1.isEnabled());
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask2.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"aVariable");
        firstHumanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)firstHumanTask1.isEnabled());
        firstHumanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask2.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"bVariable");
        firstHumanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)firstHumanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testMoreVariableOnPart.cmmn"})
    public void testMultipleVariableOnParts() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"aVariable");
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"bVariable");
        firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)firstHumanTask.isEnabled());
        this.caseService.removeVariable(caseInstanceId, "variable_1");
        firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testMultipleSentryMultipleVariableOnPart.cmmn"})
    public void testMultipleSentryMultipleVariableOnParts() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        this.caseService.setVariable(caseInstanceId, "value", (Object)99);
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)secondHumanTask.isEnabled());
        this.manualStart(firstHumanTask.getId());
        this.complete(firstHumanTask.getId());
        secondHumanTask = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testOnPartIfPartAndVariableOnPart.cmmn"})
    public void testOnPartIfPartAndVariableOnPart() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("HumanTask_1").getId();
        this.complete(firstHumanTaskId);
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)secondHumanTask.isEnabled());
        this.caseService.setVariable(caseInstanceId, "value", (Object)101);
        secondHumanTask = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)secondHumanTask.isEnabled());
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"aVariable");
        secondHumanTask = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testSimpleVariableScope.cmmn"})
    public void testVariableCreateScope() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("HumanTask_1").getId();
        this.manualStart(firstHumanTaskId);
        this.caseService.setVariableLocal(firstHumanTaskId, "variable_1", (Object)"aVariable");
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)secondHumanTask.isEnabled());
        this.caseService.setVariableLocal(secondHumanTask.getId(), "variable_1", (Object)"aVariable");
        secondHumanTask = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)secondHumanTask.isEnabled());
        this.caseService.setVariableLocal(caseInstanceId, "variable_1", (Object)"aVariable");
        secondHumanTask = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testStageScope.cmmn"})
    public void testStageScope() {
        this.caseService.createCaseInstanceByKey("Case_1");
        CaseExecution caseModelHumanTask = this.queryCaseExecutionByActivityId("CaseModel_HumanTask");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)caseModelHumanTask.isEnabled());
        String stageExecutionId = this.queryCaseExecutionByActivityId("Stage_1").getId();
        this.caseService.setVariableLocal(stageExecutionId, "variable_1", (Object)"aVariable");
        CaseExecution stageHumanTask = this.queryCaseExecutionByActivityId("Stage_HumanTask");
        caseModelHumanTask = this.queryCaseExecutionByActivityId("CaseModel_HumanTask");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)caseModelHumanTask.isEnabled());
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)stageHumanTask.isEnabled());
        this.caseService.removeVariable(stageExecutionId, "variable_1");
        this.caseService.setVariable(stageHumanTask.getId(), "variable_1", (Object)"aVariable");
        stageHumanTask = this.queryCaseExecutionByActivityId("Stage_HumanTask");
        caseModelHumanTask = this.queryCaseExecutionByActivityId("CaseModel_HumanTask");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)caseModelHumanTask.isEnabled());
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)stageHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testStagesScope.cmmn"})
    public void testStagesScope() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)"aVariable");
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isEnabled());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isEnabled());
        CaseExecution humanTask3 = this.queryCaseExecutionByActivityId("HumanTask_3");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask3.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testStagesScope.cmmn"})
    public void testStageLocalScope() {
        this.caseService.createCaseInstanceByKey("Case_1").getId();
        String stageExecution1_Id = this.queryCaseExecutionByActivityId("Stage_1").getId();
        String stageExecution2_Id = this.queryCaseExecutionByActivityId("Stage_2").getId();
        this.caseService.setVariableLocal(stageExecution1_Id, "variable_1", (Object)"aVariable");
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isEnabled());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask2.isEnabled());
        CaseExecution humanTask3 = this.queryCaseExecutionByActivityId("HumanTask_3");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask3.isEnabled());
        this.caseService.setVariableLocal(stageExecution2_Id, "variable_1", (Object)"aVariable");
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isEnabled());
        humanTask3 = this.queryCaseExecutionByActivityId("HumanTask_3");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask3.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testMultipleOnPartsInStage.cmmn"})
    public void testMultipleOnPartsInStages() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        this.caseService.setVariable(caseInstanceId, "variable_1", (Object)101);
        CaseExecution humanTask3 = this.queryCaseExecutionByActivityId("HumanTask_3");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask3.isEnabled());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask2.isEnabled());
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        this.manualStart(humanTask1.getId());
        this.complete(humanTask1.getId());
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.sentryEvaluationBeforeCreation.cmmn"})
    public void testShouldnotEvaluateSentryBeforeSentryCreation() {
        this.caseService.createCaseInstanceByKey("Case_1").getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)stageExecution.isEnabled());
        CaseExecution humanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertNull((Object)humanTask);
        this.caseService.setVariableLocal(stageExecution.getId(), "variable_1", (Object)"aVariable");
        this.manualStart(stageExecution.getId());
        humanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask.isAvailable());
        this.caseService.removeVariable(stageExecution.getId(), "variable_1");
        this.caseService.setVariableLocal(stageExecution.getId(), "variable_1", (Object)"aVariable");
        humanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testSentryShouldNotBeEvaluatedAfterStageComplete.cmmn"})
    public void testEvaluationOfNotAffectedSentries() {
        this.caseService.createCaseInstanceByKey("Case_1").getId();
        String stageExecutionId = this.queryCaseExecutionByActivityId("Stage_1").getId();
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isAvailable());
        this.caseService.setVariableLocal(stageExecutionId, "value", (Object)99);
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask2.isEnabled());
        this.caseService.setVariableLocal(stageExecutionId, "value", (Object)101);
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testNotAffectedSentriesInMultipleStageScopes.cmmn"})
    public void testNotAffectedSentriesInMultipleStageScopes() {
        this.caseService.createCaseInstanceByKey("Case_1").getId();
        String stageExecution1_Id = this.queryCaseExecutionByActivityId("Stage_1").getId();
        this.caseService.setVariable(stageExecution1_Id, "value", (Object)99);
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask1.isEnabled());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask2.isEnabled());
        this.caseService.setVariable(stageExecution1_Id, "value", (Object)101);
        humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isEnabled());
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testSameVariableNameInDifferentScopes.cmmn"})
    public void testSameVariableNameInDifferentScopes() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        String stageExecution1_Id = this.queryCaseExecutionByActivityId("Stage_1").getId();
        String stageExecution2_Id = this.queryCaseExecutionByActivityId("Stage_2").getId();
        this.caseService.setVariable(caseInstanceId, "value", (Object)102);
        this.caseService.setVariableLocal(stageExecution1_Id, "value", (Object)99);
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isAvailable());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isAvailable());
        this.caseService.setVariable(caseInstanceId, "value", (Object)102);
        humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isEnabled());
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask2.isEnabled());
        this.caseService.setVariable(stageExecution2_Id, "value", (Object)103);
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testSameVariableNameInDifferentScopes.cmmn"})
    public void testNestedScopes() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        String stageExecution1_Id = this.queryCaseExecutionByActivityId("Stage_1").getId();
        this.caseService.setVariable(stageExecution1_Id, "value", (Object)99);
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isAvailable());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isAvailable());
        this.caseService.setVariable(caseInstanceId, "value", (Object)102);
        humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isEnabled());
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testSameVariableNameInDifferentScopes.cmmn"})
    public void testNestedScopesWithNullVariableValue() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        String stageExecution1_Id = this.queryCaseExecutionByActivityId("Stage_1").getId();
        this.caseService.setVariable(caseInstanceId, "value", (Object)99);
        this.caseService.setVariableLocal(stageExecution1_Id, "value", null);
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isAvailable());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isAvailable());
        this.caseService.setVariable(caseInstanceId, "value", (Object)102);
        humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isEnabled());
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testDifferentVariableNameInDifferentScope.cmmn"})
    public void testNestedScopesOfDifferentVariableNames() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("Case_1").getId();
        String stageExecution1_Id = this.queryCaseExecutionByActivityId("Stage_1").getId();
        String stageExecution2_Id = this.queryCaseExecutionByActivityId("Stage_2").getId();
        this.caseService.setVariable(caseInstanceId, "value_1", (Object)99);
        this.caseService.setVariableLocal(stageExecution1_Id, "value_1", (Object)99);
        this.caseService.setVariableLocal(stageExecution1_Id, "value_2", (Object)99);
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isAvailable());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isAvailable());
        this.caseService.setVariable(caseInstanceId, "value_1", (Object)102);
        this.caseService.setVariableLocal(stageExecution1_Id, "value_1", (Object)102);
        humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask1.isEnabled());
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertFalse((boolean)humanTask2.isEnabled());
        this.caseService.setVariable(stageExecution2_Id, "value_2", (Object)102);
        humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask2.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/variableonpart/SentryVariableOnPartEntryCriteriaTest.testSameVariableOnPartAsEntryAndExitCriteria.cmmn"})
    public void testSameVariableOnPartAsEntryAndExitCriteria() {
        this.caseService.createCaseInstanceByKey("Case_1").getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        this.caseService.setVariable(stageExecution.getId(), "value", (Object)99);
        CaseExecution humanTask = this.queryCaseExecutionByActivityId("HumanTask_1");
        SentryVariableOnPartEntryCriteriaTest.assertTrue((boolean)humanTask.isEnabled());
        this.manualStart(humanTask.getId());
        this.caseService.setVariable(stageExecution.getId(), "value", (Object)101);
        stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        SentryVariableOnPartEntryCriteriaTest.assertNull((Object)stageExecution);
    }
}

