/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;

@RequiredHistoryLevel(value="full")
public class HistoricIdentityLinkLogTestByXml
extends PluggableProcessEngineTestCase {
    private static String PROCESS_DEFINITION_KEY_CANDIDATE_USER = "oneTaskProcessForHistoricIdentityLinkWithCanidateUser";
    private static String PROCESS_DEFINITION_KEY_CANDIDATE_GROUP = "oneTaskProcessForHistoricIdentityLinkWithCanidateGroup";
    private static String PROCESS_DEFINITION_KEY_ASSIGNEE = "oneTaskProcessForHistoricIdentityLinkWithAssignee";
    private static String PROCESS_DEFINITION_KEY_CANDIDATE_STARTER_USER = "oneTaskProcessForHistoricIdentityLinkWithCanidateStarterUsers";
    private static String PROCESS_DEFINITION_KEY_CANDIDATE_STARTER_GROUP = "oneTaskProcessForHistoricIdentityLinkWithCanidateStarterGroups";
    private static final String XML_USER = "demo";
    private static final String XML_GROUP = "demoGroups";
    private static final String XML_ASSIGNEE = "assignee";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithCandidateUser.bpmn20.xml"})
    public void testShouldAddTaskCandidateforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY_CANDIDATE_USER);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTestByXml.assertEquals((long)query.userId(XML_USER).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithTaskAssignee.bpmn20.xml"})
    public void testShouldAddTaskAssigneeforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY_ASSIGNEE);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTestByXml.assertEquals((long)query.userId(XML_ASSIGNEE).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithCandidateGroups.bpmn20.xml"})
    public void testShouldAddTaskCandidateGroupforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY_CANDIDATE_GROUP);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTestByXml.assertEquals((long)query.groupId(XML_GROUP).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithCandidateStarterUsers.bpmn20.xml"})
    public void testShouldAddProcessCandidateStarterUserforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)1);
        ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY_CANDIDATE_STARTER_USER).singleResult();
        HistoricIdentityLinkLogTestByXml.assertNotNull((Object)latestProcessDef);
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
        HistoricIdentityLinkLogTestByXml.assertEquals((int)1, (int)links.size());
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTestByXml.assertEquals((long)query.userId(XML_USER).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithCandidateStarterGroups.bpmn20.xml"})
    public void testShouldAddProcessCandidateStarterGroupforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)1);
        ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY_CANDIDATE_STARTER_GROUP).singleResult();
        HistoricIdentityLinkLogTestByXml.assertNotNull((Object)latestProcessDef);
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
        HistoricIdentityLinkLogTestByXml.assertEquals((int)1, (int)links.size());
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTestByXml.assertEquals((int)historicIdentityLinks.size(), (int)1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTestByXml.assertEquals((long)query.groupId(XML_GROUP).count(), (long)1L);
    }

    protected ProcessInstance startProcessInstance(String key) {
        return this.runtimeService.startProcessInstanceByKey(key);
    }
}

