/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.FoxFailedJobParseListener;
import org.camunda.bpm.engine.impl.calendar.DurationHelper;
import org.camunda.bpm.engine.impl.cmd.DecrementJobRetriesCmd;
import org.camunda.bpm.engine.impl.cmd.JobRetryCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class FoxJobRetryCmd
extends JobRetryCmd {
    public static final List<String> SUPPORTED_TYPES = Arrays.asList("timer-transition", "timer-intermediate-transition", "timer-start-event", "timer-start-event-subprocess", "async-continuation");
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;

    public FoxJobRetryCmd(String jobId, Throwable exception) {
        super(jobId, exception);
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity job = this.getJob();
        ActivityImpl activity = this.getCurrentActivity(commandContext, job);
        if (activity == null) {
            LOG.debugFallbackToDefaultRetryStrategy();
            this.executeStandardStrategy(commandContext);
        } else {
            try {
                this.executeCustomStrategy(commandContext, job, activity);
            }
            catch (Exception e) {
                LOG.debugFallbackToDefaultRetryStrategy();
                this.executeStandardStrategy(commandContext);
            }
        }
        return null;
    }

    protected void executeStandardStrategy(CommandContext commandContext) {
        DecrementJobRetriesCmd decrementCmd = new DecrementJobRetriesCmd(this.jobId, this.exception);
        decrementCmd.execute(commandContext);
    }

    protected void executeCustomStrategy(CommandContext commandContext, JobEntity job, ActivityImpl activity) throws Exception {
        String failedJobRetryTimeCycle = this.getFailedJobRetryTimeCycle(job, activity);
        if (failedJobRetryTimeCycle == null) {
            this.executeStandardStrategy(commandContext);
        } else {
            DurationHelper durationHelper = this.getDurationHelper(failedJobRetryTimeCycle);
            this.setLockExpirationTime(job, failedJobRetryTimeCycle, durationHelper);
            if (this.isFirstJobExecution(job)) {
                this.initializeRetries(job, failedJobRetryTimeCycle, durationHelper);
            } else {
                LOG.debugDecrementingRetriesForJob(job.getId());
            }
            this.logException(job);
            this.decrementRetries(job);
            this.notifyAcquisition(commandContext);
        }
    }

    protected ActivityImpl getCurrentActivity(CommandContext commandContext, JobEntity job) {
        String type = job.getJobHandlerType();
        ActivityImpl activity = null;
        if (SUPPORTED_TYPES.contains(type)) {
            DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
            ProcessDefinitionEntity processDefinitionEntity = deploymentCache.findDeployedProcessDefinitionById(job.getProcessDefinitionId());
            activity = processDefinitionEntity.findActivity(job.getActivityId());
        }
        return activity;
    }

    protected ExecutionEntity fetchExecutionEntity(String executionId) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(executionId);
    }

    protected String getFailedJobRetryTimeCycle(JobEntity job, ActivityImpl activity) {
        Expression expression = activity.getProperties().get(FoxFailedJobParseListener.FOX_FAILED_JOB_CONFIGURATION);
        String executionId = job.getExecutionId();
        ExecutionEntity execution = null;
        if (executionId != null) {
            execution = this.fetchExecutionEntity(executionId);
        }
        Object value = null;
        try {
            value = expression.getValue(execution);
        }
        catch (Exception e) {
            LOG.exceptionWhileParsingExpression(this.jobId, e.getCause().getMessage());
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected DurationHelper getDurationHelper(String failedJobRetryTimeCycle) throws Exception {
        return new DurationHelper(failedJobRetryTimeCycle);
    }

    protected void setLockExpirationTime(JobEntity job, String failedJobRetryTimeCycle, DurationHelper durationHelper) {
        job.setLockExpirationTime(durationHelper.getDateAfter());
    }

    protected boolean isFirstJobExecution(JobEntity job) {
        return job.getExceptionByteArrayId() == null && job.getExceptionMessage() == null;
    }

    protected void initializeRetries(JobEntity job, String failedJobRetryTimeCycle, DurationHelper durationHelper) {
        LOG.debugInitiallyAppyingRetryCycleForJob(job.getId(), durationHelper.getTimes());
        job.setRetries(durationHelper.getTimes());
    }
}

