/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.ProcessApplicationUnavailableException;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.WrongDbException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.CachedDbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.DbEntityState;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class EnginePersistenceLogger
extends ProcessEngineLogger {
    protected static final String HINT_TEXT = "Hint: Set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in camunda.cfg.xml for automatic schema creation";

    protected String buildStringFromList(Collection<?> list) {
        StringBuilder message = new StringBuilder();
        message.append("[");
        message.append("\n");
        for (Object object : list) {
            message.append("  ");
            message.append(object.toString());
            message.append("\n");
        }
        message.append("]");
        return message.toString();
    }

    private String buildStringFromMap(Map<String, ?> map) {
        StringBuilder message = new StringBuilder();
        message.append("[");
        message.append("\n");
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            message.append("  ");
            message.append(entry.getKey());
            message.append(": ");
            message.append(entry.getValue().toString());
            message.append("\n");
        }
        message.append("]");
        return message.toString();
    }

    public <T extends DbEntity> ProcessEngineException entityCacheLookupException(Class<T> type, String id, Class<? extends DbEntity> entity, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("001", "Could not lookup entity of type '{}' and id '{}': found entity of type '{}'.", new Object[]{type, id, entity}), cause);
    }

    public ProcessEngineException entityCacheDuplicateEntryException(String currentState, String id, Class<? extends DbEntity> entityClass, DbEntityState foundState) {
        return new ProcessEngineException(this.exceptionMessage("002", "Cannot add {} entity with id '{}' and type '{}' into cache. An entity with the same id and type is already in state '{}'", new Object[]{currentState, id, entityClass, foundState}));
    }

    public ProcessEngineException alreadyMarkedEntityInEntityCacheException(String id, Class<? extends DbEntity> entityClass, DbEntityState state) {
        return new ProcessEngineException(this.exceptionMessage("003", "Inserting an entity with Id '{}' and type '{}' which is already marked with state '{}'", new Object[]{id, entityClass, state}));
    }

    public ProcessEngineException flushDbOperationException(List<DbOperation> operationsToFlush, DbOperation operation, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("004", "Exception while executing Database Operation '{}' with message '{}'. Flush summary: \n {}", new Object[]{operation.toString(), cause.getMessage(), this.buildStringFromList(operationsToFlush)}), cause);
    }

    public OptimisticLockingException concurrentUpdateDbEntityException(DbOperation operation) {
        return new OptimisticLockingException(this.exceptionMessage("005", "Execution of '{}' failed. Entity was updated by another transaction concurrently.", new Object[]{operation}));
    }

    public void flushedCacheState(List<CachedDbEntity> cachedEntities) {
        if (this.isDebugEnabled()) {
            this.logDebug("006", "Cache state after flush: {}", new Object[]{this.buildStringFromList(cachedEntities)});
        }
    }

    public ProcessEngineException mergeDbEntityException(DbEntity entity) {
        return new ProcessEngineException(this.exceptionMessage("007", "Cannot merge DbEntity '{}' without id", new Object[]{entity}));
    }

    public void databaseFlushSummary(Collection<DbOperation> operations) {
        if (this.isDebugEnabled()) {
            this.logDebug("008", "Flush Summary: {}", new Object[]{this.buildStringFromList(operations)});
        }
    }

    public void executeDatabaseOperation(String operationType, Object parameter) {
        if (this.isDebugEnabled()) {
            String message = parameter != null ? parameter.toString() : "null";
            if (parameter instanceof DbEntity) {
                DbEntity dbEntity = (DbEntity)parameter;
                message = ClassNameUtil.getClassNameWithoutPackage(dbEntity) + "[id=" + dbEntity.getId() + "]";
            }
            this.logDebug("009", "SQL operation: '{}'; Entity: '{}'", new Object[]{operationType, message});
        }
    }

    public void executeDatabaseBulkOperation(String operationType, String statement, Object parameter) {
        this.logDebug("010", "SQL bulk operation: '{}'; Statement: '{}'; Parameter: '{}'", new Object[]{operationType, statement, parameter});
    }

    public void fetchDatabaseTables(String source, List<String> tableNames) {
        if (this.isDebugEnabled()) {
            this.logDebug("011", "Retrieving process engine tables from: '{}'. Retrieved tables: {}", new Object[]{source, this.buildStringFromList(tableNames)});
        }
    }

    public void missingSchemaResource(String resourceName, String operation) {
        this.logDebug("012", "There is no schema resource '{}' for operation '{}'.", new Object[]{resourceName, operation});
    }

    public ProcessEngineException missingSchemaResourceException(String resourceName, String operation) {
        return new ProcessEngineException(this.exceptionMessage("013", "There is no schema resource '{}' for operation '{}'.", new Object[]{resourceName, operation}));
    }

    public ProcessEngineException missingSchemaResourceFileException(String fileName, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("014", "Cannot find schema resource file with name '{}'", new Object[]{fileName}), cause);
    }

    public void failedDatabaseOperation(String operation, String statement, Throwable cause) {
        this.logError("015", "Problem during schema operation '{}' with statement '{}'. Cause: '{}'", new Object[]{operation, statement, cause.getMessage()});
    }

    public void performingDatabaseOperation(String operation, String component, String resourceName) {
        this.logInfo("016", "Performing database operation '{}' on component '{}' with resource '{}'", new Object[]{operation, component, resourceName});
    }

    public void successfulDatabaseOperation(String operation, String component) {
        this.logDebug("Database schema operation '{}' for component '{}' was successful.", operation, new Object[]{component});
    }

    public ProcessEngineException performDatabaseOperationException(String operation, String sql, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("017", "Could not perform operation '{}' on database schema for SQL Statement: '{}'.", new Object[]{operation, sql}), cause);
    }

    public ProcessEngineException checkDatabaseTableException(Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("018", "Could not check if tables are already present using metadata.", new Object[0]), cause);
    }

    public ProcessEngineException getDatabaseTableNameException(Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("019", "Unable to fetch process engine table names.", new Object[0]), cause);
    }

    public ProcessEngineException missingRelationMappingException(String relation) {
        return new ProcessEngineException(this.exceptionMessage("020", "There is no mapping for the relation '{}' registered.", new Object[]{relation}));
    }

    public ProcessEngineException databaseHistoryLevelException(String level) {
        return new ProcessEngineException(this.exceptionMessage("021", "historyLevel '{}' is higher then 'none' and dbHistoryUsed is set to false.", new Object[]{level}));
    }

    public ProcessEngineException invokeSchemaResourceToolException(int length) {
        return new ProcessEngineException(this.exceptionMessage("022", "Schema resource tool was invoked with '{}' parameters.Schema resource tool must be invoked with exactly 2 parameters:\n - 1st parameter is the process engine configuration file,\n - 2nd parameter is the schema resource file name", new Object[]{length}));
    }

    public ProcessEngineException loadModelException(String type, String modelName, String id, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("023", "Could not load {} Model for {} definition with id '{}'.", new Object[]{type, modelName, id}), cause);
    }

    public void removeEntryFromDeploymentCacheFailure(String modelName, String id, Throwable cause) {
        this.logWarn("024", "Could not remove {} definition with id '{}' from the cache. Reason: '{}'", new Object[]{modelName, id, cause.getMessage(), cause});
    }

    public ProcessEngineException engineAuthorizationTypeException(int usedType, int global, int grant, int revoke) {
        return new ProcessEngineException(this.exceptionMessage("025", "Unrecognized authorization type '{}'. Must be one of ['{}', '{}', '{}']", new Object[]{usedType, global, grant, revoke}));
    }

    public IllegalStateException permissionStateException(String methodName, String type) {
        return new IllegalStateException(this.exceptionMessage("026", "Method '{}' cannot be used for authorization with type '{}'.", new Object[]{methodName, type}));
    }

    public ProcessEngineException notUsableGroupIdForGlobalAuthorizationException() {
        return new ProcessEngineException(this.exceptionMessage("027", "Cannot use 'groupId' for GLOBAL authorization", new Object[0]));
    }

    public ProcessEngineException illegalValueForUserIdException(String id, String expected) {
        return new ProcessEngineException(this.exceptionMessage("028", "Illegal value '{}' for userId for GLOBAL authorization. Must be '{}'", new Object[]{id, expected}));
    }

    public AuthorizationException requiredCamundaAdminException() {
        return new AuthorizationException(this.exceptionMessage("029", "Required authenticated group '{}'.", new Object[]{"camunda-admin"}));
    }

    public void createChildExecution(ExecutionEntity child, ExecutionEntity parent) {
        if (this.isDebugEnabled()) {
            this.logDebug("030", "Child execution '{}' created with parent '{}'.", new Object[]{child.toString(), parent.toString()});
        }
    }

    public void initializeExecution(ExecutionEntity entity) {
        this.logDebug("031", "Initializing execution '{}'", new Object[]{entity.toString()});
    }

    public void initializeTimerDeclaration(ExecutionEntity entity) {
        this.logDebug("032", "Initializing timer declaration '{}'", new Object[]{entity.toString()});
    }

    public ProcessEngineException requiredAsyncContinuationException(String id) {
        return new ProcessEngineException(this.exceptionMessage("033", "Asynchronous Continuation for activity with id '{}' requires a message job declaration", new Object[]{id}));
    }

    public ProcessEngineException restoreProcessInstanceException(ExecutionEntity entity) {
        return new ProcessEngineException(this.exceptionMessage("034", "Can only restore process instances. This method must be called on a process instance execution but was called on '{}'", new Object[]{entity.toString()}));
    }

    public ProcessEngineException executionNotFoundException(String id) {
        return new ProcessEngineException(this.exceptionMessage("035", "Unable to find execution for id '{}'", new Object[]{id}));
    }

    public ProcessEngineException castModelInstanceException(ModelElementInstance instance, String toElement, String type, String namespace, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("036", "Cannot cast '{}' to '{}'. Element is of type '{}' with namespace '{}'.", new Object[]{instance, toElement, type, namespace}), cause);
    }

    public BadUserRequestException requestedProcessInstanceNotFoundException(String id) {
        return new BadUserRequestException(this.exceptionMessage("037", "No process instance found for id '{}'", new Object[]{id}));
    }

    public NotValidException queryExtensionException(String extendedClassName, String extendingClassName) {
        return new NotValidException(this.exceptionMessage("038", "Unable to extend a query of class '{}' by a query of class '{}'.", new Object[]{extendedClassName, extendingClassName}));
    }

    public ProcessEngineException unsupportedResourceTypeException(String type) {
        return new ProcessEngineException(this.exceptionMessage("039", "Unsupported resource type '{}'", new Object[]{type}));
    }

    public ProcessEngineException serializerNotDefinedException(Object entity) {
        return new ProcessEngineException(this.exceptionMessage("040", "No serializer defined for variable instance '{}'", new Object[]{entity}));
    }

    public ProcessEngineException serializerOutOfContextException() {
        return new ProcessEngineException(this.exceptionMessage("041", "Cannot work with serializers outside of command context.", new Object[0]));
    }

    public ProcessEngineException taskIsAlreadyAssignedException(String usedId, String foundId) {
        return new ProcessEngineException(this.exceptionMessage("042", "Cannot assign '{}' to a task assignment that has already '{}' set.", new Object[]{usedId, foundId}));
    }

    public SuspendedEntityInteractionException suspendedEntityException(String type, String id) {
        return new SuspendedEntityInteractionException(this.exceptionMessage("043", "{} with id '{}' is suspended.", new Object[]{type, id}));
    }

    public void logUpdateUnrelatedProcessDefinitionEntity(String thisKey, String thatKey, String thisDeploymentId, String thatDeploymentId) {
        this.logDebug("044", "Cannot update entity from an unrelated process definition: this key '{}', that key '{}', this deploymentId '{}', that deploymentId '{}'", new Object[]{thisKey, thatKey, thisDeploymentId, thatDeploymentId});
    }

    public ProcessEngineException toManyProcessDefinitionsException(int count, String key, Integer version, String tenantId) {
        return new ProcessEngineException(this.exceptionMessage("045", "There are '{}' results for a process definition with key '{}', version '{}' and tenant-id '{}'.", new Object[]{count, key, version}));
    }

    public ProcessEngineException notAllowedIdException(String id) {
        return new ProcessEngineException(this.exceptionMessage("046", "Cannot set id '{}'. Only the provided id generation is allowed for properties.", new Object[]{id}));
    }

    public void countRowsPerProcessEngineTable(Map<String, Long> map) {
        if (this.isDebugEnabled()) {
            this.logDebug("047", "Number of rows per process engine table: {}", new Object[]{this.buildStringFromMap(map)});
        }
    }

    public ProcessEngineException countTableRowsException(Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("048", "Could not fetch table counts.", new Object[0]), cause);
    }

    public void selectTableCountForTable(String name) {
        this.logDebug("049", "Selecting table count for table with name '{}'", new Object[]{name});
    }

    public ProcessEngineException retrieveMetadataException(Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("050", "Could not retrieve database metadata. Reason: '{}'", new Object[]{cause.getMessage()}), cause);
    }

    public ProcessEngineException invokeTaskListenerException(Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("051", "There was an exception while invoking the TaskListener. Message: '{}'", new Object[]{cause.getMessage()}), cause);
    }

    public BadUserRequestException uninitializedFormKeyException() {
        return new BadUserRequestException(this.exceptionMessage("052", "The form key is not initialized. You must call initializeFormKeys() on the task query before you can retrieve the form key.", new Object[0]));
    }

    public ProcessEngineException disabledHistoryException() {
        return new ProcessEngineException(this.exceptionMessage("053", "History is not enabled.", new Object[0]));
    }

    public ProcessEngineException instantiateSessionException(String name, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("054", "Could not instantiate class '{}'. Message: '{}'", new Object[]{name, cause.getMessage()}), cause);
    }

    public WrongDbException wrongDbVersionException(String version, String dbVersion) {
        return new WrongDbException(this.exceptionMessage("055", "Version mismatch: Camunda library version is '{}' and db version is '{}'. Hint: Set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in camunda.cfg.xml for automatic schema creation", new Object[]{version, dbVersion}), version, dbVersion);
    }

    public ProcessEngineException missingTableException(List<String> components) {
        return new ProcessEngineException(this.exceptionMessage("056", "Tables are missing for the following components: {}", new Object[]{this.buildStringFromList(components)}));
    }

    public ProcessEngineException missingActivitiTablesException() {
        return new ProcessEngineException(this.exceptionMessage("057", "There are no Camunda tables in the database. Hint: Set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in camunda.cfg.xml for automatic schema creation", new Object[0]));
    }

    public ProcessEngineException unableToFetchDbSchemaVersion(Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("058", "Could not fetch the database schema version.", new Object[0]), cause);
    }

    public void failedTofetchVariableValue(Throwable cause) {
        this.logDebug("059", "Could not fetch value for variable.", new Object[]{cause});
    }

    public ProcessEngineException historicDecisionInputInstancesNotFetchedException() {
        return new ProcessEngineException(this.exceptionMessage("060", "The input instances for the historic decision instance are not fetched. You must call 'includeInputs()' on the query to enable fetching.", new Object[0]));
    }

    public ProcessEngineException historicDecisionOutputInstancesNotFetchedException() {
        return new ProcessEngineException(this.exceptionMessage("061", "The output instances for the historic decision instance are not fetched. You must call 'includeOutputs()' on the query to enable fetching.", new Object[0]));
    }

    public void executingDDL(List<String> logLines) {
        if (this.isDebugEnabled()) {
            this.logDebug("062", "Executing Schmema DDL {}", new Object[]{this.buildStringFromList(logLines)});
        }
    }

    public ProcessEngineException collectResultValueOfUnsupportedTypeException(TypedValue collectResultValue) {
        return new ProcessEngineException(this.exceptionMessage("063", "The collect result value '{}' of the decision table result is not of type integer, long or double.", new Object[]{collectResultValue}));
    }

    public ProcessEngineException updateTransientVariableException(String variableName) {
        return new ProcessEngineException(this.exceptionMessage("064", "The variable with name '{}' can not be updated because it is transient and read-only.", new Object[]{variableName}));
    }

    public void creatingHistoryLevelPropertyInDatabase(HistoryLevel historyLevel) {
        this.logInfo("065", "Creating historyLevel property in database for level: {}", new Object[]{historyLevel});
    }

    public void couldNotSelectHistoryLevel(String message) {
        this.logWarn("066", "Could not select history level property: {}", new Object[]{message});
    }

    public void noHistoryLevelPropertyFound() {
        this.logInfo("067", "No history level property found in database", new Object[0]);
    }

    public void noDeploymentLockPropertyFound() {
        this.logError("068", "No deployment lock property found in databse", new Object[0]);
    }

    public void debugJobExecuted(JobEntity jobEntity) {
        this.logDebug("069", "Job executed, deleting it", new Object[]{jobEntity});
    }

    public ProcessEngineException multipleTenantsForProcessDefinitionKeyException(String processDefinitionKey) {
        return new ProcessEngineException(this.exceptionMessage("070", "Cannot resolve a unique process definition for key '{}' because it exists for multiple tenants.", new Object[]{processDefinitionKey}));
    }

    public ProcessEngineException cannotDeterminePaDataformats(ProcessApplicationUnavailableException e) {
        return new ProcessEngineException(this.exceptionMessage("071", "Cannot determine process application variable serializers. Context Process Application is unavailable.", new Object[0]), e);
    }

    public ProcessEngineException cannotChangeTenantIdOfTask(String taskId, String currentTenantId, String tenantIdToSet) {
        return new ProcessEngineException(this.exceptionMessage("072", "Cannot change tenantId of Task '{}'. Current tenant id '{}', Tenant id to set '{}'", new Object[]{taskId, currentTenantId, tenantIdToSet}));
    }

    public ProcessEngineException cannotSetDifferentTenantIdOnSubtask(String parentTaskId, String tenantId, String tenantIdToSet) {
        return new ProcessEngineException(this.exceptionMessage("073", "Cannot set different tenantId on subtask than on parent Task. Parent taskId: '{}', tenantId: '{}', tenant id to set '{}'", new Object[]{parentTaskId, tenantId, tenantIdToSet}));
    }

    public ProcessEngineException multipleTenantsForDecisionDefinitionKeyException(String decisionDefinitionKey) {
        return new ProcessEngineException(this.exceptionMessage("074", "Cannot resolve a unique decision definition for key '{}' because it exists for multiple tenants.", new Object[]{decisionDefinitionKey}));
    }

    public ProcessEngineException multipleTenantsForCaseDefinitionKeyException(String caseDefinitionKey) {
        return new ProcessEngineException(this.exceptionMessage("075", "Cannot resolve a unique case definition for key '{}' because it exists for multiple tenants.", new Object[]{caseDefinitionKey}));
    }

    public ProcessEngineException deleteProcessDefinitionWithProcessInstancesException(String processDefinitionId, Long processInstanceCount) {
        return new ProcessEngineException(this.exceptionMessage("076", "Deletion of process definition without cascading failed. Process definition with id: {} can't be deleted, since there exists {} dependening process instances.", new Object[]{processDefinitionId, processInstanceCount}));
    }

    public ProcessEngineException resolveParentOfExecutionFailedException(String parentId, String executionId) {
        return new ProcessEngineException(this.exceptionMessage("077", "Cannot resolve parent with id '{}' of execution '{}', perhaps it was deleted in the meantime", new Object[]{parentId, executionId}));
    }

    public void noHistoryCleanupLockPropertyFound() {
        this.logError("078", "No history cleanup lock property found in databse", new Object[0]);
    }

    public void logUpdateUnrelatedCaseDefinitionEntity(String thisKey, String thatKey, String thisDeploymentId, String thatDeploymentId) {
        this.logDebug("079", "Cannot update entity from an unrelated case definition: this key '{}', that key '{}', this deploymentId '{}', that deploymentId '{}'", new Object[]{thisKey, thatKey, thisDeploymentId, thatDeploymentId});
    }

    public void logUpdateUnrelatedDecisionDefinitionEntity(String thisKey, String thatKey, String thisDeploymentId, String thatDeploymentId) {
        this.logDebug("080", "Cannot update entity from an unrelated decision definition: this key '{}', that key '{}', this deploymentId '{}', that deploymentId '{}'", new Object[]{thisKey, thatKey, thisDeploymentId, thatDeploymentId});
    }
}

