/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.impl.CleanableHistoricDecisionInstanceReportImpl;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.QueryPropertyImpl;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionEvaluationEvent;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;

public class HistoricDecisionInstanceManager
extends AbstractHistoricManager {
    public void deleteHistoricDecisionInstancesByDecisionDefinitionId(String decisionDefinitionId) {
        if (this.isHistoryEnabled()) {
            List<HistoricDecisionInstanceEntity> decisionInstances = this.findHistoricDecisionInstancesByDecisionDefinitionId(decisionDefinitionId);
            HashSet<String> decisionInstanceIds = new HashSet<String>();
            for (HistoricDecisionInstanceEntity decisionInstance : decisionInstances) {
                decisionInstanceIds.add(decisionInstance.getId());
                decisionInstance.delete();
            }
            if (!decisionInstanceIds.isEmpty()) {
                this.deleteHistoricDecisionInputInstancesByDecisionInstanceIds(decisionInstanceIds);
                this.deleteHistoricDecisionOutputInstancesByDecisionInstanceIds(decisionInstanceIds);
            }
        }
    }

    protected List<HistoricDecisionInstanceEntity> findHistoricDecisionInstancesByDecisionDefinitionId(String decisionDefinitionId) {
        return this.getDbEntityManager().selectList("selectHistoricDecisionInstancesByDecisionDefinitionId", this.configureParameterizedQuery(decisionDefinitionId));
    }

    protected void deleteHistoricDecisionInputInstancesByDecisionInstanceIds(Set<String> decisionInstanceIds) {
        List<HistoricDecisionInputInstanceEntity> decisionInputInstances = this.findHistoricDecisionInputInstancesByDecisionInstanceIds(decisionInstanceIds);
        for (HistoricDecisionInputInstanceEntity decisionInputInstance : decisionInputInstances) {
            decisionInputInstance.delete();
        }
    }

    protected void deleteHistoricDecisionOutputInstancesByDecisionInstanceIds(Set<String> decisionInstanceIds) {
        List<HistoricDecisionOutputInstanceEntity> decisionOutputInstances = this.findHistoricDecisionOutputInstancesByDecisionInstanceIds(decisionInstanceIds);
        for (HistoricDecisionOutputInstanceEntity decisionOutputInstance : decisionOutputInstances) {
            decisionOutputInstance.delete();
        }
    }

    public void deleteHistoricHistoricInstanceByInstanceId(String historicDecisionInstanceId) {
        boolean foundHistoricDecisionInstance;
        HistoricDecisionInstanceEntity decisionInstance = this.findHistoricDecisionInstance(historicDecisionInstanceId);
        boolean bl = foundHistoricDecisionInstance = decisionInstance != null;
        if (foundHistoricDecisionInstance) {
            decisionInstance.delete();
            this.deleteHistoricDecisionInputAndOutputInstances(historicDecisionInstanceId);
        }
    }

    public void deleteHistoricDecisionInstanceByIds(List<String> decisionInstanceIds) {
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteHistoricDecisionInputInstanceByteArraysByDecisionInstanceIds", decisionInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteHistoricDecisionOutputInstanceByteArraysByDecisionInstanceIds", decisionInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricDecisionInputInstanceEntity.class, "deleteHistoricDecisionInputInstanceByDecisionInstanceIds", decisionInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricDecisionOutputInstanceEntity.class, "deleteHistoricDecisionOutputInstanceByDecisionInstanceIds", decisionInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricDecisionInstanceEntity.class, "deleteHistoricDecisionInstanceByIds", decisionInstanceIds);
    }

    protected void deleteHistoricDecisionInputAndOutputInstances(String historicDecisionInstanceId) {
        HashSet<String> decisionInstanceIds = new HashSet<String>();
        decisionInstanceIds.add(historicDecisionInstanceId);
        this.deleteHistoricDecisionInputInstancesByDecisionInstanceIds(decisionInstanceIds);
        this.deleteHistoricDecisionOutputInstancesByDecisionInstanceIds(decisionInstanceIds);
    }

    public void insertHistoricDecisionInstances(HistoricDecisionEvaluationEvent event) {
        if (this.isHistoryEnabled()) {
            HistoricDecisionInstanceEntity rootHistoricDecisionInstance = event.getRootHistoricDecisionInstance();
            this.insertHistoricDecisionInstance(rootHistoricDecisionInstance);
            for (HistoricDecisionInstanceEntity requiredHistoricDecisionInstances : event.getRequiredHistoricDecisionInstances()) {
                requiredHistoricDecisionInstances.setRootDecisionInstanceId(rootHistoricDecisionInstance.getId());
                this.insertHistoricDecisionInstance(requiredHistoricDecisionInstances);
            }
        }
    }

    protected void insertHistoricDecisionInstance(HistoricDecisionInstanceEntity historicDecisionInstance) {
        this.getDbEntityManager().insert(historicDecisionInstance);
        this.insertHistoricDecisionInputInstances(historicDecisionInstance.getInputs(), historicDecisionInstance.getId());
        this.insertHistoricDecisionOutputInstances(historicDecisionInstance.getOutputs(), historicDecisionInstance.getId());
    }

    protected void insertHistoricDecisionInputInstances(List<HistoricDecisionInputInstance> inputs, String decisionInstanceId) {
        for (HistoricDecisionInputInstance input : inputs) {
            HistoricDecisionInputInstanceEntity inputEntity = (HistoricDecisionInputInstanceEntity)input;
            inputEntity.setDecisionInstanceId(decisionInstanceId);
            this.getDbEntityManager().insert(inputEntity);
        }
    }

    protected void insertHistoricDecisionOutputInstances(List<HistoricDecisionOutputInstance> outputs, String decisionInstanceId) {
        for (HistoricDecisionOutputInstance output : outputs) {
            HistoricDecisionOutputInstanceEntity outputEntity = (HistoricDecisionOutputInstanceEntity)output;
            outputEntity.setDecisionInstanceId(decisionInstanceId);
            this.getDbEntityManager().insert(outputEntity);
        }
    }

    public List<HistoricDecisionInstance> findHistoricDecisionInstancesByQueryCriteria(HistoricDecisionInstanceQueryImpl query, Page page) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(query);
            List decisionInstances = this.getDbEntityManager().selectList("selectHistoricDecisionInstancesByQueryCriteria", query, page);
            HashMap<String, HistoricDecisionInstanceEntity> decisionInstancesById = new HashMap<String, HistoricDecisionInstanceEntity>();
            for (HistoricDecisionInstance decisionInstance : decisionInstances) {
                decisionInstancesById.put(decisionInstance.getId(), (HistoricDecisionInstanceEntity)decisionInstance);
            }
            if (!decisionInstances.isEmpty() && query.isIncludeInput()) {
                this.appendHistoricDecisionInputInstances(decisionInstancesById, query);
            }
            if (!decisionInstances.isEmpty() && query.isIncludeOutputs()) {
                this.appendHistoricDecisionOutputInstances(decisionInstancesById, query);
            }
            return decisionInstances;
        }
        return Collections.emptyList();
    }

    public List<String> findHistoricDecisionInstanceIdsForCleanup(Integer batchSize) {
        ListQueryParameterObject parameterObject = new ListQueryParameterObject();
        parameterObject.setParameter(ClockUtil.getCurrentTime());
        parameterObject.getOrderingProperties().add(new QueryOrderingProperty(new QueryPropertyImpl("EVAL_TIME_"), Direction.ASCENDING));
        parameterObject.setFirstResult(0);
        parameterObject.setMaxResults(batchSize);
        return this.getDbEntityManager().selectList("selectHistoricDecisionInstanceIdsForCleanup", parameterObject);
    }

    protected void appendHistoricDecisionInputInstances(Map<String, HistoricDecisionInstanceEntity> decisionInstancesById, HistoricDecisionInstanceQueryImpl query) {
        List<HistoricDecisionInputInstanceEntity> decisionInputInstances = this.findHistoricDecisionInputInstancesByDecisionInstanceIds(decisionInstancesById.keySet());
        this.initializeInputInstances(decisionInstancesById.values());
        for (HistoricDecisionInputInstanceEntity decisionInputInstance : decisionInputInstances) {
            HistoricDecisionInstanceEntity historicDecisionInstance = decisionInstancesById.get(decisionInputInstance.getDecisionInstanceId());
            historicDecisionInstance.addInput(decisionInputInstance);
            if (this.isBinaryValue(decisionInputInstance) && !query.isByteArrayFetchingEnabled()) continue;
            this.fetchVariableValue(decisionInputInstance, query.isCustomObjectDeserializationEnabled());
        }
    }

    protected void initializeInputInstances(Collection<HistoricDecisionInstanceEntity> decisionInstances) {
        for (HistoricDecisionInstanceEntity decisionInstance : decisionInstances) {
            decisionInstance.setInputs(new ArrayList<HistoricDecisionInputInstance>());
        }
    }

    protected List<HistoricDecisionInputInstanceEntity> findHistoricDecisionInputInstancesByDecisionInstanceIds(Set<String> historicDecisionInstanceKeys) {
        return this.getDbEntityManager().selectList("selectHistoricDecisionInputInstancesByDecisionInstanceIds", historicDecisionInstanceKeys);
    }

    protected boolean isBinaryValue(HistoricDecisionInputInstance decisionInputInstance) {
        return AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(decisionInputInstance.getTypeName());
    }

    protected void fetchVariableValue(HistoricDecisionInputInstanceEntity decisionInputInstance, boolean isCustomObjectDeserializationEnabled) {
        try {
            decisionInputInstance.getTypedValue(isCustomObjectDeserializationEnabled);
        }
        catch (Exception t) {
            LOG.failedTofetchVariableValue(t);
        }
    }

    protected void appendHistoricDecisionOutputInstances(Map<String, HistoricDecisionInstanceEntity> decisionInstancesById, HistoricDecisionInstanceQueryImpl query) {
        List<HistoricDecisionOutputInstanceEntity> decisionOutputInstances = this.findHistoricDecisionOutputInstancesByDecisionInstanceIds(decisionInstancesById.keySet());
        this.initializeOutputInstances(decisionInstancesById.values());
        for (HistoricDecisionOutputInstanceEntity decisionOutputInstance : decisionOutputInstances) {
            HistoricDecisionInstanceEntity historicDecisionInstance = decisionInstancesById.get(decisionOutputInstance.getDecisionInstanceId());
            historicDecisionInstance.addOutput(decisionOutputInstance);
            if (this.isBinaryValue(decisionOutputInstance) && !query.isByteArrayFetchingEnabled()) continue;
            this.fetchVariableValue(decisionOutputInstance, query.isCustomObjectDeserializationEnabled());
        }
    }

    protected void initializeOutputInstances(Collection<HistoricDecisionInstanceEntity> decisionInstances) {
        for (HistoricDecisionInstanceEntity decisionInstance : decisionInstances) {
            decisionInstance.setOutputs(new ArrayList<HistoricDecisionOutputInstance>());
        }
    }

    protected List<HistoricDecisionOutputInstanceEntity> findHistoricDecisionOutputInstancesByDecisionInstanceIds(Set<String> decisionInstanceKeys) {
        return this.getDbEntityManager().selectList("selectHistoricDecisionOutputInstancesByDecisionInstanceIds", decisionInstanceKeys);
    }

    protected boolean isBinaryValue(HistoricDecisionOutputInstance decisionOutputInstance) {
        return AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(decisionOutputInstance.getTypeName());
    }

    protected void fetchVariableValue(HistoricDecisionOutputInstanceEntity decisionOutputInstance, boolean isCustomObjectDeserializationEnabled) {
        try {
            decisionOutputInstance.getTypedValue(isCustomObjectDeserializationEnabled);
        }
        catch (Exception t) {
            LOG.failedTofetchVariableValue(t);
        }
    }

    public HistoricDecisionInstanceEntity findHistoricDecisionInstance(String historicDecisionInstanceId) {
        if (this.isHistoryEnabled()) {
            return (HistoricDecisionInstanceEntity)this.getDbEntityManager().selectOne("selectHistoricDecisionInstanceByDecisionInstanceId", this.configureParameterizedQuery(historicDecisionInstanceId));
        }
        return null;
    }

    public long findHistoricDecisionInstanceCountByQueryCriteria(HistoricDecisionInstanceQueryImpl query) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(query);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricDecisionInstanceCountByQueryCriteria", query);
        }
        return 0L;
    }

    public List<HistoricDecisionInstance> findHistoricDecisionInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricDecisionInstancesByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricDecisionInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricDecisionInstanceCountByNativeQuery", parameterMap);
    }

    protected void configureQuery(HistoricDecisionInstanceQueryImpl query) {
        this.getAuthorizationManager().configureHistoricDecisionInstanceQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }

    public List<CleanableHistoricDecisionInstanceReportResult> findCleanableHistoricDecisionInstancesReportByCriteria(CleanableHistoricDecisionInstanceReportImpl query, Page page) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(query, Resources.DECISION_DEFINITION);
        this.getTenantManager().configureQuery(query);
        return this.getDbEntityManager().selectList("selectFinishedDecisionInstancesReportEntities", query, page);
    }

    public long findCleanableHistoricDecisionInstancesReportCountByCriteria(CleanableHistoricDecisionInstanceReportImpl query) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(query, Resources.DECISION_DEFINITION);
        this.getTenantManager().configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectFinishedDecisionInstancesReportEntitiesCount", query);
    }
}

