/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.util.StringUtil;

public class ExceptionUtil {
    public static String getExceptionStacktrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String getExceptionStacktrace(ByteArrayEntity byteArray) {
        String result = null;
        if (byteArray != null) {
            result = StringUtil.fromBytes(byteArray.getBytes());
        }
        return result;
    }

    public static ByteArrayEntity createJobExceptionByteArray(byte[] byteArray) {
        return ExceptionUtil.createExceptionByteArray("job.exceptionByteArray", byteArray);
    }

    public static ByteArrayEntity createExceptionByteArray(String name, byte[] byteArray) {
        ByteArrayEntity result = null;
        if (byteArray != null) {
            result = new ByteArrayEntity(name, byteArray);
            Context.getCommandContext().getDbEntityManager().insert(result);
        }
        return result;
    }

    public static boolean checkValueTooLongException(ProcessEngineException exception) {
        Throwable ex = exception;
        while (ex.getCause() != null) {
            if (!((ex = ex.getCause()) instanceof SQLException) || !ex.getMessage().contains("too long") && !ex.getMessage().contains("too large") && !ex.getMessage().contains("ORA-01461") && !ex.getMessage().contains("ORA-01401") && !ex.getMessage().contains("data would be truncated") && !ex.getMessage().contains("SQLCODE=-302, SQLSTATE=22001")) continue;
            return true;
        }
        return false;
    }
}

