/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractAsyncOperationsTest {
    public static final String ONE_TASK_PROCESS = "oneTaskProcess";
    public static final String TESTING_INSTANCE_DELETE = "testing instance delete";
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    protected void executeSeedJob(Batch batch) {
        String seedJobDefinitionId = batch.getSeedJobDefinitionId();
        Job seedJob = (Job)this.managementService.createJobQuery().jobDefinitionId(seedJobDefinitionId).singleResult();
        Assert.assertNotNull((Object)seedJob);
        this.managementService.executeJob(seedJob.getId());
    }

    protected List<Exception> executeBatchJobs(Batch batch) {
        String batchJobDefinitionId = batch.getBatchJobDefinitionId();
        List batchJobs = this.managementService.createJobQuery().jobDefinitionId(batchJobDefinitionId).list();
        Assert.assertFalse((boolean)batchJobs.isEmpty());
        ArrayList<Exception> catchedExceptions = new ArrayList<Exception>();
        for (Job batchJob : batchJobs) {
            try {
                this.managementService.executeJob(batchJob.getId());
            }
            catch (Exception e) {
                catchedExceptions.add(e);
            }
        }
        return catchedExceptions;
    }

    protected List<String> startTestProcesses(int numberOfProcesses) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < numberOfProcesses; ++i) {
            ids.add(this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS).getProcessInstanceId());
        }
        return ids;
    }

    protected void assertHistoricTaskDeletionPresent(List<String> processIds, String deleteReason, ProcessEngineTestRule testRule) {
        if (!testRule.isHistoryLevelNone()) {
            for (String processId : processIds) {
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId).singleResult();
                Assert.assertThat((Object)historicTaskInstance.getDeleteReason(), (Matcher)CoreMatchers.is((Object)deleteReason));
            }
        }
    }

    protected void assertHistoricBatchExists(ProcessEngineTestRule testRule) {
        if (testRule.isHistoryLevelFull()) {
            Assert.assertThat((Object)this.historyService.createHistoricBatchQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        }
    }
}

