/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public abstract class AuthorizationTest
extends PluggableProcessEngineTestCase {
    protected String userId = "test";
    protected String groupId = "accounting";
    protected User user;
    protected Group group;
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";

    protected void setUp() throws Exception {
        this.user = this.createUser(this.userId);
        this.group = this.createGroup(this.groupId);
        this.identityService.createMembership(this.userId, this.groupId);
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    protected <T> T runWithoutAuthorization(Callable<T> runnable) {
        boolean authorizationEnabled = this.processEngineConfiguration.isAuthorizationEnabled();
        try {
            this.disableAuthorization();
            T t = runnable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (authorizationEnabled) {
                this.enableAuthorization();
            }
        }
    }

    protected User createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.AUTHORIZATION, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        authorization = this.createGrantAuthorization((Resource)Resources.USER, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        return user;
    }

    protected Group createGroup(final String groupId) {
        return this.runWithoutAuthorization(new Callable<Group>(){

            @Override
            public Group call() throws Exception {
                Group group = AuthorizationTest.this.identityService.newGroup(groupId);
                AuthorizationTest.this.identityService.saveGroup(group);
                return group;
            }
        });
    }

    protected void createGrantAuthorization(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setUserId(userId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    protected void createGrantAuthorizationGroup(Resource resource, String resourceId, String groupId, Permission ... permissions) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setGroupId(groupId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    protected void createRevokeAuthorization(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authorization authorization = this.createRevokeAuthorization(resource, resourceId);
        authorization.setUserId(userId);
        for (Permission permission : permissions) {
            authorization.removePermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    protected Authorization createGlobalAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(0, resource, resourceId);
        return authorization;
    }

    protected Authorization createGrantAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(1, resource, resourceId);
        return authorization;
    }

    protected Authorization createRevokeAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(2, resource, resourceId);
        return authorization;
    }

    protected Authorization createAuthorization(int type, Resource resource, String resourceId) {
        Authorization authorization = this.authorizationService.createNewAuthorization(type);
        authorization.setResource(resource);
        if (resourceId != null) {
            authorization.setResourceId(resourceId);
        }
        return authorization;
    }

    protected void saveAuthorization(Authorization authorization) {
        this.authorizationService.saveAuthorization(authorization);
    }

    protected void enableAuthorization() {
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    protected void disableAuthorization() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    protected ProcessInstance startProcessInstanceByKey(String key) {
        return this.startProcessInstanceByKey(key, null);
    }

    protected ProcessInstance startProcessInstanceByKey(final String key, final Map<String, Object> variables) {
        return this.runWithoutAuthorization(new Callable<ProcessInstance>(){

            @Override
            public ProcessInstance call() throws Exception {
                return AuthorizationTest.this.runtimeService.startProcessInstanceByKey(key, variables);
            }
        });
    }

    public void executeAvailableJobs() {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.super.executeAvailableJobs();
                return null;
            }
        });
    }

    protected CaseInstance createCaseInstanceByKey(String key) {
        return this.createCaseInstanceByKey(key, null);
    }

    protected CaseInstance createCaseInstanceByKey(final String key, final Map<String, Object> variables) {
        return this.runWithoutAuthorization(new Callable<CaseInstance>(){

            @Override
            public CaseInstance call() throws Exception {
                return AuthorizationTest.this.caseService.createCaseInstanceByKey(key, variables);
            }
        });
    }

    protected void createTask(final String taskId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Task task = AuthorizationTest.this.taskService.newTask(taskId);
                AuthorizationTest.this.taskService.saveTask(task);
                return null;
            }
        });
    }

    protected void deleteTask(final String taskId, final boolean cascade) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.deleteTask(taskId, cascade);
                return null;
            }
        });
    }

    protected void addCandidateUser(final String taskId, final String user) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.addCandidateUser(taskId, user);
                return null;
            }
        });
    }

    protected void addCandidateGroup(final String taskId, final String group) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.addCandidateGroup(taskId, group);
                return null;
            }
        });
    }

    protected void setAssignee(final String taskId, final String userId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.setAssignee(taskId, userId);
                return null;
            }
        });
    }

    protected void delegateTask(final String taskId, final String userId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.delegateTask(taskId, userId);
                return null;
            }
        });
    }

    protected Task selectSingleTask() {
        return this.runWithoutAuthorization(new Callable<Task>(){

            @Override
            public Task call() throws Exception {
                return (Task)AuthorizationTest.this.taskService.createTaskQuery().singleResult();
            }
        });
    }

    protected void setTaskVariables(final String taskId, final Map<String, ? extends Object> variables) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.setVariables(taskId, variables);
                return null;
            }
        });
    }

    protected void setTaskVariablesLocal(final String taskId, final Map<String, ? extends Object> variables) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.setVariablesLocal(taskId, variables);
                return null;
            }
        });
    }

    protected void setTaskVariable(final String taskId, final String name, final Object value) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.setVariable(taskId, name, value);
                return null;
            }
        });
    }

    protected void setTaskVariableLocal(final String taskId, final String name, final Object value) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.taskService.setVariableLocal(taskId, name, value);
                return null;
            }
        });
    }

    protected void setExecutionVariable(final String executionId, final String name, final Object value) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.runtimeService.setVariable(executionId, name, value);
                return null;
            }
        });
    }

    protected void setExecutionVariableLocal(final String executionId, final String name, final Object value) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.runtimeService.setVariableLocal(executionId, name, value);
                return null;
            }
        });
    }

    protected void setCaseVariable(final String caseExecution, final String name, final Object value) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.caseService.setVariable(caseExecution, name, value);
                return null;
            }
        });
    }

    protected void setCaseVariableLocal(final String caseExecution, final String name, final Object value) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.caseService.setVariableLocal(caseExecution, name, value);
                return null;
            }
        });
    }

    protected ProcessDefinition selectProcessDefinitionByKey(final String processDefinitionKey) {
        return this.runWithoutAuthorization(new Callable<ProcessDefinition>(){

            @Override
            public ProcessDefinition call() throws Exception {
                return (ProcessDefinition)AuthorizationTest.this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
            }
        });
    }

    protected ProcessInstance selectSingleProcessInstance() {
        return this.runWithoutAuthorization(new Callable<ProcessInstance>(){

            @Override
            public ProcessInstance call() throws Exception {
                return (ProcessInstance)AuthorizationTest.this.runtimeService.createProcessInstanceQuery().singleResult();
            }
        });
    }

    protected void suspendProcessDefinitionByKey(final String processDefinitionKey) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.repositoryService.suspendProcessDefinitionByKey(processDefinitionKey);
                return null;
            }
        });
    }

    protected void suspendProcessDefinitionById(final String processDefinitionId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
                return null;
            }
        });
    }

    protected void suspendProcessInstanceById(final String processInstanceId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.runtimeService.suspendProcessInstanceById(processInstanceId);
                return null;
            }
        });
    }

    protected void suspendJobById(final String jobId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobById(jobId);
                return null;
            }
        });
    }

    protected void suspendJobByProcessInstanceId(final String processInstanceId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobByProcessInstanceId(processInstanceId);
                return null;
            }
        });
    }

    protected void suspendJobByJobDefinitionId(final String jobDefinitionId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobByJobDefinitionId(jobDefinitionId);
                return null;
            }
        });
    }

    protected void suspendJobByProcessDefinitionId(final String processDefinitionId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobByProcessDefinitionId(processDefinitionId);
                return null;
            }
        });
    }

    protected void suspendJobByProcessDefinitionKey(final String processDefinitionKey) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobByProcessDefinitionKey(processDefinitionKey);
                return null;
            }
        });
    }

    protected void suspendJobDefinitionById(final String jobDefinitionId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobDefinitionById(jobDefinitionId);
                return null;
            }
        });
    }

    protected void suspendJobDefinitionByProcessDefinitionId(final String processDefinitionId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
                return null;
            }
        });
    }

    protected void suspendJobDefinitionByProcessDefinitionKey(final String processDefinitionKey) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinitionKey);
                return null;
            }
        });
    }

    protected void suspendJobDefinitionIncludingJobsById(final String jobDefinitionId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
                return null;
            }
        });
    }

    protected void suspendJobDefinitionIncludingJobsByProcessDefinitionId(final String processDefinitionId) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
                return null;
            }
        });
    }

    protected void suspendJobDefinitionIncludingJobsByProcessDefinitionKey(final String processDefinitionKey) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AuthorizationTest.this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinitionKey, true);
                return null;
            }
        });
    }

    protected Deployment createDeployment(String name, final String ... resources) {
        return this.runWithoutAuthorization(new Callable<Deployment>(){

            @Override
            public Deployment call() throws Exception {
                DeploymentBuilder builder = AuthorizationTest.this.repositoryService.createDeployment();
                for (String resource : resources) {
                    builder.addClasspathResource(resource);
                }
                return builder.deploy();
            }
        });
    }

    protected void deleteDeployment(String deploymentId) {
        this.deleteDeployment(deploymentId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDeployment(final String deploymentId, final boolean cascade) {
        Authentication authentication = this.identityService.getCurrentAuthentication();
        try {
            this.identityService.clearAuthentication();
            this.runWithoutAuthorization(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AuthorizationTest.this.repositoryService.deleteDeployment(deploymentId, cascade);
                    return null;
                }
            });
        }
        finally {
            if (authentication != null) {
                this.identityService.setAuthentication(authentication);
            }
        }
    }

    protected ProcessInstance startProcessAndExecuteJob(final String key) {
        return this.runWithoutAuthorization(new Callable<ProcessInstance>(){

            @Override
            public ProcessInstance call() throws Exception {
                ProcessInstance processInstance = AuthorizationTest.this.startProcessInstanceByKey(key);
                AuthorizationTest.this.executeAvailableJobs(key);
                return processInstance;
            }
        });
    }

    protected void executeAvailableJobs(final String key) {
        this.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                List jobs = AuthorizationTest.this.managementService.createJobQuery().processDefinitionKey(key).withRetriesLeft().list();
                if (jobs.isEmpty()) {
                    AuthorizationTest.this.enableAuthorization();
                    return null;
                }
                for (Job job : jobs) {
                    try {
                        AuthorizationTest.this.managementService.executeJob(job.getId());
                    }
                    catch (Exception e) {}
                }
                AuthorizationTest.this.executeAvailableJobs(key);
                return null;
            }
        });
    }

    protected DecisionDefinition selectDecisionDefinitionByKey(final String decisionDefinitionKey) {
        return this.runWithoutAuthorization(new Callable<DecisionDefinition>(){

            @Override
            public DecisionDefinition call() throws Exception {
                return (DecisionDefinition)AuthorizationTest.this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(decisionDefinitionKey).singleResult();
            }
        });
    }

    protected void verifyQueryResults(Query<?, ?> query, int countExpected) {
        AuthorizationTest.assertEquals((int)countExpected, (int)query.list().size());
        AuthorizationTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            AuthorizationTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            AuthorizationTest.assertNull((Object)query.singleResult());
        }
    }

    protected void verifySingleResultFails(Query<?, ?> query) {
        try {
            query.singleResult();
            AuthorizationTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public Permission getDefaultTaskPermissionForUser() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        return processEngineConfiguration.getDefaultUserPermissionForTask();
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue(VARIABLE_NAME, (Object)VARIABLE_VALUE);
    }
}

