/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricBatchQueryAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestBaseRule authRule = new AuthorizationTestBaseRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    protected MigrationPlan migrationPlan;
    protected Batch batch1;
    protected Batch batch2;

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("user", "group");
    }

    @Before
    public void deployProcessesAndCreateMigrationPlan() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance pi = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.batch1 = this.engineRule.getRuntimeService().newMigration(this.migrationPlan).processInstanceIds(Arrays.asList(pi.getId())).executeAsync();
        this.batch2 = this.engineRule.getRuntimeService().newMigration(this.migrationPlan).processInstanceIds(Arrays.asList(pi.getId())).executeAsync();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.removeAllRunningAndHistoricBatches();
        this.engineRule.getProcessEngineConfiguration().setBatchOperationHistoryTimeToLive(null);
        this.engineRule.getProcessEngineConfiguration().setBatchOperationsForHistoryCleanup(null);
    }

    private void removeAllRunningAndHistoricBatches() {
        HistoryService historyService = this.engineRule.getHistoryService();
        ManagementService managementService = this.engineRule.getManagementService();
        for (Batch batch : managementService.createBatchQuery().list()) {
            managementService.deleteBatch(batch.getId(), true);
        }
        for (HistoricBatch historicBatch : historyService.createHistoricBatchQuery().list()) {
            historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void testQueryList() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, this.batch1.getId(), "user", new Permission[]{Permissions.READ_HISTORY});
        this.authRule.enableAuthorization("user");
        List batches = this.engineRule.getHistoryService().createHistoricBatchQuery().list();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertEquals((Object)this.batch1.getId(), (Object)((HistoricBatch)batches.get(0)).getId());
    }

    @Test
    public void testQueryCount() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, this.batch1.getId(), "user", new Permission[]{Permissions.READ_HISTORY});
        this.authRule.enableAuthorization("user");
        long count = this.engineRule.getHistoryService().createHistoricBatchQuery().count();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testQueryNoAuthorizations() {
        this.authRule.enableAuthorization("user");
        long count = this.engineRule.getHistoryService().createHistoricBatchQuery().count();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testQueryListAccessAll() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, "*", "user", new Permission[]{Permissions.READ_HISTORY});
        this.authRule.enableAuthorization("user");
        List batches = this.engineRule.getHistoryService().createHistoricBatchQuery().list();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)2L, (long)batches.size());
    }

    @Test
    public void testQueryListMultiple() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, "*", "user", new Permission[]{Permissions.READ_HISTORY});
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, this.batch1.getId(), "user", new Permission[]{Permissions.READ_HISTORY});
        this.authRule.enableAuthorization("user");
        List batches = this.engineRule.getHistoryService().createHistoricBatchQuery().list();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)2L, (long)batches.size());
    }

    @Test
    public void testHistoryCleanupReportQueryWithPermissions() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, "*", "user", new Permission[]{Permissions.READ_HISTORY});
        String migrationOperationsTTL = "P0D";
        this.prepareBatch(migrationOperationsTTL);
        this.authRule.enableAuthorization("user");
        CleanableHistoricBatchReportResult result = (CleanableHistoricBatchReportResult)this.engineRule.getHistoryService().createCleanableHistoricBatchReport().singleResult();
        this.authRule.disableAuthorization();
        Assert.assertNotNull((Object)result);
        this.checkResultNumbers(result, 1, 1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHistoryCleanupReportQueryWithoutPermission() {
        String migrationOperationsTTL = "P0D";
        this.prepareBatch(migrationOperationsTTL);
        this.thrown.expect(AuthorizationException.class);
        this.authRule.enableAuthorization("user");
        try {
            this.engineRule.getHistoryService().createCleanableHistoricBatchReport().list();
        }
        finally {
            this.authRule.disableAuthorization();
        }
    }

    private void prepareBatch(String migrationOperationsTTL) {
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instance-migration", migrationOperationsTTL);
        this.engineRule.getProcessEngineConfiguration().setBatchOperationsForHistoryCleanup(map);
        this.engineRule.getProcessEngineConfiguration().initHistoryCleanup();
        Date startDate = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-11));
        String batchId = this.createBatch();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-7));
        this.engineRule.getManagementService().deleteBatch(batchId, false);
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(true);
    }

    private void checkResultNumbers(CleanableHistoricBatchReportResult result, int expectedCleanable, int expectedFinished, Integer expectedTTL) {
        Assert.assertEquals((long)expectedCleanable, (long)result.getCleanableBatchesCount());
        Assert.assertEquals((long)expectedFinished, (long)result.getFinishedBatchesCount());
        Assert.assertEquals((Object)expectedTTL, (Object)result.getHistoryTimeToLive());
    }

    private String createBatch() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan plan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance pi = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        Batch batch = this.engineRule.getRuntimeService().newMigration(plan).processInstanceIds(Arrays.asList(pi.getId())).executeAsync();
        return batch.getId();
    }
}

