/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.api.authorization.batch.AbstractBatchAuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenarioWithCount;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SetJobRetriesBatchAuthorizationTest
extends AbstractBatchAuthorizationTest {
    protected static final String DEFINITION_XML = "org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml";
    protected static final long BATCH_OPERATIONS = 3L;
    protected static final int RETRIES = 5;
    @Rule
    public RuleChain ruleChain;
    @Parameterized.Parameter
    public AuthorizationScenarioWithCount scenario;

    public SetJobRetriesBatchAuthorizationTest() {
        this.ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    }

    protected void assertRetries(List<String> allJobIds, int i) {
        for (String id : allJobIds) {
            Assert.assertThat((Object)((Job)this.managementService.createJobQuery().jobId(id).singleResult()).getRetries(), (Matcher)Is.is((Object)i));
        }
    }

    protected List<String> getAllJobIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (Job job : this.managementService.createJobQuery().processDefinitionId(this.sourceDefinition.getId()).list()) {
            if (job.getProcessInstanceId() == null) continue;
            result.add(job.getId());
        }
        return result;
    }

    @Override
    @Before
    public void deployProcesses() {
        DeploymentWithDefinitions deploy = this.testHelper.deploy(DEFINITION_XML);
        this.sourceDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deploy.getId()).singleResult();
        this.processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(this.sourceDefinition.getId());
        this.processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceById(this.sourceDefinition.getId());
    }

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenarioWithCount.scenario().withCount(3L).withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.READ, Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.READ})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "exceptionInJobExecution", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenarioWithCount.scenario().withCount(5L).withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.ALL}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.ALL})).succeeds(), AuthorizationScenarioWithCount.scenario().withCount(5L).withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE})).succeeds());
    }

    @Test
    public void testWithTwoInvocationsJobsListBased() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.setupAndExecuteJobsListBasedTest();
        this.assertScenario();
        this.assertRetries(this.getAllJobIds(), Long.valueOf(this.getScenario().getCount()).intValue());
    }

    @Test
    public void testWithTwoInvocationsJobsQueryBased() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.setupAndExecuteJobsQueryBasedTest();
        this.assertScenario();
        this.assertRetries(this.getAllJobIds(), Long.valueOf(this.getScenario().getCount()).intValue());
    }

    @Test
    public void testJobsListBased() {
        this.setupAndExecuteJobsListBasedTest();
        this.assertScenario();
    }

    @Test
    public void testJobsListQueryBased() {
        this.setupAndExecuteJobsQueryBasedTest();
        this.assertScenario();
    }

    @Test
    public void testWithTwoInvocationsProcessListBased() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.setupAndExecuteProcessListBasedTest();
        this.assertScenario();
        this.assertRetries(this.getAllJobIds(), Long.valueOf(this.getScenario().getCount()).intValue());
    }

    @Test
    public void testWithTwoInvocationsProcessQueryBased() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.setupAndExecuteJobsQueryBasedTest();
        this.assertScenario();
        this.assertRetries(this.getAllJobIds(), Long.valueOf(this.getScenario().getCount()).intValue());
    }

    private void setupAndExecuteProcessListBasedTest() {
        List<String> processInstances = Arrays.asList(this.processInstance.getId(), this.processInstance2.getId());
        this.authRule.init(this.scenario).withUser("userId").bindResource("Process", this.sourceDefinition.getKey()).bindResource("processInstance1", this.processInstance.getId()).bindResource("processInstance2", this.processInstance2.getId()).start();
        this.batch = this.managementService.setJobRetriesAsync(processInstances, (ProcessInstanceQuery)null, 5);
        this.executeSeedAndBatchJobs();
    }

    @Test
    public void testProcessList() {
        this.setupAndExecuteProcessListBasedTest();
        this.assertScenario();
    }

    protected void setupAndExecuteJobsListBasedTest() {
        List<String> allJobIds = this.getAllJobIds();
        this.authRule.init(this.scenario).withUser("userId").bindResource("Process", this.sourceDefinition.getKey()).bindResource("processInstance1", this.processInstance.getId()).bindResource("processInstance2", this.processInstance2.getId()).start();
        this.batch = this.managementService.setJobRetriesAsync(allJobIds, 5);
        this.executeSeedAndBatchJobs();
    }

    protected void setupAndExecuteJobsQueryBasedTest() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        this.authRule.init(this.scenario).withUser("userId").bindResource("Process", this.sourceDefinition.getKey()).bindResource("processInstance1", this.processInstance.getId()).bindResource("processInstance2", this.processInstance2.getId()).start();
        this.batch = this.managementService.setJobRetriesAsync(jobQuery, 5);
        this.executeSeedAndBatchJobs();
    }

    @Override
    public AuthorizationScenarioWithCount getScenario() {
        return this.scenario;
    }

    protected void assertScenario() {
        if (this.authRule.assertScenario(this.getScenario())) {
            if (this.testHelper.isHistoryLevelFull()) {
                Assert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Is.is((Object)3L));
            }
            this.assertRetries(this.getAllJobIds(), 5);
        }
    }
}

