/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "testProcess";
    protected static final String DECISION_DEFINITION_KEY = "testDecision";

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    public void testQueryWithReadPermissionOnDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryWithReadPermissionOnAnyDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryWithMultiple() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testDeleteHistoricDecisionInstanceWithoutAuthorization() {
        this.startProcessInstanceAndEvaluateDecision();
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
            HistoricDecisionInstanceAuthorizationTest.fail((String)"expect authorization exception");
        }
        catch (AuthorizationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"The user with id 'test' does not have 'DELETE_HISTORY' permission on resource 'testDecision' of type 'DecisionDefinition'."));
        }
    }

    public void testDeleteHistoricDecisionInstanceWithDeleteHistoryPermissionOnDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        this.disableAuthorization();
        Assert.assertThat((Object)this.historyService.createHistoricDecisionInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.enableAuthorization();
    }

    public void testDeleteHistoricDecisionInstanceWithDeleteHistoryPermissionOnAnyDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        this.disableAuthorization();
        Assert.assertThat((Object)this.historyService.createHistoricDecisionInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.enableAuthorization();
    }

    public void testDeleteHistoricDecisionInstanceByInstanceIdWithoutAuthorization() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        try {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
            HistoricDecisionInstanceAuthorizationTest.fail((String)"expect authorization exception");
        }
        catch (AuthorizationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"The user with id 'test' does not have 'DELETE_HISTORY' permission on resource 'testDecision' of type 'DecisionDefinition'."));
        }
    }

    public void testDeleteHistoricDecisionInstanceByInstanceIdWithDeleteHistoryPermissionOnDecisionDefinition() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY, Permissions.READ_HISTORY});
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    public void testHistoryCleanupReportWithoutAuthorization() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        HistoricDecisionInstanceAuthorizationTest.assertEquals((int)0, (int)reportResults.size());
    }

    public void testHistoryCleanupReportWithAuthorization() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_HISTORY});
        this.createGrantAuthorizationGroup((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.groupId, new Permission[]{Permissions.READ, Permissions.READ_HISTORY});
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        HistoricDecisionInstanceAuthorizationTest.assertEquals((int)1, (int)reportResults.size());
        HistoricDecisionInstanceAuthorizationTest.assertEquals((long)10L, (long)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0)).getCleanableDecisionInstanceCount());
        HistoricDecisionInstanceAuthorizationTest.assertEquals((long)10L, (long)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0)).getFinishedDecisionInstanceCount());
    }

    public void testHistoryCleanupReportWithReadPermissionOnly() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        HistoricDecisionInstanceAuthorizationTest.assertEquals((int)0, (int)reportResults.size());
    }

    public void testHistoryCleanupReportWithReadHistoryPermissionOnly() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        HistoricDecisionInstanceAuthorizationTest.assertEquals((int)0, (int)reportResults.size());
    }

    protected void startProcessInstanceAndEvaluateDecision() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input1", null);
        this.startProcessInstanceByKey(PROCESS_KEY, variables);
    }

    protected void prepareDecisionInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        DecisionDefinition decisionDefinition = this.selectDecisionDefinitionByKey(key);
        this.disableAuthorization();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), historyTimeToLive);
        this.enableAuthorization();
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        VariableMap variables = Variables.createVariables().putValue("input1", null);
        for (int i = 0; i < instanceCount; ++i) {
            this.disableAuthorization();
            this.decisionService.evaluateDecisionByKey(key).variables((Map)variables).evaluate();
            this.enableAuthorization();
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }
}

