/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceManager;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricBatchManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricInstanceForCleanupQueryTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.migrationRule);
    private HistoryService historyService;
    private RuntimeService runtimeService;
    private ManagementService managementService;
    private CaseService caseService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.caseService = this.engineRule.getCaseService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void clearDatabase() {
        this.helper.removeAllRunningAndHistoricBatches();
        this.clearMetrics();
    }

    protected void clearMetrics() {
        Collection meters = this.processEngineConfiguration.getMetricsRegistry().getMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSortHistoricProcessInstancesForCleanup() {
        String processDefinitionKey = "oneTaskProcess";
        this.startAndDeleteProcessInstance("oneTaskProcess", -11);
        this.startAndDeleteProcessInstance("oneTaskProcess", -10);
        this.startAndDeleteProcessInstance("oneTaskProcess", -12);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoricProcessInstanceManager historicProcessInstanceManager = commandContext.getHistoricProcessInstanceManager();
                List historicProcessInstanceIds = historicProcessInstanceManager.findHistoricProcessInstanceIdsForCleanup(Integer.valueOf(7));
                Assert.assertEquals((long)3L, (long)historicProcessInstanceIds.size());
                HistoricProcessInstanceEntity historicProcessInstance1 = historicProcessInstanceManager.findHistoricProcessInstance((String)historicProcessInstanceIds.get(0));
                HistoricProcessInstanceEntity historicProcessInstance2 = historicProcessInstanceManager.findHistoricProcessInstance((String)historicProcessInstanceIds.get(1));
                HistoricProcessInstanceEntity historicProcessInstance3 = historicProcessInstanceManager.findHistoricProcessInstance((String)historicProcessInstanceIds.get(2));
                Assert.assertTrue((boolean)historicProcessInstance1.getEndTime().before(historicProcessInstance2.getEndTime()));
                Assert.assertTrue((boolean)historicProcessInstance2.getEndTime().before(historicProcessInstance3.getEndTime()));
                return null;
            }
        });
    }

    private void startAndDeleteProcessInstance(String processDefinitionKey, int daysToAdd) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysToAdd));
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        this.runtimeService.deleteProcessInstances(Arrays.asList(processInstance1.getId()), null, true, true);
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testSortHistoricDecisionInstancesForCleanup() {
        String decisionDefinitionKey1 = "decision";
        this.evaluateDecisionDefinition("decision", -11);
        this.evaluateDecisionDefinition("decision", -10);
        this.evaluateDecisionDefinition("decision", -12);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoricDecisionInstanceManager historicDecisionInstanceManager = commandContext.getHistoricDecisionInstanceManager();
                List historicDecisionInstanceIds = historicDecisionInstanceManager.findHistoricDecisionInstanceIdsForCleanup(Integer.valueOf(7));
                Assert.assertEquals((long)3L, (long)historicDecisionInstanceIds.size());
                HistoricDecisionInstanceEntity instance0 = historicDecisionInstanceManager.findHistoricDecisionInstance((String)historicDecisionInstanceIds.get(0));
                HistoricDecisionInstanceEntity instance1 = historicDecisionInstanceManager.findHistoricDecisionInstance((String)historicDecisionInstanceIds.get(1));
                HistoricDecisionInstanceEntity instance2 = historicDecisionInstanceManager.findHistoricDecisionInstance((String)historicDecisionInstanceIds.get(2));
                Assert.assertTrue((boolean)instance0.getEvaluationTime().before(instance1.getEvaluationTime()));
                Assert.assertTrue((boolean)instance1.getEvaluationTime().before(instance2.getEvaluationTime()));
                return null;
            }
        });
    }

    private void evaluateDecisionDefinition(String decisionDefinitionKey, int daysToAdd) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysToAdd));
        this.engineRule.getDecisionService().evaluateDecisionByKey(decisionDefinitionKey).variables((Map)this.getDMNVariables()).evaluate();
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithHistoryTimeToLive.cmmn"})
    public void testSortHistoricCaseInstancesForCleanup() {
        String caseDefinitionKey1 = "case";
        this.startAndCloseCaseInstance("case", -11);
        this.startAndCloseCaseInstance("case", -10);
        this.startAndCloseCaseInstance("case", -12);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoricCaseInstanceManager historicCaseInstanceManager = commandContext.getHistoricCaseInstanceManager();
                List historicCaseInstanceIds = historicCaseInstanceManager.findHistoricCaseInstanceIdsForCleanup(7);
                Assert.assertEquals((long)3L, (long)historicCaseInstanceIds.size());
                HistoricCaseInstanceEntity instance0 = historicCaseInstanceManager.findHistoricCaseInstance((String)historicCaseInstanceIds.get(0));
                HistoricCaseInstanceEntity instance1 = historicCaseInstanceManager.findHistoricCaseInstance((String)historicCaseInstanceIds.get(1));
                HistoricCaseInstanceEntity instance2 = historicCaseInstanceManager.findHistoricCaseInstance((String)historicCaseInstanceIds.get(2));
                Assert.assertTrue((boolean)instance0.getCloseTime().before(instance1.getCloseTime()));
                Assert.assertTrue((boolean)instance1.getCloseTime().before(instance2.getCloseTime()));
                return null;
            }
        });
    }

    @Test
    public void testSortHistoricBatchesForCleanup() {
        Date startDate = ClockUtil.getCurrentTime();
        int daysInThePast = -11;
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        List<Batch> list = Arrays.asList(this.helper.migrateProcessInstancesAsync(1), this.helper.migrateProcessInstancesAsync(1), this.helper.migrateProcessInstancesAsync(1));
        String batchType = list.get(0).getType();
        HashedMap batchOperationsMap = new HashedMap();
        batchOperationsMap.put(batchType, 4);
        for (Batch batch : list) {
            this.helper.executeSeedJob(batch);
            this.helper.executeJobs(batch);
            ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)(++daysInThePast)));
            this.helper.executeMonitorJob(batch);
        }
        ClockUtil.setCurrentTime((Date)new Date());
        List historicList = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)3L, (long)historicList.size());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>((Map)batchOperationsMap){
            final /* synthetic */ Map val$batchOperationsMap;
            {
                this.val$batchOperationsMap = map;
            }

            public Void execute(CommandContext commandContext) {
                HistoricBatchManager historicBatchManager = commandContext.getHistoricBatchManager();
                List ids = historicBatchManager.findHistoricBatchIdsForCleanup(Integer.valueOf(7), this.val$batchOperationsMap);
                Assert.assertEquals((long)3L, (long)ids.size());
                HistoricBatchEntity instance0 = historicBatchManager.findHistoricBatchById((String)ids.get(0));
                HistoricBatchEntity instance1 = historicBatchManager.findHistoricBatchById((String)ids.get(1));
                HistoricBatchEntity instance2 = historicBatchManager.findHistoricBatchById((String)ids.get(2));
                Assert.assertTrue((boolean)instance0.getEndTime().before(instance1.getEndTime()));
                Assert.assertTrue((boolean)instance1.getEndTime().before(instance2.getEndTime()));
                return null;
            }
        });
    }

    private void startAndCloseCaseInstance(String caseDefinitionKey, int daysToAdd) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysToAdd));
        CaseInstance caseInstance1 = this.caseService.createCaseInstanceByKey(caseDefinitionKey);
        this.caseService.terminateCaseExecution(caseInstance1.getId());
        this.caseService.closeCaseInstance(caseInstance1.getId());
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    protected VariableMap getDMNVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }
}

