/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.NativeHistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.NativeHistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.NativeHistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.NativeHistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.slf4j.Logger;

@RequiredHistoryLevel(value="audit")
public class HistoryServiceTest
extends PluggableProcessEngineTestCase {
    public static final String ONE_TASK_PROCESS = "oneTaskProcess";
    protected static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQuery() {
        HistoryServiceTest.assertTrue((this.historyService.createHistoricProcessInstanceQuery().count() == 0L ? 1 : 0) != 0);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        HistoryServiceTest.assertTrue((this.historyService.createHistoricProcessInstanceQuery().count() == 1L ? 1 : 0) != 0);
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoryServiceTest.assertEquals((int)1, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        HistoryServiceTest.assertTrue((this.historyService.createHistoricProcessInstanceQuery().count() == 1L ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQueryOrderBy() {
        HistoryServiceTest.assertTrue((this.historyService.createHistoricProcessInstanceQuery().count() == 0L ? 1 : 0) != 0);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoryServiceTest.assertEquals((int)1, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByDeleteReason().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByExecutionId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricTaskInstanceDuration().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricTaskInstanceEndTime().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessDefinitionId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessInstanceId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskAssignee().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDefinitionKey().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDescription().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskName().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskOwner().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskPriority().asc()).list();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceUserIdAndActivityId() {
        this.identityService.setAuthenticatedUserId("johndoe");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoryServiceTest.assertEquals((String)"johndoe", (String)historicProcessInstance.getStartUserId());
        HistoryServiceTest.assertEquals((String)"theStart", (String)historicProcessInstance.getStartActivityId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoryServiceTest.assertEquals((int)1, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoryServiceTest.assertEquals((String)"theEnd", (String)historicProcessInstance.getEndActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/orderProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/checkCreditProcess.bpmn20.xml"})
    public void testOrderProcessWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("orderProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task verifyCreditTask = (Task)taskQuery.singleResult();
        this.taskService.complete(verifyCreditTask.getId(), CollectionUtil.singletonMap((String)"creditApproved", (Object)true));
        Task prepareAndShipTask = (Task)taskQuery.singleResult();
        HistoryServiceTest.assertEquals((String)"Prepare and Ship", (String)prepareAndShipTask.getName());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(pi.getId()).singleResult();
        HistoryServiceTest.assertNotNull((Object)historicProcessInstance);
        HistoryServiceTest.assertTrue((boolean)historicProcessInstance.getProcessDefinitionId().contains("checkCreditProcess"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/orderProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/checkCreditProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQueryByProcessDefinitionKey() {
        String processDefinitionKey = ONE_TASK_PROCESS;
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        this.runtimeService.startProcessInstanceByKey("orderProcess");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(processDefinitionKey).singleResult();
        HistoryServiceTest.assertNotNull((Object)historicProcessInstance);
        HistoryServiceTest.assertTrue((boolean)historicProcessInstance.getProcessDefinitionId().startsWith(processDefinitionKey));
        HistoryServiceTest.assertEquals((String)"theStart", (String)historicProcessInstance.getStartActivityId());
        Task task = (Task)this.taskService.createTaskQuery().processDefinitionKey("checkCreditProcess").singleResult();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("creditApproved", true);
        this.taskService.complete(task.getId(), map);
        HistoricProcessInstance historicProcessInstanceSub = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("checkCreditProcess").singleResult();
        HistoricProcessInstance historicProcessInstanceSuper = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("orderProcess").singleResult();
        HistoryServiceTest.assertEquals((String)historicProcessInstanceSuper.getId(), (String)historicProcessInstanceSub.getSuperProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/otherOneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQueryByProcessInstanceIds() {
        HashSet<String> processInstanceIds = new HashSet<String>();
        for (int i = 0; i < 4; ++i) {
            processInstanceIds.add(this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, i + "").getId());
        }
        processInstanceIds.add(this.runtimeService.startProcessInstanceByKey("otherOneTaskProcess", "1").getId());
        this.runtimeService.startProcessInstanceByKey("otherOneTaskProcess", "2");
        HistoricProcessInstanceQuery processInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIds);
        HistoryServiceTest.assertEquals((long)5L, (long)processInstanceQuery.count());
        List processInstances = processInstanceQuery.list();
        HistoryServiceTest.assertNotNull((Object)processInstances);
        HistoryServiceTest.assertEquals((int)5, (int)processInstances.size());
        for (HistoricProcessInstance historicProcessInstance : processInstances) {
            HistoryServiceTest.assertTrue((boolean)processInstanceIds.contains(historicProcessInstance.getId()));
        }
        HistoryServiceTest.assertEquals((long)0L, (long)processInstanceQuery.processInstanceId("dummy").count());
    }

    public void testHistoricProcessInstanceQueryByProcessInstanceIdsEmpty() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet());
            HistoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("Set of process instance ids is empty", re.getMessage());
        }
    }

    public void testHistoricProcessInstanceQueryByProcessInstanceIdsNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(null);
            HistoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("Set of process instance ids is null", re.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/concurrentExecution.bpmn20.xml"})
    public void testHistoricVariableInstancesOnParallelExecution() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("rootValue", "test");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("concurrent", vars);
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        for (Task task : tasks) {
            HashMap variables = new HashMap();
            LOG.debug("setting variables on task " + task.getId() + ", execution " + task.getExecutionId());
            this.runtimeService.setVariableLocal(task.getExecutionId(), "parallelValue1", (Object)task.getName());
            this.runtimeService.setVariableLocal(task.getExecutionId(), "parallelValue2", (Object)"test");
            this.taskService.complete(task.getId(), variables);
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult()).getId());
        HistoryServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("rootValue", (Object)"test").count());
        HistoryServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("parallelValue1", (Object)"Receive Payment").count());
        HistoryServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("parallelValue1", (Object)"Ship Order").count());
        HistoryServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("parallelValue2", (Object)"test").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryStringVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).singleResult()).getId());
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("stringVar2", "ghijkl");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).singleResult()).getId());
        vars = new HashMap();
        vars.put("stringVar", "azerty");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance3.getId()).singleResult()).getId());
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("stringVar", (Object)"abcdef");
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("stringVar2", (Object)"ghijkl");
        HistoricProcessInstance resultInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("stringVar", (Object)"abcdef").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("stringVar", (Object)"abcdef").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("stringVar", (Object)"z").singleResult();
        Assert.assertNull((Object)resultInstance);
        HistoryServiceTest.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"abcdef").count());
        HistoryServiceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"z").count());
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("stringVar", (Object)"abcdeg").list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((HistoricProcessInstance)processInstances.get(0)).getId(), ((HistoricProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        HistoryServiceTest.assertTrue((boolean)ids.isEmpty());
        HistoryServiceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("stringVar", (Object)"abcdef").count());
        HistoryServiceTest.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").count());
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"abcdef").list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ids = new ArrayList<String>(Arrays.asList(((HistoricProcessInstance)processInstances.get(0)).getId(), ((HistoricProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        HistoryServiceTest.assertTrue((boolean)ids.isEmpty());
        HistoryServiceTest.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").count());
        HistoryServiceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"aa").count());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "azert%").singleResult();
        HistoryServiceTest.assertNotNull((Object)resultInstance);
        HistoryServiceTest.assertEquals((String)processInstance3.getId(), (String)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "%y").singleResult();
        HistoryServiceTest.assertNotNull((Object)resultInstance);
        HistoryServiceTest.assertEquals((String)processInstance3.getId(), (String)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "%zer%").singleResult();
        HistoryServiceTest.assertNotNull((Object)resultInstance);
        HistoryServiceTest.assertEquals((String)processInstance3.getId(), (String)resultInstance.getId());
        HistoryServiceTest.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "a%").count());
        HistoryServiceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "%x%").count());
        this.historyService.deleteHistoricProcessInstance(processInstance1.getId());
        this.historyService.deleteHistoricProcessInstance(processInstance2.getId());
        this.historyService.deleteHistoricProcessInstance(processInstance3.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDateVariable() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        Date date1 = Calendar.getInstance().getTime();
        vars.put("dateVar", date1);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).singleResult()).getId());
        Date date2 = Calendar.getInstance().getTime();
        vars = new HashMap();
        vars.put("dateVar", date1);
        vars.put("dateVar2", date2);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).singleResult()).getId());
        Calendar nextYear = Calendar.getInstance();
        nextYear.add(1, 1);
        vars = new HashMap();
        vars.put("dateVar", nextYear.getTime());
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance3.getId()).singleResult()).getId());
        Calendar nextMonth = Calendar.getInstance();
        nextMonth.add(2, 1);
        Calendar twoYearsLater = Calendar.getInstance();
        twoYearsLater.add(1, 2);
        Calendar oneYearAgo = Calendar.getInstance();
        oneYearAgo.add(1, -1);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("dateVar", (Object)date1);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("dateVar", (Object)date1).variableValueEquals("dateVar2", (Object)date2);
        HistoricProcessInstance resultInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        Date unexistingDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/01/1989 12:00:00");
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("dateVar", (Object)unexistingDate).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("dateVar", (Object)date1).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)nextYear.getTime()).count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)oneYearAgo.getTime()).count());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextYear.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((HistoricProcessInstance)processInstances.get(0)).getId(), ((HistoricProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        HistoryServiceTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("dateVar", (Object)date1).count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("dateVar", (Object)twoYearsLater.getTime()).count());
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        this.historyService.deleteHistoricProcessInstance(processInstance1.getId());
        this.historyService.deleteHistoricProcessInstance(processInstance2.getId());
        this.historyService.deleteHistoricProcessInstance(processInstance3.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testNativeHistoricProcessInstanceTest() {
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        HistoryServiceTest.assertEquals((long)1L, (long)((NativeHistoricProcessInstanceQuery)this.historyService.createNativeHistoricProcessInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).count());
        HistoryServiceTest.assertEquals((int)1, (int)((NativeHistoricProcessInstanceQuery)this.historyService.createNativeHistoricProcessInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testNativeHistoricTaskInstanceTest() {
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        HistoryServiceTest.assertEquals((long)1L, (long)((NativeHistoricTaskInstanceQuery)this.historyService.createNativeHistoricTaskInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).count());
        HistoryServiceTest.assertEquals((int)1, (int)((NativeHistoricTaskInstanceQuery)this.historyService.createNativeHistoricTaskInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).list().size());
        HistoryServiceTest.assertEquals((int)1, (int)((NativeHistoricTaskInstanceQuery)this.historyService.createNativeHistoricTaskInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).listPage(0, 1).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testNativeHistoricActivityInstanceTest() {
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        HistoryServiceTest.assertEquals((long)1L, (long)((NativeHistoricActivityInstanceQuery)this.historyService.createNativeHistoricActivityInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).count());
        HistoryServiceTest.assertEquals((int)1, (int)((NativeHistoricActivityInstanceQuery)this.historyService.createNativeHistoricActivityInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).list().size());
        HistoryServiceTest.assertEquals((int)1, (int)((NativeHistoricActivityInstanceQuery)this.historyService.createNativeHistoricActivityInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).listPage(0, 1).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testNativeHistoricVariableInstanceTest() {
        Date date = Calendar.getInstance().getTime();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("stringVar", "abcdef");
        vars.put("dateVar", date);
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        HistoryServiceTest.assertEquals((long)2L, (long)((NativeHistoricVariableInstanceQuery)this.historyService.createNativeHistoricVariableInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(HistoricVariableInstance.class))).count());
        HistoryServiceTest.assertEquals((int)1, (int)((NativeHistoricVariableInstanceQuery)this.historyService.createNativeHistoricVariableInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricVariableInstance.class))).listPage(0, 1).size());
        List variables = ((NativeHistoricVariableInstanceQuery)this.historyService.createNativeHistoricVariableInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricVariableInstance.class))).list();
        HistoryServiceTest.assertEquals((int)2, (int)variables.size());
        for (HistoricVariableInstance variable : variables) {
            HistoryServiceTest.assertTrue((boolean)vars.containsKey(variable.getName()));
            HistoryServiceTest.assertEquals(vars.get(variable.getName()), (Object)variable.getValue());
            vars.remove(variable.getName());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", "123"));
        HistoryServiceTest.assertEquals((long)4L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        HistoryServiceTest.assertEquals((long)4L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        HistoryServiceTest.assertEquals((long)4L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        HistoryServiceTest.assertEquals((long)4L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        HistoryServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        HistoryServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        HistoryServiceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        HistoryServiceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.historyService.deleteHistoricProcessInstance(processInstance.getId());
        HistoryServiceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteRunningProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        HistoryServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        try {
            this.historyService.deleteHistoricProcessInstance(processInstance.getId());
            HistoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Process instance is still running, cannot delete historic process instance", ae.getMessage());
        }
    }

    public void testDeleteProcessInstanceUnexistingId() {
        try {
            this.historyService.deleteHistoricProcessInstance("unexistingInstanceId");
            HistoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("No historic process instance found with id", ae.getMessage());
        }
    }

    public void testDeleteProcessInstanceNullId() {
        try {
            this.historyService.deleteHistoricProcessInstance(null);
            HistoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("processInstanceId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstancesWithOneUnexistingId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        try {
            this.historyService.deleteHistoricProcessInstances(Arrays.asList(processInstance.getId(), "unexistingId"));
            HistoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"No historic process instances found with ids [unexistingId]"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstances() {
        List<String> ids = this.prepareHistoricProcesses();
        this.historyService.deleteHistoricProcessInstances(ids);
        HistoryServiceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstancesWithFake() {
        List<String> ids = this.prepareHistoricProcesses();
        ids.add("aFake");
        try {
            this.historyService.deleteHistoricProcessInstances(ids);
            HistoryServiceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        HistoryServiceTest.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstancesWithNull() {
        try {
            this.historyService.deleteHistoricProcessInstances(null);
            HistoryServiceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    protected List<String> prepareHistoricProcesses() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        ArrayList<String> processInstanceIds = new ArrayList<String>(Arrays.asList(processInstance.getId(), processInstance2.getId()));
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        return processInstanceIds;
    }
}

