/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IdentityServiceTenantTest {
    protected static final String USER_ONE = "user1";
    protected static final String USER_TWO = "user2";
    protected static final String GROUP_ONE = "group1";
    protected static final String GROUP_TWO = "group2";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected IdentityService identityService;

    @Before
    public void initService() {
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void cleanUp() {
        this.identityService.deleteTenant(TENANT_ONE);
        this.identityService.deleteTenant(TENANT_TWO);
        this.identityService.deleteGroup(GROUP_ONE);
        this.identityService.deleteGroup(GROUP_TWO);
        this.identityService.deleteUser(USER_ONE);
        this.identityService.deleteUser(USER_TWO);
    }

    @Test
    public void createTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        tenant.setName("Tenant");
        this.identityService.saveTenant(tenant);
        tenant = (Tenant)this.identityService.createTenantQuery().singleResult();
        Assert.assertThat((Object)tenant, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)tenant.getId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)tenant.getName(), (Matcher)CoreMatchers.is((Object)"Tenant"));
    }

    @Test
    public void updateTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        tenant.setName("Tenant");
        this.identityService.saveTenant(tenant);
        tenant = (Tenant)this.identityService.createTenantQuery().singleResult();
        Assert.assertThat((Object)tenant, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        tenant.setName("newName");
        this.identityService.saveTenant(tenant);
        tenant = (Tenant)this.identityService.createTenantQuery().singleResult();
        Assert.assertEquals((Object)"newName", (Object)tenant.getName());
    }

    @Test
    public void deleteTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        TenantQuery query = this.identityService.createTenantQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenant("nonExisting");
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenant(TENANT_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void updateTenantOptimisticLockingException() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        Tenant tenant1 = (Tenant)this.identityService.createTenantQuery().singleResult();
        Tenant tenant2 = (Tenant)this.identityService.createTenantQuery().singleResult();
        tenant1.setName("name");
        this.identityService.saveTenant(tenant1);
        this.thrown.expect(ProcessEngineException.class);
        tenant2.setName("other name");
        this.identityService.saveTenant(tenant2);
    }

    @Test
    public void createTenantWithGenericResourceId() {
        Tenant tenant = this.identityService.newTenant("*");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("has an invalid id: id cannot be *. * is a reserved identifier.");
        this.identityService.saveTenant(tenant);
    }

    @Test
    public void createTenantMembershipUnexistingTenant() {
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("No tenant found with id 'nonExisting'.");
        this.identityService.createTenantUserMembership("nonExisting", user.getId());
    }

    @Test
    public void createTenantMembershipUnexistingUser() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("No user found with id 'nonExisting'.");
        this.identityService.createTenantUserMembership(tenant.getId(), "nonExisting");
    }

    @Test
    public void createTenantMembershipUnexistingGroup() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("No group found with id 'nonExisting'.");
        this.identityService.createTenantGroupMembership(tenant.getId(), "nonExisting");
    }

    @Test
    public void createTenantUserMembershipAlreadyExisting() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
    }

    @Test
    public void createTenantGroupMembershipAlreadyExisting() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        Group group = this.identityService.newGroup(GROUP_ONE);
        this.identityService.saveGroup(group);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        this.thrown.expect(ProcessEngineException.class);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
    }

    @Test
    public void deleteTenantUserMembership() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
        TenantQuery query = this.identityService.createTenantQuery().userMember(USER_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenantUserMembership("nonExisting", USER_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenantUserMembership(TENANT_ONE, "nonExisting");
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenantUserMembership(TENANT_ONE, USER_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteTenantGroupMembership() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        Group group = this.identityService.newGroup(GROUP_ONE);
        this.identityService.saveGroup(group);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        TenantQuery query = this.identityService.createTenantQuery().groupMember(GROUP_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenantGroupMembership("nonExisting", GROUP_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenantGroupMembership(TENANT_ONE, "nonExisting");
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteTenantMembershipsWileDeleteUser() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
        TenantQuery query = this.identityService.createTenantQuery().userMember(USER_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteUser(USER_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteTenantMembershipsWhileDeleteGroup() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        Group group = this.identityService.newGroup(GROUP_ONE);
        this.identityService.saveGroup(group);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        TenantQuery query = this.identityService.createTenantQuery().groupMember(GROUP_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteGroup(GROUP_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteTenantMembershipsOfTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        Group group = this.identityService.newGroup(GROUP_ONE);
        this.identityService.saveGroup(group);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        UserQuery userQuery = this.identityService.createUserQuery().memberOfTenant(TENANT_ONE);
        GroupQuery groupQuery = this.identityService.createGroupQuery().memberOfTenant(TENANT_ONE);
        Assert.assertThat((Object)userQuery.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)groupQuery.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteTenant(TENANT_ONE);
        Assert.assertThat((Object)userQuery.count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)groupQuery.count(), (Matcher)CoreMatchers.is((Object)0L));
    }
}

