/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Arrays;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMigrationAsyncTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProvidedProcessEngineRule defaultEngineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule defaultTestRule = new ProcessEngineTestRule(this.defaultEngineRule);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.defaultEngineRule);
    @Rule
    public RuleChain defaultRuleChin = RuleChain.outerRule((TestRule)this.defaultEngineRule).around((TestRule)this.defaultTestRule).around((TestRule)this.migrationRule);
    protected BatchMigrationHelper batchHelper = new BatchMigrationHelper(this.defaultEngineRule, this.migrationRule);

    @After
    public void removeBatches() {
        this.batchHelper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void canMigrateInstanceBetweenSameTenantCase1() {
        ProcessDefinition sourceDefinition = this.defaultTestRule.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.defaultTestRule.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.defaultEngineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.defaultEngineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        Batch batch = this.defaultEngineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.batchHelper.executeSeedJob(batch);
        this.batchHelper.executeJobs(batch);
        this.assertMigratedTo(processInstance, targetDefinition);
    }

    @Test
    public void cannotMigrateInstanceWithoutTenantIdToDifferentTenant() {
        ProcessDefinition sourceDefinition = this.defaultTestRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.defaultTestRule.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.defaultEngineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.defaultEngineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        Batch batch = this.defaultEngineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.batchHelper.executeSeedJob(batch);
        this.batchHelper.executeJobs(batch);
        Job migrationJob = this.batchHelper.getExecutionJobs(batch).get(0);
        Assert.assertThat((Object)migrationJob.getExceptionMessage(), (Matcher)CoreMatchers.containsString((String)("Cannot migrate process instance '" + processInstance.getId() + "' without tenant to a process definition with a tenant ('tenant1')")));
    }

    protected void assertMigratedTo(ProcessInstance processInstance, ProcessDefinition targetDefinition) {
        Assert.assertEquals((long)1L, (long)this.defaultEngineRule.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstance.getId()).processDefinitionId(targetDefinition.getId()).count());
    }
}

