/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyExternalTaskQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        BpmnModelInstance process = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess().startEvent().serviceTask().camundaType("external")).camundaTopic("test")).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{process});
        this.startProcessInstance(TENANT_ONE);
        this.startProcessInstance(TENANT_TWO);
    }

    public void testQueryWithoutTenantId() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{null});
            MultiTenancyExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List externalTasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)externalTasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ExternalTask)externalTasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((ExternalTask)externalTasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List externalTasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)externalTasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ExternalTask)externalTasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((ExternalTask)externalTasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    protected void startProcessInstance(String tenant) {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
    }
}

