/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricDecisionInstanceQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN});
        this.evaluateDecisionInstanceForTenant(TENANT_ONE);
        this.evaluateDecisionInstanceForTenant(TENANT_TWO);
    }

    public void testQueryWithoutTenantId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{null});
            MultiTenancyHistoricDecisionInstanceQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List historicDecisionInstances = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)historicDecisionInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List historicDecisionInstances = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)historicDecisionInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    protected void evaluateDecisionInstanceForTenant(String tenant) {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"bronze");
        this.decisionService.evaluateDecisionTableById(decisionDefinitionId, (Map)variables);
    }
}

