/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyCleanableHistoricCaseInstanceReportCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String CMMN_MODEL = "org/camunda/bpm/engine/test/repository/one.cmmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected CaseService caseService;
    protected HistoryService historyService;
    protected String caseDefinitionId;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.caseService = this.engineRule.getCaseService();
        this.historyService = this.engineRule.getHistoryService();
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.prepareCaseInstances("one", -6, 5, 10);
    }

    private void prepareCaseInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)daysInThePast));
        for (int i = 0; i < instanceCount; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey(key);
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    public void testReportNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testReportWithAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
    }

    @Test
    public void testReportDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
    }
}

