/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyCleanableHistoricDecisionInstanceReportCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String DMN_MODEL = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.prepareDecisionInstances("decision", -6, 5, 10);
    }

    @Test
    public void testReportNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testReportWithAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
    }

    @Test
    public void testReportDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
    }

    protected void prepareDecisionInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(key).list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
        for (int i = 0; i < instanceCount; ++i) {
            this.engineRule.getDecisionService().evaluateDecisionByKey(key).variables((Map)variables).evaluate();
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }
}

