/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Collection;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.dmn.instance.Rule;

public class DmnModelElementInstanceCmdTest
extends PluggableProcessEngineTestCase {
    private static final String DECISION_KEY = "one";

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.dmn"})
    public void testRepositoryService() {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_KEY).singleResult()).getId();
        DmnModelInstance modelInstance = this.repositoryService.getDmnModelInstance(decisionDefinitionId);
        DmnModelElementInstanceCmdTest.assertNotNull((Object)modelInstance);
        Collection decisions = modelInstance.getModelElementsByType(Decision.class);
        DmnModelElementInstanceCmdTest.assertEquals((int)1, (int)decisions.size());
        Collection decisionTables = modelInstance.getModelElementsByType(DecisionTable.class);
        DmnModelElementInstanceCmdTest.assertEquals((int)1, (int)decisionTables.size());
        Collection inputs = modelInstance.getModelElementsByType(Input.class);
        DmnModelElementInstanceCmdTest.assertEquals((int)1, (int)inputs.size());
        Collection outputs = modelInstance.getModelElementsByType(Output.class);
        DmnModelElementInstanceCmdTest.assertEquals((int)1, (int)outputs.size());
        Collection rules = modelInstance.getModelElementsByType(Rule.class);
        DmnModelElementInstanceCmdTest.assertEquals((int)2, (int)rules.size());
    }
}

