/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchSuspensionHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class UpdateSuspendStateUserOperationLogTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    protected BatchSuspensionHelper helper = new BatchSuspensionHelper(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.historyService = this.rule.getHistoryService();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    public void testLogCreation() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        this.helper.executeSeedJob(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)2L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)asyncEntry.getEntityType());
        Assert.assertEquals((Object)"SuspendJob", (Object)asyncEntry.getOperationType());
        Assert.assertNull((Object)asyncEntry.getProcessInstanceId());
        Assert.assertNull((Object)asyncEntry.getOrgValue());
        Assert.assertEquals((Object)"true", (Object)asyncEntry.getNewValue());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)numInstancesEntry.getEntityType());
        Assert.assertEquals((Object)"SuspendJob", (Object)numInstancesEntry.getOperationType());
        Assert.assertNull((Object)numInstancesEntry.getProcessInstanceId());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)numInstancesEntry.getOrgValue());
        Assert.assertEquals((Object)"2", (Object)numInstancesEntry.getNewValue());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)numInstancesEntry.getOperationId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    public void testNoCreationOnSyncBatchJobExecution() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspendAsync();
        this.helper.executeSeedJob(suspendprocess);
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        this.helper.executeJobs(suspendprocess);
        this.rule.getIdentityService().clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.rule.getHistoryService().createUserOperationLogQuery().count());
    }

    protected Map<String, UserOperationLogEntry> asMap(List<UserOperationLogEntry> logEntries) {
        HashMap<String, UserOperationLogEntry> map = new HashMap<String, UserOperationLogEntry>();
        for (UserOperationLogEntry entry : logEntries) {
            UserOperationLogEntry previousValue = map.put(entry.getProperty(), entry);
            if (previousValue == null) continue;
            Assert.fail((String)"expected only entry for every property");
        }
        return map;
    }
}

