/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.async.FailingDelegate;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import org.camunda.bpm.model.bpmn.builder.MessageEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.junit.Assert;

public class FoxJobRetryCmdTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void testFailedServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        this.assertJobRetriesForActivity(pi, "failingServiceTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedUserTask.bpmn20.xml"})
    public void testFailedUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedUserTask");
        this.assertJobRetriesForActivity(pi, "failingUserTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedBusinessRuleTask.bpmn20.xml"})
    public void testFailedBusinessRuleTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedBusinessRuleTask");
        this.assertJobRetriesForActivity(pi, "failingBusinessRuleTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedCallActivity.bpmn20.xml"})
    public void testFailedCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedCallActivity");
        this.assertJobRetriesForActivity(pi, "failingCallActivity");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedScriptTask.bpmn20.xml"})
    public void testFailedScriptTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedScriptTask");
        this.assertJobRetriesForActivity(pi, "failingScriptTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedSendTask.bpmn20.xml"})
    public void testFailedSendTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedSendTask");
        this.assertJobRetriesForActivity(pi, "failingSendTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedSubProcess.bpmn20.xml"})
    public void testFailedSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedSubProcess");
        this.assertJobRetriesForActivity(pi, "failingSubProcess");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedTask.bpmn20.xml"})
    public void testFailedTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        this.assertJobRetriesForActivity(pi, "failingTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedTransaction.bpmn20.xml"})
    public void testFailedTransaction() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        this.assertJobRetriesForActivity(pi, "failingTransaction");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedReceiveTask.bpmn20.xml"})
    public void testFailedReceiveTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedReceiveTask");
        this.assertJobRetriesForActivity(pi, "failingReceiveTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedBoundaryTimerEvent.bpmn20.xml"})
    public void testFailedBoundaryTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedBoundaryTimerEvent");
        this.assertJobRetriesForActivity(pi, "userTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedIntermediateCatchingTimerEvent.bpmn20.xml"})
    public void testFailedIntermediateCatchingTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedIntermediateCatchingTimerEvent");
        this.assertJobRetriesForActivity(pi, "failingTimerEvent");
    }

    @Deployment
    public void testFailingMultiInstanceBody() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failingMultiInstance");
        this.assertJobRetriesForActivity(pi, "task#multiInstanceBody");
    }

    @Deployment
    public void testFailingMultiInstanceInnerActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failingMultiInstance");
        this.assertJobRetriesForActivity(pi, "task");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testBrokenFoxJobRetryValue.bpmn20.xml"})
    public void testBrokenFoxJobRetryValue() {
        Job job = (Job)this.managementService.createJobQuery().list().get(0);
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(0, job.getId());
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedStartTimerEvent.bpmn20.xml"})
    public void testFailedTimerStartEvent() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)this.managementService.createJobQuery().list().get(0);
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        String jobId = job.getId();
        this.waitForExecutedJobWithRetriesLeft(4, jobId);
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3, jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(2, jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(1, jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(0, jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().jobId(jobId).withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedIntermediateThrowingSignalEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.failingSignalStart.bpmn20.xml"})
    public void FAILING_testFailedIntermediateThrowingSignalEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedIntermediateThrowingSignalEvent");
        this.assertJobRetriesForActivity(pi, "failingSignalEvent");
    }

    @Deployment
    public void testRetryOnTimerStartEventInEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
            FoxJobRetryCmdTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
    }

    public void testRetryOnServiceTaskLikeMessageThrowEvent() {
        BpmnModelInstance bpmnModelInstance = ((MessageEventDefinitionBuilder)((IntermediateThrowEventBuilder)((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateThrowEvent().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R10/PT5S")).messageEventDefinition("messageDefinition").message("message")).messageEventDefinitionDone().endEvent().done();
        MessageEventDefinition messageDefinition = (MessageEventDefinition)bpmnModelInstance.getModelElementById("messageDefinition");
        messageDefinition.setCamundaClass(FailingDelegate.class.getName());
        this.deployment(new BpmnModelInstance[]{bpmnModelInstance});
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)9L, (long)job.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void FAILING_testFailedRetryWithTimeShift() throws ParseException {
        Date tenMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:50:00 CEST");
        Date fiveMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:55:00 CEST");
        Date twoMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:58:00 CEST");
        ClockUtil.setCurrentTime((Date)tenMinutesBeforeTimeShift);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        List<JobEntity> acquirableJobs = this.findAndLockAcquirableJobs();
        FoxJobRetryCmdTest.assertEquals((int)1, (int)acquirableJobs.size());
        this.waitForExecutedJobWithRetriesLeft(4);
        JobEntity job = (JobEntity)this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertTrue((boolean)tenMinutesBeforeTimeShift.before(job.getLockExpirationTime()));
        FoxJobRetryCmdTest.assertEquals((Object)fiveMinutesBeforeTimeShift, (Object)job.getLockExpirationTime());
        FoxJobRetryCmdTest.assertTrue((boolean)twoMinutesBeforeTimeShift.after(job.getLockExpirationTime()));
        acquirableJobs = this.findAndLockAcquirableJobs();
        FoxJobRetryCmdTest.assertEquals((int)0, (int)acquirableJobs.size());
        ClockUtil.setCurrentTime((Date)twoMinutesBeforeTimeShift);
        acquirableJobs = this.findAndLockAcquirableJobs();
        FoxJobRetryCmdTest.assertEquals((int)1, (int)acquirableJobs.size());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = (JobEntity)this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertTrue((boolean)twoMinutesBeforeTimeShift.before(job.getLockExpirationTime()));
        acquirableJobs = this.findAndLockAcquirableJobs();
        FoxJobRetryCmdTest.assertEquals((String)"Job shouldn't be acquirable", (int)0, (int)acquirableJobs.size());
        ClockUtil.reset();
    }

    public void testFailedJobRetryTimeCycleWithExpression() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("${var}")).endEvent().done();
        this.deployment(new BpmnModelInstance[]{bpmnModelInstance});
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("var", (Object)"R10/PT5M"));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)9L, (long)job.getRetries());
    }

    public void testFailedJobRetryTimeCycleWithUndefinedVar() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("${var}")).endEvent().done();
        this.deployment(new BpmnModelInstance[]{bpmnModelInstance});
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)2L, (long)job.getRetries());
    }

    public void testFailedJobRetryTimeCycleWithChangingExpression() throws ParseException {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("${var}")).endEvent().done();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date startDate = simpleDateFormat.parse("2017-01-01T09:55:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.deployment(new BpmnModelInstance[]{bpmnModelInstance});
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("var", (Object)"R10/PT5M"));
        startDate = simpleDateFormat.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)9L, (long)job.getRetries());
        startDate = simpleDateFormat.parse("2017-01-01T10:05:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.setVariable(pi.getProcessInstanceId(), "var", (Object)"R10/PT10M");
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        Date expectedDate = simpleDateFormat.parse("2017-01-01T10:15:00");
        Date lockExpirationTime = ((JobEntity)this.managementService.createJobQuery().singleResult()).getLockExpirationTime();
        FoxJobRetryCmdTest.assertEquals((Object)expectedDate, (Object)lockExpirationTime);
    }

    public void testRetryOnTimerStartEventWithExpression() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaFailedJobRetryTimeCycle("${var}")).timerWithDuration("PT5M")).serviceTask().camundaClass("bar")).endEvent().done();
        this.deployment(new BpmnModelInstance[]{bpmnModelInstance});
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)2L, (long)job.getRetries());
    }

    protected void assertJobRetriesForActivity(ProcessInstance pi, String activityId) {
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId(), activityId);
        FoxJobRetryCmdTest.assertNotNull((Object)execution);
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)activityId, (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)activityId, (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)activityId, (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)activityId, (String)execution.getActivityId());
    }

    protected void waitForExecutedJobWithRetriesLeft(int retriesLeft, String jobId) {
        JobQuery jobQuery = this.managementService.createJobQuery();
        if (jobId != null) {
            jobQuery.jobId(jobId);
        }
        Job job = (Job)jobQuery.singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        job = (Job)jobQuery.singleResult();
        if (job.getRetries() != retriesLeft) {
            this.waitForExecutedJobWithRetriesLeft(retriesLeft, jobId);
        }
    }

    protected void waitForExecutedJobWithRetriesLeft(int retriesLeft) {
        this.waitForExecutedJobWithRetriesLeft(retriesLeft, null);
    }

    protected ExecutionEntity refreshExecutionEntity(String executionId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionId).singleResult();
    }

    protected ExecutionEntity fetchExecutionEntity(String processInstanceId, String activityId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).activityId(activityId).singleResult();
    }

    protected Job refreshJob(String jobId) {
        return (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
    }

    protected Job fetchJob(String processInstanceId) {
        return (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected void stillOneJobWithExceptionAndRetriesLeft(String jobId) {
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().jobId(jobId).withException().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().jobId(jobId).withRetriesLeft().count());
    }

    protected void stillOneJobWithExceptionAndRetriesLeft() {
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    protected Date createDateFromLocalString(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss z", Locale.US);
        return dateFormat.parse(dateString);
    }

    protected List<JobEntity> findAndLockAcquirableJobs() {
        return (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<List<JobEntity>>(){

            public List<JobEntity> execute(CommandContext commandContext) {
                List jobs = commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
                for (JobEntity job : jobs) {
                    job.setLockOwner("test");
                }
                return jobs;
            }
        });
    }
}

