/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.helper.CmmnProperties;
import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.DecisionTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.DmnDecisionTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.DecisionTaskItemHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.SentryHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.impl.core.model.BaseCallableElement;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ConstantValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.dmn.result.DecisionResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.ResultListDecisionTableResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.SingleResultDecisionResultMapper;
import org.camunda.bpm.engine.impl.el.ElValueProvider;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.Body;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.instance.DecisionRefExpression;
import org.camunda.bpm.model.cmmn.instance.DecisionTask;
import org.camunda.bpm.model.cmmn.instance.DefaultControl;
import org.camunda.bpm.model.cmmn.instance.Documentation;
import org.camunda.bpm.model.cmmn.instance.EntryCriterion;
import org.camunda.bpm.model.cmmn.instance.ExitCriterion;
import org.camunda.bpm.model.cmmn.instance.IfPart;
import org.camunda.bpm.model.cmmn.instance.ItemControl;
import org.camunda.bpm.model.cmmn.instance.ManualActivationRule;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemControl;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.RepetitionRule;
import org.camunda.bpm.model.cmmn.instance.RequiredRule;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DecisionTaskPlanItemHandlerTest
extends CmmnElementHandlerTest {
    protected DecisionTask decisionTask;
    protected PlanItem planItem;
    protected DecisionTaskItemHandler handler = new DecisionTaskItemHandler();

    @Before
    public void setUp() {
        this.decisionTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aHumanTask", DecisionTask.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aHumanTask", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.decisionTask);
    }

    @Test
    public void testActivityName() {
        String name = "A DecisionTask";
        this.decisionTask.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testPlanItemActivityName() {
        String humanTaskName = "A DecisionTask";
        this.decisionTask.setName(humanTaskName);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNotEquals((Object)humanTaskName, (Object)activity.getName());
        Assert.assertEquals((Object)planItemName, (Object)activity.getName());
    }

    @Test
    public void testActivityType() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        String activityType = (String)activity.getProperty("activityType");
        Assert.assertEquals((Object)"decisionTask", (Object)activityType);
    }

    @Test
    public void testDescriptionProperty() {
        String description = "This is a decisionTask";
        this.decisionTask.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)activity.getProperty("description"));
    }

    @Test
    public void testPlanItemDescriptionProperty() {
        String description = "This is a planItem";
        this.planItem.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)activity.getProperty("description"));
    }

    @Test
    public void testDocumentation() {
        String description = "This is a documenation";
        Documentation documentation = this.createElement((CmmnModelElementInstance)this.decisionTask, Documentation.class);
        documentation.setTextContent(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)activity.getProperty("description"));
    }

    @Test
    public void testPlanItemDocumentation() {
        String description = "This is a planItem";
        Documentation documentationElem = this.createElement((CmmnModelElementInstance)this.planItem, Documentation.class);
        documentationElem.setTextContent(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)activity.getProperty("description"));
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof DmnDecisionTaskActivityBehavior));
    }

    public void testIsBlockingEqualsTrueProperty() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertTrue((boolean)isBlocking);
    }

    @Test
    public void testIsBlockingEqualsFalseProperty() {
        this.decisionTask.setIsBlocking(false);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertFalse((boolean)isBlocking);
    }

    @Test
    public void testExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        ExitCriterion criterion = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion.setSentry(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
    }

    @Test
    public void testMultipleExitCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        Body body1 = this.createElement((CmmnModelElementInstance)conditionExpression1, null, Body.class);
        body1.setTextContent("${test}");
        ExitCriterion criterion1 = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion1.setSentry(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        Body body2 = this.createElement((CmmnModelElementInstance)conditionExpression2, null, Body.class);
        body2.setTextContent("${test}");
        ExitCriterion criterion2 = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion2.setSentry(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getExitCriteria().size());
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        EntryCriterion criterion = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion.setSentry(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testMultipleEntryCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        Body body1 = this.createElement((CmmnModelElementInstance)conditionExpression1, null, Body.class);
        body1.setTextContent("${test}");
        EntryCriterion criterion1 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion1.setSentry(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        Body body2 = this.createElement((CmmnModelElementInstance)conditionExpression2, null, Body.class);
        body2.setTextContent("${test}");
        EntryCriterion criterion2 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion2.setSentry(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getEntryCriteria().size());
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteriaAndExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        EntryCriterion criterion1 = this.createElement((CmmnModelElementInstance)this.planItem, EntryCriterion.class);
        criterion1.setSentry(sentry);
        ExitCriterion criterion2 = this.createElement((CmmnModelElementInstance)this.planItem, ExitCriterion.class);
        criterion2.setSentry(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testManualActivationRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)itemControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testManualActivationRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.decisionTask, "ItemControl_1", DefaultControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)defaultControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)itemControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.decisionTask, "ItemControl_1", DefaultControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)defaultControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRepetitionRuleStandardEvents() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)itemControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List events = newActivity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertTrue((boolean)events.contains("complete"));
        Assert.assertTrue((boolean)events.contains("terminate"));
    }

    @Test
    public void testRepetitionRuleStandardEventsByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.decisionTask, "DefaultControl_1", DefaultControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)defaultControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List events = newActivity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertTrue((boolean)events.contains("complete"));
        Assert.assertTrue((boolean)events.contains("terminate"));
    }

    @Test
    public void testRepetitionRuleCustomStandardEvents() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)itemControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        repetitionRule.setCamundaRepeatOnStandardEvent("disable");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List events = newActivity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((boolean)events.contains("disable"));
    }

    @Test
    public void testRepetitionRuleCustomStandardEventsByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.decisionTask, "DefaultControl_1", DefaultControl.class);
        RepetitionRule repetitionRule = this.createElement((CmmnModelElementInstance)defaultControl, "RepititionRule_1", RepetitionRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)repetitionRule, "Expression_1", ConditionExpression.class);
        expression.setText("${true}");
        repetitionRule.setCamundaRepeatOnStandardEvent("disable");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        List events = newActivity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((boolean)events.contains("disable"));
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testCallableElement() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        Assert.assertNotNull((Object)behavior.getCallableElement());
    }

    @Test
    public void testConstantDecisionRef() {
        String decisionRef = "aDecisionToCall";
        this.decisionTask.setDecision(decisionRef);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        BaseCallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider decisionRefValueProvider = callableElement.getDefinitionKeyValueProvider();
        Assert.assertNotNull((Object)decisionRefValueProvider);
        Assert.assertTrue((boolean)(decisionRefValueProvider instanceof ConstantValueProvider));
        ConstantValueProvider valueProvider = (ConstantValueProvider)decisionRefValueProvider;
        Assert.assertEquals((Object)decisionRef, (Object)valueProvider.getValue(null));
    }

    @Test
    public void testExpressionDecisionRef() {
        String decisionRef = "${aDecisionToCall}";
        this.decisionTask.setDecision(decisionRef);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        BaseCallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider caseRefValueProvider = callableElement.getDefinitionKeyValueProvider();
        Assert.assertNotNull((Object)caseRefValueProvider);
        Assert.assertTrue((boolean)(caseRefValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)caseRefValueProvider;
        Assert.assertEquals((Object)decisionRef, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testConstantDecisionRefExpression() {
        String decision = "aDecisionToCall";
        DecisionRefExpression decisionRefExpression = this.createElement((CmmnModelElementInstance)this.decisionTask, DecisionRefExpression.class);
        decisionRefExpression.setText(decision);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        BaseCallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider decisionRefValueProvider = callableElement.getDefinitionKeyValueProvider();
        Assert.assertNotNull((Object)decisionRefValueProvider);
        Assert.assertTrue((boolean)(decisionRefValueProvider instanceof ConstantValueProvider));
        ConstantValueProvider valueProvider = (ConstantValueProvider)decisionRefValueProvider;
        Assert.assertEquals((Object)decision, (Object)valueProvider.getValue(null));
    }

    @Test
    public void testExpressionDecisionRefExpression() {
        String decision = "${aDecisionToCall}";
        DecisionRefExpression decisionRefExpression = this.createElement((CmmnModelElementInstance)this.decisionTask, DecisionRefExpression.class);
        decisionRefExpression.setText(decision);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        BaseCallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider caseRefValueProvider = callableElement.getDefinitionKeyValueProvider();
        Assert.assertNotNull((Object)caseRefValueProvider);
        Assert.assertTrue((boolean)(caseRefValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)caseRefValueProvider;
        Assert.assertEquals((Object)decision, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testBinding() {
        BaseCallableElement.CallableElementBinding caseBinding = BaseCallableElement.CallableElementBinding.LATEST;
        this.decisionTask.setCamundaDecisionBinding(caseBinding.getValue());
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        BaseCallableElement callableElement = behavior.getCallableElement();
        BaseCallableElement.CallableElementBinding binding = callableElement.getBinding();
        Assert.assertNotNull((Object)binding);
        Assert.assertEquals((Object)caseBinding, (Object)binding);
    }

    @Test
    public void testVersionConstant() {
        String caseVersion = "2";
        this.decisionTask.setCamundaDecisionVersion(caseVersion);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        BaseCallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider caseVersionValueProvider = callableElement.getVersionValueProvider();
        Assert.assertNotNull((Object)caseVersionValueProvider);
        Assert.assertTrue((boolean)(caseVersionValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)caseVersion, (Object)caseVersionValueProvider.getValue(null));
    }

    @Test
    public void testVersionExpression() {
        String caseVersion = "${aVersion}";
        this.decisionTask.setCamundaDecisionVersion(caseVersion);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        BaseCallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider caseVersionValueProvider = callableElement.getVersionValueProvider();
        Assert.assertNotNull((Object)caseVersionValueProvider);
        Assert.assertTrue((boolean)(caseVersionValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)caseVersionValueProvider;
        Assert.assertEquals((Object)caseVersion, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testResultVariable() {
        this.decisionTask.setCamundaResultVariable("aResultVariable");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DecisionTaskActivityBehavior behavior = (DecisionTaskActivityBehavior)activity.getActivityBehavior();
        Assert.assertEquals((Object)"aResultVariable", (Object)behavior.getResultVariable());
    }

    @Test
    public void testDefaultMapDecisionResult() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DmnDecisionTaskActivityBehavior behavior = (DmnDecisionTaskActivityBehavior)activity.getActivityBehavior();
        DecisionResultMapper mapper = behavior.getDecisionTableResultMapper();
        Assert.assertTrue((boolean)(mapper instanceof ResultListDecisionTableResultMapper));
    }

    @Test
    public void testMapDecisionResult() {
        this.decisionTask.setCamundaMapDecisionResult("singleResult");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        DmnDecisionTaskActivityBehavior behavior = (DmnDecisionTaskActivityBehavior)activity.getActivityBehavior();
        DecisionResultMapper mapper = behavior.getDecisionTableResultMapper();
        Assert.assertTrue((boolean)(mapper instanceof SingleResultDecisionResultMapper));
    }
}

