/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import java.util.List;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.SentryHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.TaskItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnIfPartDeclaration;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnOnPartDeclaration;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnVariableOnPartDeclaration;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformException;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.PlanItemTransition;
import org.camunda.bpm.model.cmmn.VariableTransition;
import org.camunda.bpm.model.cmmn.instance.Body;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.instance.ExtensionElements;
import org.camunda.bpm.model.cmmn.instance.IfPart;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.PlanItemOnPart;
import org.camunda.bpm.model.cmmn.instance.PlanItemTransitionStandardEvent;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.camunda.bpm.model.cmmn.instance.Task;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaVariableOnPart;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaVariableTransitionEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SentryHandlerTest
extends CmmnElementHandlerTest {
    protected Sentry sentry;
    protected PlanItemOnPart onPart;
    protected CamundaVariableOnPart variableOnPart;
    protected Task task;
    protected PlanItem planItem;
    protected ExtensionElements extensionElements;
    protected TaskItemHandler taskItemHandler = new TaskItemHandler();
    protected SentryHandler sentryHandler = new SentryHandler();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        this.task = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aTask", Task.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aTask", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.task);
        this.sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aSentry", Sentry.class);
        this.onPart = this.createElement((CmmnModelElementInstance)this.sentry, "anOnPart", PlanItemOnPart.class);
        this.onPart.setSource(this.planItem);
        this.createElement((CmmnModelElementInstance)this.onPart, null, PlanItemTransitionStandardEvent.class);
        this.onPart.setStandardEvent(PlanItemTransition.complete);
    }

    @Test
    public void testSentry() {
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        Assert.assertEquals((Object)this.sentry.getId(), (Object)sentryDeclaration.getId());
        Assert.assertNull((Object)sentryDeclaration.getIfPart());
        Assert.assertTrue((boolean)sentryDeclaration.getOnParts().isEmpty());
    }

    @Test
    public void testSentryWithIfPart() {
        IfPart ifPart = this.createElement((CmmnModelElementInstance)this.sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        String expression = "${test}";
        body.setTextContent(expression);
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        CmmnIfPartDeclaration ifPartDeclaration = sentryDeclaration.getIfPart();
        Assert.assertNotNull((Object)ifPartDeclaration);
        Expression condition = ifPartDeclaration.getCondition();
        Assert.assertNotNull((Object)condition);
        Assert.assertEquals((Object)expression, (Object)condition.getExpressionText());
        Assert.assertTrue((boolean)sentryDeclaration.getOnParts().isEmpty());
    }

    @Test
    public void testSentryWithIfPartWithMultipleCondition() {
        IfPart ifPart = this.createElement((CmmnModelElementInstance)this.sentry, "abc", IfPart.class);
        ConditionExpression firstConditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "con_1", ConditionExpression.class);
        Body firstBody = this.createElement((CmmnModelElementInstance)firstConditionExpression, null, Body.class);
        String firstExpression = "${firstExpression}";
        firstBody.setTextContent(firstExpression);
        ConditionExpression secondConditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "con_2", ConditionExpression.class);
        Body secondBody = this.createElement((CmmnModelElementInstance)secondConditionExpression, null, Body.class);
        String secondExpression = "${secondExpression}";
        secondBody.setTextContent(secondExpression);
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        CmmnIfPartDeclaration ifPartDeclaration = sentryDeclaration.getIfPart();
        Assert.assertNotNull((Object)ifPartDeclaration);
        Expression condition = ifPartDeclaration.getCondition();
        Assert.assertNotNull((Object)condition);
        Assert.assertEquals((Object)firstExpression, (Object)condition.getExpressionText());
        Assert.assertTrue((boolean)sentryDeclaration.getOnParts().isEmpty());
    }

    @Test
    public void testSentryWithOnPart() {
        CmmnActivity casePlanModelActivity = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(casePlanModelActivity);
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        CmmnActivity source = this.taskItemHandler.handleElement((CmmnElement)this.planItem, this.context);
        this.sentryHandler.initializeOnParts(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        List onParts = sentryDeclaration.getOnParts();
        Assert.assertNotNull((Object)onParts);
        Assert.assertFalse((boolean)onParts.isEmpty());
        Assert.assertEquals((long)1L, (long)onParts.size());
        List onPartsAssociatedWithSource = sentryDeclaration.getOnParts(source.getId());
        Assert.assertNotNull((Object)onPartsAssociatedWithSource);
        Assert.assertFalse((boolean)onPartsAssociatedWithSource.isEmpty());
        Assert.assertEquals((long)1L, (long)onParts.size());
        CmmnOnPartDeclaration onPartDeclaration = (CmmnOnPartDeclaration)onPartsAssociatedWithSource.get(0);
        Assert.assertNotNull((Object)onPartDeclaration);
        Assert.assertEquals((Object)source, (Object)onPartDeclaration.getSource());
        Assert.assertEquals((Object)this.onPart.getSource().getId(), (Object)onPartDeclaration.getSource().getId());
        Assert.assertEquals((Object)this.onPart.getStandardEvent().name(), (Object)onPartDeclaration.getStandardEvent());
        Assert.assertNull((Object)onPartDeclaration.getSentry());
        Assert.assertNull((Object)sentryDeclaration.getIfPart());
    }

    @Test
    public void testSentryWithOnPartReferencesSentry() {
        Sentry exitSentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "anotherSentry", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)exitSentry, "IfPart_1", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "con_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        this.onPart.setSentry(exitSentry);
        CmmnActivity casePlanModelActivity = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(casePlanModelActivity);
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        CmmnSentryDeclaration exitSentryDeclaration = this.sentryHandler.handleElement(exitSentry, this.context);
        CmmnActivity source = this.taskItemHandler.handleElement((CmmnElement)this.planItem, this.context);
        this.sentryHandler.initializeOnParts(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        List onParts = sentryDeclaration.getOnParts();
        Assert.assertNotNull((Object)onParts);
        Assert.assertFalse((boolean)onParts.isEmpty());
        Assert.assertEquals((long)1L, (long)onParts.size());
        List onPartsAssociatedWithSource = sentryDeclaration.getOnParts(source.getId());
        Assert.assertNotNull((Object)onPartsAssociatedWithSource);
        Assert.assertFalse((boolean)onPartsAssociatedWithSource.isEmpty());
        Assert.assertEquals((long)1L, (long)onParts.size());
        CmmnOnPartDeclaration onPartDeclaration = (CmmnOnPartDeclaration)onPartsAssociatedWithSource.get(0);
        Assert.assertNotNull((Object)onPartDeclaration);
        Assert.assertEquals((Object)source, (Object)onPartDeclaration.getSource());
        Assert.assertEquals((Object)this.onPart.getSource().getId(), (Object)onPartDeclaration.getSource().getId());
        Assert.assertEquals((Object)this.onPart.getStandardEvent().name(), (Object)onPartDeclaration.getStandardEvent());
        Assert.assertNotNull((Object)onPartDeclaration.getSentry());
        Assert.assertEquals((Object)exitSentryDeclaration, (Object)onPartDeclaration.getSentry());
        Assert.assertNull((Object)sentryDeclaration.getIfPart());
    }

    @Test
    public void sentryTransformWithVariableOnPart() {
        ExtensionElements extensionElements = this.createElement((CmmnModelElementInstance)this.sentry, "extensionElements", ExtensionElements.class);
        CamundaVariableOnPart variableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        this.createElement((CmmnModelElementInstance)variableOnPart, null, CamundaVariableTransitionEvent.class);
        variableOnPart.setVariableEvent(VariableTransition.create);
        variableOnPart.setVariableName("aVariable");
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        List variableOnParts = sentryDeclaration.getVariableOnParts();
        Assert.assertNotNull((Object)variableOnParts);
        Assert.assertFalse((boolean)variableOnParts.isEmpty());
        Assert.assertEquals((long)1L, (long)variableOnParts.size());
        CmmnVariableOnPartDeclaration transformedVariableOnPart = (CmmnVariableOnPartDeclaration)variableOnParts.get(0);
        Assert.assertEquals((Object)"aVariable", (Object)transformedVariableOnPart.getVariableName());
        Assert.assertEquals((Object)VariableTransition.create.name(), (Object)transformedVariableOnPart.getVariableEvent());
    }

    @Test
    public void sentryTransformWithMultipleVariableOnPart() {
        ExtensionElements extensionElements = this.createElement((CmmnModelElementInstance)this.sentry, "extensionElements", ExtensionElements.class);
        CamundaVariableOnPart variableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        this.createElement((CmmnModelElementInstance)variableOnPart, null, CamundaVariableTransitionEvent.class);
        variableOnPart.setVariableEvent(VariableTransition.create);
        variableOnPart.setVariableName("aVariable");
        CamundaVariableOnPart additionalVariableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        this.createElement((CmmnModelElementInstance)additionalVariableOnPart, null, CamundaVariableTransitionEvent.class);
        additionalVariableOnPart.setVariableEvent(VariableTransition.update);
        additionalVariableOnPart.setVariableName("bVariable");
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        List variableOnParts = sentryDeclaration.getVariableOnParts();
        Assert.assertNotNull((Object)variableOnParts);
        Assert.assertFalse((boolean)variableOnParts.isEmpty());
        Assert.assertEquals((long)2L, (long)variableOnParts.size());
    }

    @Test
    public void sentryTransformWithSameVariableOnPartTwice() {
        ExtensionElements extensionElements = this.createElement((CmmnModelElementInstance)this.sentry, "extensionElements", ExtensionElements.class);
        CamundaVariableOnPart variableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        this.createElement((CmmnModelElementInstance)variableOnPart, null, CamundaVariableTransitionEvent.class);
        variableOnPart.setVariableEvent(VariableTransition.create);
        variableOnPart.setVariableName("aVariable");
        CamundaVariableOnPart additionalVariableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        this.createElement((CmmnModelElementInstance)additionalVariableOnPart, null, CamundaVariableTransitionEvent.class);
        additionalVariableOnPart.setVariableEvent(VariableTransition.create);
        additionalVariableOnPart.setVariableName("aVariable");
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        List variableOnParts = sentryDeclaration.getVariableOnParts();
        Assert.assertNotNull((Object)variableOnParts);
        Assert.assertFalse((boolean)variableOnParts.isEmpty());
        Assert.assertEquals((long)1L, (long)variableOnParts.size());
    }

    @Test
    public void sentryTransformShouldFailWithMissingVariableEvent() {
        ExtensionElements extensionElements = this.createElement((CmmnModelElementInstance)this.sentry, "extensionElements", ExtensionElements.class);
        CamundaVariableOnPart variableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        variableOnPart.setVariableName("aVariable");
        this.thrown.expect(CmmnTransformException.class);
        this.thrown.expectMessage("The variableOnPart of the sentry with id 'aSentry' must have one valid variable event.");
        this.sentryHandler.handleElement(this.sentry, this.context);
    }

    @Test
    public void sentryTransformShouldFailWithInvalidVariableEvent() {
        ExtensionElements extensionElements = this.createElement((CmmnModelElementInstance)this.sentry, "extensionElements", ExtensionElements.class);
        CamundaVariableOnPart variableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        CamundaVariableTransitionEvent transitionEvent = this.createElement((CmmnModelElementInstance)variableOnPart, null, CamundaVariableTransitionEvent.class);
        transitionEvent.setTextContent("invalid");
        variableOnPart.setVariableName("aVariable");
        this.thrown.expect(CmmnTransformException.class);
        this.thrown.expectMessage("The variableOnPart of the sentry with id 'aSentry' must have one valid variable event.");
        this.sentryHandler.handleElement(this.sentry, this.context);
    }

    @Test
    public void sentryTransformWithMultipleVariableEvent() {
        ExtensionElements extensionElements = this.createElement((CmmnModelElementInstance)this.sentry, "extensionElements", ExtensionElements.class);
        CamundaVariableOnPart variableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        CamundaVariableTransitionEvent transitionEvent = this.createElement((CmmnModelElementInstance)variableOnPart, null, CamundaVariableTransitionEvent.class);
        transitionEvent.setTextContent("create");
        CamundaVariableTransitionEvent additionalTransitionEvent = this.createElement((CmmnModelElementInstance)variableOnPart, null, CamundaVariableTransitionEvent.class);
        additionalTransitionEvent.setTextContent("delete");
        variableOnPart.setVariableName("aVariable");
        CmmnSentryDeclaration sentryDeclaration = this.sentryHandler.handleElement(this.sentry, this.context);
        Assert.assertNotNull((Object)sentryDeclaration);
        List variableOnParts = sentryDeclaration.getVariableOnParts();
        Assert.assertNotNull((Object)variableOnParts);
        Assert.assertFalse((boolean)variableOnParts.isEmpty());
        Assert.assertEquals((long)1L, (long)variableOnParts.size());
        CmmnVariableOnPartDeclaration transformedVariableOnPart = (CmmnVariableOnPartDeclaration)variableOnParts.get(0);
        Assert.assertEquals((Object)"aVariable", (Object)transformedVariableOnPart.getVariableName());
        Assert.assertEquals((Object)VariableTransition.create.name(), (Object)transformedVariableOnPart.getVariableEvent());
    }

    @Test
    public void sentryTransformShouldFailWithMissingVariableName() {
        ExtensionElements extensionElements = this.createElement((CmmnModelElementInstance)this.sentry, "extensionElements", ExtensionElements.class);
        CamundaVariableOnPart variableOnPart = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaVariableOnPart.class);
        this.createElement((CmmnModelElementInstance)variableOnPart, null, CamundaVariableTransitionEvent.class);
        variableOnPart.setVariableEvent(VariableTransition.create);
        this.thrown.expect(CmmnTransformException.class);
        this.thrown.expectMessage("The variableOnPart of the sentry with id 'aSentry' must have variable name.");
        this.sentryHandler.handleElement(this.sentry, this.context);
    }
}

