/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.camunda.bpm.engine.impl.HistoryLevelSetupCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.util.DatabaseHelper;

public class ConcurrentHistoryLevelTest
extends ConcurrencyTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestHelper.deleteHistoryLevel((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    protected void runTest() throws Throwable {
        Integer transactionIsolationLevel = DatabaseHelper.getTransactionIsolationLevel(this.processEngineConfiguration);
        String databaseType = DatabaseHelper.getDatabaseType(this.processEngineConfiguration);
        if (!("h2".equals(databaseType) || "mariadb".equals(databaseType) || transactionIsolationLevel != null && !transactionIsolationLevel.equals(2))) {
            super.runTest();
        }
    }

    public void test() throws InterruptedException {
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableUpdateHistoryLevelCommand());
        thread1.waitForSync();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableUpdateHistoryLevelCommand());
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
        ConcurrentHistoryLevelTest.assertNull((Object)thread1.exception);
        ConcurrentHistoryLevelTest.assertNull((Object)thread2.exception);
        HistoryLevel historyLevel = this.processEngineConfiguration.getHistoryLevel();
        ConcurrentHistoryLevelTest.assertEquals((String)"full", (String)historyLevel.getName());
    }

    protected static class ControllableUpdateHistoryLevelCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected ControllableUpdateHistoryLevelCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new HistoryLevelSetupCommand().execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

