/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchModificationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class CleanableHistoricBatchReportTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper migrationHelper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    protected BatchModificationHelper modificationHelper = new BatchModificationHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
    }

    @After
    public void cleanUp() {
        this.migrationHelper.removeAllRunningAndHistoricBatches();
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive(null);
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(null);
    }

    @Test
    public void testMixedConfiguration() {
        int i;
        HashMap<String, String> map = new HashMap<String, String>();
        int modOperationsTTL = 20;
        map.put("instance-modification", "P20D");
        int defaultTTL = 5;
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(map);
        this.processEngineConfiguration.initHistoryCleanup();
        Date startDate = ClockUtil.getCurrentTime();
        int daysInThePast = -11;
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        Batch modificationBatch = this.createModificationBatch();
        ArrayList<String> batchIds = new ArrayList<String>();
        batchIds.add(modificationBatch.getId());
        int migrationCountBatch = 10;
        ArrayList<String> batchIds1 = new ArrayList<String>();
        batchIds1.addAll(this.createMigrationBatchList(migrationCountBatch));
        int cancelationCountBatch = 20;
        ArrayList<String> batchIds2 = new ArrayList<String>();
        batchIds2.addAll(this.createCancelationBatchList(cancelationCountBatch));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-8));
        for (String batchId : batchIds) {
            this.managementService.deleteBatch(batchId, false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-2));
        for (i = 0; i < 4; ++i) {
            this.managementService.deleteBatch((String)batchIds1.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-7));
        for (i = 6; i < batchIds1.size(); ++i) {
            this.managementService.deleteBatch((String)batchIds1.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-10));
        for (i = 0; i < 7; ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-5));
        for (i = 7; i < 11; ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-1));
        for (i = 13; i < batchIds2.size(); ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)new Date());
        List historicList = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)31L, (long)historicList.size());
        List list = this.historyService.createCleanableHistoricBatchReport().list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (CleanableHistoricBatchReportResult result : list) {
            if (result.getBatchType().equals("instance-migration")) {
                this.checkResultNumbers(result, 4, 8, defaultTTL);
                continue;
            }
            if (result.getBatchType().equals("instance-modification")) {
                this.checkResultNumbers(result, 0, 1, modOperationsTTL);
                continue;
            }
            if (!result.getBatchType().equals("instance-deletion")) continue;
            this.checkResultNumbers(result, 11, 18, defaultTTL);
        }
    }

    @Test
    public void testNoDefaultConfiguration() {
        int i;
        HashMap<String, String> map = new HashMap<String, String>();
        int modOperationsTTL = 5;
        map.put("instance-modification", "P5D");
        int delOperationsTTL = 7;
        map.put("instance-deletion", "P7D");
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(map);
        this.processEngineConfiguration.initHistoryCleanup();
        Assert.assertNull((Object)this.processEngineConfiguration.getBatchOperationHistoryTimeToLive());
        Date startDate = ClockUtil.getCurrentTime();
        int daysInThePast = -11;
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        Batch modificationBatch = this.createModificationBatch();
        ArrayList<String> batchIds = new ArrayList<String>();
        batchIds.add(modificationBatch.getId());
        int migrationCountBatch = 10;
        ArrayList<String> batchIds1 = new ArrayList<String>();
        batchIds1.addAll(this.createMigrationBatchList(migrationCountBatch));
        int cancelationCountBatch = 20;
        ArrayList<String> batchIds2 = new ArrayList<String>();
        batchIds2.addAll(this.createCancelationBatchList(cancelationCountBatch));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-8));
        for (String batchId : batchIds) {
            this.managementService.deleteBatch(batchId, false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-2));
        for (i = 0; i < 4; ++i) {
            this.managementService.deleteBatch((String)batchIds1.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)(-delOperationsTTL)));
        for (i = 6; i < batchIds1.size(); ++i) {
            this.managementService.deleteBatch((String)batchIds1.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-10));
        for (i = 0; i < 7; ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-5));
        for (i = 7; i < 11; ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-1));
        for (i = 13; i < batchIds2.size(); ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)new Date());
        List historicList = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)31L, (long)historicList.size());
        List list = this.historyService.createCleanableHistoricBatchReport().list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (CleanableHistoricBatchReportResult result : list) {
            if (result.getBatchType().equals("instance-migration")) {
                this.checkResultNumbers(result, 0, 8, null);
                continue;
            }
            if (result.getBatchType().equals("instance-modification")) {
                this.checkResultNumbers(result, 1, 1, modOperationsTTL);
                continue;
            }
            if (!result.getBatchType().equals("instance-deletion")) continue;
            System.out.println(result);
            this.checkResultNumbers(result, delOperationsTTL, 18, delOperationsTTL);
        }
    }

    @Test
    public void testNoTTLConfiguration() {
        int i;
        this.processEngineConfiguration.initHistoryCleanup();
        Assert.assertNull((Object)this.processEngineConfiguration.getBatchOperationHistoryTimeToLive());
        Date startDate = ClockUtil.getCurrentTime();
        int daysInThePast = -11;
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        int cancelationCountBatch = 20;
        ArrayList<String> batchIds2 = new ArrayList<String>();
        batchIds2.addAll(this.createCancelationBatchList(cancelationCountBatch));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-10));
        for (i = 0; i < 7; ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-5));
        for (i = 7; i < 11; ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-1));
        for (i = 13; i < batchIds2.size(); ++i) {
            this.managementService.deleteBatch((String)batchIds2.get(i), false);
        }
        ClockUtil.setCurrentTime((Date)new Date());
        List historicList = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)20L, (long)historicList.size());
        Assert.assertEquals((long)1L, (long)this.historyService.createCleanableHistoricBatchReport().count());
        this.checkResultNumbers((CleanableHistoricBatchReportResult)this.historyService.createCleanableHistoricBatchReport().singleResult(), 0, 18, null);
    }

    @Test
    public void testZeroTTL() {
        HashMap<String, String> map = new HashMap<String, String>();
        int modOperationsTTL = 0;
        map.put("instance-modification", "P0D");
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(map);
        this.processEngineConfiguration.initHistoryCleanup();
        Date startDate = ClockUtil.getCurrentTime();
        int daysInThePast = -11;
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        Batch modificationBatch = this.createModificationBatch();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-7));
        this.managementService.deleteBatch(modificationBatch.getId(), false);
        CleanableHistoricBatchReportResult result = (CleanableHistoricBatchReportResult)this.historyService.createCleanableHistoricBatchReport().singleResult();
        Assert.assertNotNull((Object)result);
        this.checkResultNumbers(result, 1, 1, modOperationsTTL);
    }

    private void checkResultNumbers(CleanableHistoricBatchReportResult result, int expectedCleanable, int expectedFinished, Integer expectedTTL) {
        Assert.assertEquals((long)expectedCleanable, (long)result.getCleanableBatchesCount());
        Assert.assertEquals((long)expectedFinished, (long)result.getFinishedBatchesCount());
        Assert.assertEquals((Object)expectedTTL, (Object)result.getHistoryTimeToLive());
    }

    private BpmnModelInstance createModelInstance() {
        BpmnModelInstance instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").userTask("userTask1").sequenceFlowId("seq")).userTask("userTask2").endEvent("end").done();
        return instance;
    }

    private List<String> createMigrationBatchList(int migrationCountBatch) {
        ArrayList<String> batchIds = new ArrayList<String>();
        for (int i = 0; i < migrationCountBatch; ++i) {
            batchIds.add(this.migrationHelper.migrateProcessInstancesAsync(1).getId());
        }
        return batchIds;
    }

    private Batch createModificationBatch() {
        BpmnModelInstance instance = this.createModelInstance();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(instance);
        Batch modificationBatch = this.modificationHelper.startAfterAsync("process", 1, "userTask1", processDefinition.getId());
        return modificationBatch;
    }

    private List<String> createCancelationBatchList(int cancelationCountBatch) {
        ArrayList<String> batchIds = new ArrayList<String>();
        for (int i = 0; i < cancelationCountBatch; ++i) {
            batchIds.add(this.runtimeService.deleteProcessInstancesAsync(Arrays.asList("unknownId"), "create-deletion-batch").getId());
        }
        return batchIds;
    }
}

