/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class CleanableHistoricProcessInstanceReportTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule);
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected static final String PROCESS_DEFINITION_KEY = "HISTORIC_INST";
    protected static final String SECOND_PROCESS_DEFINITION_KEY = "SECOND_HISTORIC_INST";
    protected static final String THIRD_PROCESS_DEFINITION_KEY = "THIRD_HISTORIC_INST";
    protected static final String FOURTH_PROCESS_DEFINITION_KEY = "FOURTH_HISTORIC_INST";

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.testRule.deploy(this.createProcessWithUserTask(PROCESS_DEFINITION_KEY));
    }

    @After
    public void cleanUp() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.deleteTask(task.getId(), true);
        }
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
        }
    }

    protected BpmnModelInstance createProcessWithUserTask(String key) {
        return ((UserTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().userTask(key + "_task1").name(key + " Task 1")).endEvent().done();
    }

    protected void prepareProcessInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < instanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key);
            processInstanceIds.add(processInstance.getId());
        }
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    public void testReportComplex() {
        this.testRule.deploy(this.createProcessWithUserTask(SECOND_PROCESS_DEFINITION_KEY));
        this.testRule.deploy(this.createProcessWithUserTask(THIRD_PROCESS_DEFINITION_KEY));
        this.testRule.deploy(this.createProcessWithUserTask(FOURTH_PROCESS_DEFINITION_KEY));
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, 0, 5, 10);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 10);
        this.prepareProcessInstances(SECOND_PROCESS_DEFINITION_KEY, -6, 5, 10);
        this.prepareProcessInstances(THIRD_PROCESS_DEFINITION_KEY, -6, null, 10);
        this.prepareProcessInstances(FOURTH_PROCESS_DEFINITION_KEY, -6, 0, 10);
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(SECOND_PROCESS_DEFINITION_KEY).singleResult()).getId(), false);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        CleanableHistoricProcessInstanceReportResult secondReportResult = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(THIRD_PROCESS_DEFINITION_KEY).singleResult()).getId()}).singleResult();
        CleanableHistoricProcessInstanceReportResult thirdReportResult = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{FOURTH_PROCESS_DEFINITION_KEY}).singleResult();
        Assert.assertEquals((long)3L, (long)reportResults.size());
        for (CleanableHistoricProcessInstanceReportResult result : reportResults) {
            if (result.getProcessDefinitionKey().equals(PROCESS_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 10, 20);
                continue;
            }
            if (result.getProcessDefinitionKey().equals(THIRD_PROCESS_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 0, 10);
                continue;
            }
            if (!result.getProcessDefinitionKey().equals(FOURTH_PROCESS_DEFINITION_KEY)) continue;
            this.checkResultNumbers(result, 10, 10);
        }
        this.checkResultNumbers(secondReportResult, 0, 10);
        this.checkResultNumbers(thirdReportResult, 10, 10);
    }

    private void checkResultNumbers(CleanableHistoricProcessInstanceReportResult result, int expectedCleanable, int expectedFinished) {
        Assert.assertEquals((long)expectedCleanable, (long)result.getCleanableProcessInstanceCount());
        Assert.assertEquals((long)expectedFinished, (long)result.getFinishedProcessInstanceCount());
    }

    @Test
    public void testReportWithAllCleanableInstances() {
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        long count = this.historyService.createCleanableHistoricProcessInstanceReport().count();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals((long)1L, (long)count);
        this.checkResultNumbers((CleanableHistoricProcessInstanceReportResult)reportResults.get(0), 10, 10);
    }

    @Test
    public void testReportWithPartiallyCleanableInstances() {
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 5, 5);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, 0, 5, 5);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricProcessInstanceReportResult)reportResults.get(0), 5, 10);
    }

    @Test
    public void testReportWithZeroHistoryTTL() {
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, 0, 5);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, 0, 0, 5);
        CleanableHistoricProcessInstanceReportResult result = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().singleResult();
        this.checkResultNumbers(result, 10, 10);
    }

    @Test
    public void testReportWithNullHistoryTTL() {
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, -6, null, 5);
        this.prepareProcessInstances(PROCESS_DEFINITION_KEY, 0, null, 5);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricProcessInstanceReportResult)reportResults.get(0), 0, 10);
    }

    @Test
    public void testReportByInvalidProcessDefinitionId() {
        CleanableHistoricProcessInstanceReport report = this.historyService.createCleanableHistoricProcessInstanceReport();
        try {
            report.processDefinitionIdIn(new String[]{null});
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            report.processDefinitionIdIn(new String[]{"abc", null, "def"});
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testReportByInvalidProcessDefinitionKey() {
        CleanableHistoricProcessInstanceReport report = this.historyService.createCleanableHistoricProcessInstanceReport();
        try {
            report.processDefinitionKeyIn(new String[]{null});
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            report.processDefinitionKeyIn(new String[]{"abc", null, "def"});
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }
}

