/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DeploymentAwareJobExecutorForOracleTest {
    protected ProcessEngineBootstrapRule deploymentAwareBootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJobExecutorDeploymentAware(true);
            return configuration;
        }
    };
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.deploymentAwareBootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.deploymentAwareBootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Test
    public void testFindAcquirableJobsWhen0InstancesDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        this.findAcquirableJobs();
    }

    @Test
    public void testFindAcquirableJobsWhen1InstanceDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        this.findAcquirableJobs();
    }

    @Test
    public void testFindAcquirableJobsWhen1000InstancesDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        for (int i = 0; i < 1000; ++i) {
            this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        }
        this.findAcquirableJobs();
    }

    @Test
    public void testFindAcquirableJobsWhen1001InstancesDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        for (int i = 0; i < 1001; ++i) {
            this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        }
        this.findAcquirableJobs();
    }

    @Test
    public void testFindAcquirableJobsWhen2000InstancesDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        for (int i = 0; i < 2000; ++i) {
            this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        }
        this.findAcquirableJobs();
    }

    protected List<JobEntity> findAcquirableJobs() {
        return (List)this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<List<JobEntity>>(){

            public List<JobEntity> execute(CommandContext commandContext) {
                return commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
            }
        });
    }
}

