/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReport;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;

public class CleanableHistoricBatchReportImpl
extends AbstractQuery<CleanableHistoricBatchReport, CleanableHistoricBatchReportResult>
implements CleanableHistoricBatchReport {
    private static final long serialVersionUID = 1L;
    protected Date currentTimestamp;

    public CleanableHistoricBatchReportImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.checkPermissions(commandContext);
        return commandContext.getHistoricBatchManager().findCleanableHistoricBatchesReportCountByCriteria(this, HistoryCleanupHelper.getBatchOperationsForHistoryCleanup(commandContext));
    }

    @Override
    public List<CleanableHistoricBatchReportResult> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.checkPermissions(commandContext);
        return commandContext.getHistoricBatchManager().findCleanableHistoricBatchesReportByCriteria(this, page, HistoryCleanupHelper.getBatchOperationsForHistoryCleanup(commandContext));
    }

    public Date getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public void setCurrentTimestamp(Date currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
    }

    private void checkPermissions(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadHistoricBatch();
        }
    }
}

