/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.DefaultFailedJobParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.FailedJobParseRetryConf;
import org.camunda.bpm.engine.impl.calendar.DurationHelper;
import org.camunda.bpm.engine.impl.cmd.JobRetryCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.ParseUtil;

public class DefaultJobRetryCmd
extends JobRetryCmd {
    public static final List<String> SUPPORTED_TYPES = Arrays.asList("timer-transition", "timer-intermediate-transition", "timer-start-event", "timer-start-event-subprocess", "async-continuation");
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;

    public DefaultJobRetryCmd(String jobId, Throwable exception) {
        super(jobId, exception);
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity job = this.getJob();
        ActivityImpl activity = this.getCurrentActivity(commandContext, job);
        String globalFailedJobRetryTimeCycle = commandContext.getProcessEngineConfiguration().getFailedJobRetryTimeCycle();
        if (activity == null && globalFailedJobRetryTimeCycle == null) {
            LOG.debugFallbackToDefaultRetryStrategy();
            this.executeStandardStrategy(commandContext);
        } else {
            try {
                this.executeCustomStrategy(commandContext, job, activity);
            }
            catch (Exception e) {
                LOG.debugFallbackToDefaultRetryStrategy();
                this.executeStandardStrategy(commandContext);
            }
        }
        return null;
    }

    protected void executeStandardStrategy(CommandContext commandContext) {
        JobEntity job = this.getJob();
        if (job != null) {
            job.unlock();
            this.logException(job);
            this.decrementRetries(job);
            this.notifyAcquisition(commandContext);
        } else {
            LOG.debugFailedJobNotFound(this.jobId);
        }
    }

    protected void executeCustomStrategy(CommandContext commandContext, JobEntity job, ActivityImpl activity) throws Exception {
        String failedJobRetryTimeCycle = null;
        List<String> retryIntervals = null;
        if (activity != null) {
            FailedJobParseRetryConf failedJobParseRetryConf = activity.getProperties().get(DefaultFailedJobParseListener.FAILED_JOB_CONFIGURATION);
            if (failedJobParseRetryConf.hasIntervals()) {
                retryIntervals = failedJobParseRetryConf.getRetryIntervals();
            } else {
                failedJobRetryTimeCycle = this.getFailedJobRetryTimeCycle(job, failedJobParseRetryConf.getRetryCycle());
                if (failedJobRetryTimeCycle.contains(",")) {
                    retryIntervals = ParseUtil.parseRetryIntervals(failedJobRetryTimeCycle);
                }
            }
        }
        if (failedJobRetryTimeCycle == null && retryIntervals == null) {
            this.executeStandardStrategy(commandContext);
        } else {
            DurationHelper durationHelper = this.getDurationHelper(job, failedJobRetryTimeCycle, retryIntervals);
            job.setLockExpirationTime(durationHelper.getDateAfter());
            if (this.isFirstJobExecution(job) && retryIntervals == null) {
                this.initializeRetries(job, durationHelper.getTimes());
            } else {
                LOG.debugDecrementingRetriesForJob(job.getId());
            }
            this.logException(job);
            this.decrementRetries(job);
            this.notifyAcquisition(commandContext);
        }
    }

    protected ActivityImpl getCurrentActivity(CommandContext commandContext, JobEntity job) {
        String type = job.getJobHandlerType();
        ActivityImpl activity = null;
        if (SUPPORTED_TYPES.contains(type)) {
            DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
            ProcessDefinitionEntity processDefinitionEntity = deploymentCache.findDeployedProcessDefinitionById(job.getProcessDefinitionId());
            activity = processDefinitionEntity.findActivity(job.getActivityId());
        }
        return activity;
    }

    protected ExecutionEntity fetchExecutionEntity(String executionId) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(executionId);
    }

    protected String getFailedJobRetryTimeCycle(JobEntity job, Expression expression) {
        String executionId = job.getExecutionId();
        ExecutionEntity execution = null;
        if (executionId != null) {
            execution = this.fetchExecutionEntity(executionId);
        }
        Object value = null;
        if (expression == null) {
            return null;
        }
        try {
            value = expression.getValue(execution);
        }
        catch (Exception e) {
            LOG.exceptionWhileParsingExpression(this.jobId, e.getCause().getMessage());
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected DurationHelper getDurationHelper(JobEntity job, String failedJobRetryTimeCycle, List<String> retryIntervals) throws Exception {
        DurationHelper durationHelper = null;
        if (retryIntervals == null || retryIntervals.isEmpty()) {
            durationHelper = this.getDurationHelper(failedJobRetryTimeCycle);
        } else {
            if (this.isFirstJobExecution(job)) {
                this.initializeRetries(job, retryIntervals.size());
            }
            durationHelper = retryIntervals.size() >= job.getRetries() ? this.getDurationHelper(retryIntervals.get(retryIntervals.size() - job.getRetries())) : this.getDurationHelper(retryIntervals.get(retryIntervals.size() - 1));
        }
        return durationHelper;
    }

    protected DurationHelper getDurationHelper(String failedJobRetryTimeCycle) throws Exception {
        return new DurationHelper(failedJobRetryTimeCycle);
    }

    protected boolean isFirstJobExecution(JobEntity job) {
        return job.getExceptionByteArrayId() == null && job.getExceptionMessage() == null;
    }

    protected void initializeRetries(JobEntity job, int retries) {
        LOG.debugInitiallyAppyingRetryCycleForJob(job.getId(), retries);
        job.setRetries(retries);
    }
}

